/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class JMS390FloatSupport {
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long DOUBLE_MANTISSA_MSB_MASK = 0x10000000000000L;
    private static final long DOUBLE_BIAS = 1022L;
    private static final int S390_DOUBLE_BIAS = 64;
    private static final long S390_DOUBLE_EXPONENT_MASK = 0x7F00000000000000L;
    private static final long S390_DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int FLOAT_EXPONENT_MASK = 2139095040;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_MANTISSA_MSB_MASK = 0x800000;
    private static final int FLOAT_BIAS = 126;
    private static final int S390_FLOAT_BIAS = 64;
    private static final int S390_FLOAT_EXPONENT_MASK = 0x7F000000;
    private static final int S390_FLOAT_MANTISSA_MASK = 0xFFFFFF;
    private static TraceComponent tc = SibTr.register(JMS390FloatSupport.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    protected static final long doubleToS390LongBits(double ieeeDouble) throws IOException {
        long quotient;
        boolean positive;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doubleToS390LongBits", (Object)ieeeDouble);
        }
        long ieeeLongBits = Double.doubleToLongBits(ieeeDouble);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("IEEE double bit pattern= " + Long.toString(ieeeLongBits, 16)));
        }
        boolean bl = positive = (ieeeLongBits & Long.MIN_VALUE) == 0L;
        if ((ieeeLongBits & Long.MAX_VALUE) == 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"zero");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"doubleToS390LongBits", (Object)ieeeLongBits);
            }
            return ieeeLongBits;
        }
        long exponent = ieeeLongBits & 0x7FF0000000000000L;
        exponent >>>= 52;
        long mantissa = ieeeLongBits & 0xFFFFFFFFFFFFFL;
        long remainder = Math.abs(exponent -= 1022L) % 4L;
        long s390Exponent = quotient = Math.abs(exponent) / 4L;
        if (exponent > 0L && remainder != 0L) {
            ++s390Exponent;
        }
        if (exponent < 0L) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64L;
        long s390Mantissa = mantissa;
        s390Mantissa = exponent > -1022L ? (s390Mantissa |= 0x10000000000000L) : (s390Mantissa <<= 1);
        s390Mantissa <<= 3;
        if (remainder > 0L) {
            if (exponent > 0L) {
                int shift_places = (int)(4L - remainder);
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -1022L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                s390Mantissa >>>= (int)remainder;
            }
        }
        if (exponent == -1022L) {
            while (s390Mantissa != 0L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        if (s390Exponent > 127L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Exponent = " + s390Exponent));
            }
            throw new IOException("Number outside of range for double precision S/390 Float");
        }
        if (s390Exponent < 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Number too small to represent, rounding to zero");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"doubleToS390LongBits", (Object)0L);
            }
            return 0L;
        }
        long s390Double = 0L;
        long s390ExponentBits = s390Exponent & 0x7FL;
        s390Double = s390ExponentBits << 56;
        if (!positive) {
            s390Double |= Long.MIN_VALUE;
        }
        s390Double |= s390Mantissa;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("S390 bit pattern = " + Long.toString(s390Double, 16)));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doubleToS390LongBits", (Object)s390Double);
        }
        return s390Double;
    }

    protected static final int floatToS390IntBits(float ieeeFloat) throws IOException {
        int quotient;
        boolean positive;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"floatToS390IntBits", (Object)Float.valueOf(ieeeFloat));
        }
        int ieeeIntBits = Float.floatToIntBits(ieeeFloat);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("IEEE bit pattern = " + Integer.toString(ieeeIntBits, 16)));
        }
        boolean bl = positive = (ieeeIntBits & Integer.MIN_VALUE) == 0;
        if ((ieeeIntBits & Integer.MAX_VALUE) == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"zero");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"floatToS390IntBits", (Object)ieeeIntBits);
            }
            return ieeeIntBits;
        }
        int exponent = ieeeIntBits & 0x7F800000;
        exponent >>>= 23;
        int mantissa = ieeeIntBits & 0x7FFFFF;
        if ((exponent -= 126) > -126) {
            mantissa |= 0x800000;
        }
        int remainder = Math.abs(exponent) % 4;
        int s390Exponent = quotient = Math.abs(exponent) / 4;
        if (exponent > 0 && remainder != 0) {
            ++s390Exponent;
        }
        if (exponent < 0) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64;
        int s390Mantissa = mantissa;
        if (remainder > 0) {
            int shift_places;
            if (exponent > 0) {
                shift_places = 4 - remainder;
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -126 && (s390Mantissa & 0xF00000) == 0) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                shift_places = remainder;
                s390Mantissa >>>= shift_places;
            }
        }
        if (exponent == -126) {
            s390Mantissa <<= 1;
            while (s390Mantissa != 0 && (s390Mantissa & 0xF00000) == 0) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        int s390Float = 0;
        int s390ExponentBits = s390Exponent & 0x7F;
        s390Float = s390ExponentBits << 24;
        if (!positive) {
            s390Float |= Integer.MIN_VALUE;
        }
        s390Float |= s390Mantissa;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("S390 Bit pattern = " + Integer.toString(s390Float, 16)));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"floatToS390IntBits", (Object)s390Float);
        }
        return s390Float;
    }

    protected static final float intS390BitsToFloat(int floatBits) throws IOException {
        boolean positive;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"intS390BitsToFloat", (Object)floatBits);
        }
        boolean bl = positive = (floatBits & Integer.MIN_VALUE) == 0;
        if ((floatBits & Integer.MAX_VALUE) == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"zero");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"intS390BitsToFloat");
            }
            if (positive) {
                return 0.0f;
            }
            return -0.0f;
        }
        int mantissa = floatBits & 0xFFFFFF;
        int exponent = floatBits & 0x7F000000;
        exponent >>= 24;
        int ieeeExponent = (exponent -= 64) * 4;
        int ieeeMantissa = mantissa;
        if (ieeeExponent <= -126) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -126) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0 && (ieeeMantissa & 0x800000) == 0 && ieeeExponent > -126) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -149) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"underflow, returning zero");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"intS390BitsToFloat", (Object)Float.valueOf(0.0f));
            }
            return 0.0f;
        }
        if (ieeeExponent > 128) {
            if (positive) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"overflow, returning +INFINITY");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"intS390BitsToFloat", (Object)"+infinity");
                }
                return Float.POSITIVE_INFINITY;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"overflow, returning -INFINITY");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"intS390BitsToFloat", (Object)"-infinity");
            }
            return Float.NEGATIVE_INFINITY;
        }
        int ieeeBits = 0;
        if (!positive) {
            ieeeBits |= Integer.MIN_VALUE;
        }
        ieeeExponent += 126;
        ieeeBits |= (ieeeExponent <<= 23);
        ieeeBits |= (ieeeMantissa &= 0x7FFFFF);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("IEEE Bit pattern = " + Integer.toString(ieeeBits, 16)));
        }
        float result = Float.intBitsToFloat(ieeeBits);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"intS390BitsToFloat", (Object)Float.valueOf(result));
        }
        return result;
    }

    protected static final double longS390BitsToDouble(long doubleBits) throws IOException {
        boolean positive;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"longS390BitsToDouble", (Object)doubleBits);
        }
        boolean bl = positive = (doubleBits & Long.MIN_VALUE) == 0L;
        if ((doubleBits & Long.MAX_VALUE) == 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"zero");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"longS390BitsToDouble");
            }
            if (positive) {
                return 0.0;
            }
            return -0.0;
        }
        long mantissa = doubleBits & 0xFFFFFFFFFFFFFFL;
        long exponent = doubleBits & 0x7F00000000000000L;
        exponent >>= 56;
        long ieeeExponent = (exponent -= 64L) * 4L;
        long ieeeMantissa = mantissa;
        ieeeMantissa >>= 3;
        if (ieeeExponent <= -1022L) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -1022L) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0L && (ieeeMantissa & 0x10000000000000L) == 0L && ieeeExponent > -1022L) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -1045L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"longS390BitsToDouble", (Object)"underflow");
            }
            return 0.0;
        }
        if (ieeeExponent > 1024L) {
            if (positive) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"overflow - returning +INFINITY");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"longS390BitsToDouble", (Object)"+infinity");
                }
                return Double.POSITIVE_INFINITY;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"overflow - returning -INFINITY");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"longS390BitsToDouble", (Object)"-infinity");
            }
            return Double.NEGATIVE_INFINITY;
        }
        long ieeeBits = 0L;
        if (!positive) {
            ieeeBits |= Long.MIN_VALUE;
        }
        ieeeExponent += 1022L;
        ieeeBits |= (ieeeExponent <<= 52);
        ieeeBits |= (ieeeMantissa &= 0xFFFFFFFFFFFFFL);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("IEEE bit pattern = " + Long.toString(ieeeBits, 16)));
        }
        double result = Double.longBitsToDouble(ieeeBits);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"longS390BitsToDouble", (Object)result);
        }
        return result;
    }
}

