/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.JmsSharedUtils;
import com.ibm.ws.sib.api.jms.ReportMessageConverter;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import javax.jms.JMSException;

public class ReportMessageConverterImpl
implements ReportMessageConverter {
    private static JmsSharedUtils utils = null;
    private static TraceComponent tc = SibTr.register(ReportMessageConverterImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    public static final byte byte_REPORT_NO_DATA = SIApiConstants.REPORT_NO_DATA;
    public static final byte byte_REPORT_WITH_DATA = SIApiConstants.REPORT_WITH_DATA;
    public static final byte byte_REPORT_WITH_FULL_DATA = SIApiConstants.REPORT_WITH_FULL_DATA;
    public static final byte byte_REPORT_EXPIRY = SIApiConstants.REPORT_EXPIRY.byteValue();
    public static final byte byte_REPORT_EXCEPTION = SIApiConstants.REPORT_EXCEPTION.byteValue();
    public static final byte byte_REPORT_COA = SIApiConstants.REPORT_COA.byteValue();
    public static final byte byte_REPORT_COD = SIApiConstants.REPORT_COD.byteValue();
    public static final byte byte_REPORT_PAN = SIApiConstants.REPORT_PAN.byteValue();
    public static final byte byte_REPORT_NAN = SIApiConstants.REPORT_NAN.byteValue();

    @Override
    public void setIntegerReportOption(String propName, int propValue, SIBusMessage coreMsg) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setIntegerReportOption", (Object)new Object[]{propName, propValue, coreMsg});
        }
        if (propName.equals("JMS_IBM_Report_Exception")) {
            Byte newVal = null;
            switch (propValue) {
                case 0x1000000: {
                    newVal = SIApiConstants.REPORT_NO_DATA;
                    break;
                }
                case 0x3000000: {
                    newVal = SIApiConstants.REPORT_WITH_DATA;
                    break;
                }
                case 0x7000000: {
                    newVal = SIApiConstants.REPORT_WITH_FULL_DATA;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{propName, "" + propValue}, tc);
                }
            }
            coreMsg.setReportException(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("REPORT_EXCEPTION set to : " + newVal));
            }
        } else if (propName.equals("JMS_IBM_Report_Expiration")) {
            Byte newVal = null;
            switch (propValue) {
                case 0x200000: {
                    newVal = SIApiConstants.REPORT_NO_DATA;
                    break;
                }
                case 0x600000: {
                    newVal = SIApiConstants.REPORT_WITH_DATA;
                    break;
                }
                case 0xE00000: {
                    newVal = SIApiConstants.REPORT_WITH_FULL_DATA;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{propName, "" + propValue}, tc);
                }
            }
            coreMsg.setReportExpiry(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("REPORT_EXPIRATION set to : " + newVal));
            }
        } else if (propName.equals("JMS_IBM_Report_COA")) {
            Byte newVal = null;
            switch (propValue) {
                case 256: {
                    newVal = SIApiConstants.REPORT_NO_DATA;
                    break;
                }
                case 768: {
                    newVal = SIApiConstants.REPORT_WITH_DATA;
                    break;
                }
                case 1792: {
                    newVal = SIApiConstants.REPORT_WITH_FULL_DATA;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{propName, "" + propValue}, tc);
                }
            }
            coreMsg.setReportCOA(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("REPORT_COA set to : " + newVal));
            }
        } else if (propName.equals("JMS_IBM_Report_COD")) {
            Byte newVal = null;
            switch (propValue) {
                case 2048: {
                    newVal = SIApiConstants.REPORT_NO_DATA;
                    break;
                }
                case 6144: {
                    newVal = SIApiConstants.REPORT_WITH_DATA;
                    break;
                }
                case 14336: {
                    newVal = SIApiConstants.REPORT_WITH_FULL_DATA;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{propName, "" + propValue}, tc);
                }
            }
            coreMsg.setReportCOD(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("REPORT_COD set to : " + newVal));
            }
        } else if (propName.equals("JMS_IBM_Report_PAN")) {
            Boolean newVal = null;
            switch (propValue) {
                case 1: {
                    newVal = true;
                    break;
                }
                case 0: {
                    newVal = false;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{propName, "" + propValue}, tc);
                }
            }
            coreMsg.setReportPAN(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("REPORT_PAN set to : " + newVal));
            }
        } else if (propName.equals("JMS_IBM_Report_NAN")) {
            Boolean newVal = null;
            switch (propValue) {
                case 2: {
                    newVal = true;
                    break;
                }
                case 0: {
                    newVal = false;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{propName, "" + propValue}, tc);
                }
            }
            coreMsg.setReportNAN(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("REPORT_NAN set to : " + newVal));
            }
        } else if (propName.equals("JMS_IBM_Report_Pass_Msg_ID")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"propName equals REPORT_MSGID_PROPERTY");
            }
            Boolean newVal = null;
            switch (propValue) {
                case 128: {
                    newVal = true;
                    break;
                }
                case 0: {
                    newVal = false;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{propName, "" + propValue}, tc);
                }
            }
            coreMsg.setReportPassMsgId(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("REPORT_MSGID set to : " + newVal));
            }
        } else if (propName.equals("JMS_IBM_Report_Pass_Correl_ID")) {
            Boolean newVal = null;
            switch (propValue) {
                case 64: {
                    newVal = true;
                    break;
                }
                case 0: {
                    newVal = false;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{propName, "" + propValue}, tc);
                }
            }
            coreMsg.setReportPassCorrelId(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("REPORT_CORRELID set to : " + newVal));
            }
        } else if (propName.equals("JMS_IBM_Report_Discard_Msg")) {
            Boolean newVal = null;
            switch (propValue) {
                case 0x8000000: {
                    newVal = true;
                    break;
                }
                case 0: {
                    newVal = false;
                    break;
                }
                default: {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0321", new Object[]{propName, "" + propValue}, tc);
                }
            }
            coreMsg.setReportDiscardMsg(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("REPORT_DISCARD set to : " + newVal));
            }
        } else if (propName.equals("JMS_IBM_Feedback")) {
            if (utils == null) {
                utils = JmsInternalsFactory.getSharedUtils();
            }
            Integer newVal = utils.convertMQFeedbackToJS(propValue);
            coreMsg.setReportFeedback(newVal);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("FEEDBACK_PROPERTY set to : " + newVal));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setIntegerReportOption");
        }
    }

    @Override
    public Object getReportOption(String propName, SIBusMessage coreMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReportOption", (Object)new Object[]{propName, coreMsg});
        }
        Integer result = null;
        if (propName.equals("JMS_IBM_Report_Exception")) {
            Byte value = coreMsg.getReportException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Byte returned from core message getReportException():" + value));
            }
            if (value != null) {
                byte propValue = value;
                if (propValue == byte_REPORT_NO_DATA) {
                    result = 0x1000000;
                } else if (propValue == byte_REPORT_WITH_DATA) {
                    result = 0x3000000;
                } else if (propValue == byte_REPORT_WITH_FULL_DATA) {
                    result = 0x7000000;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unexpected property value received: " + value));
                    }
                    result = null;
                }
            }
        } else if (propName.equals("JMS_IBM_Report_Expiration")) {
            Byte value = coreMsg.getReportExpiry();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Byte returned from core message getReportExpiry():" + value));
            }
            if (value != null) {
                byte propValue = value;
                if (propValue == byte_REPORT_NO_DATA) {
                    result = 0x200000;
                } else if (propValue == byte_REPORT_WITH_DATA) {
                    result = 0x600000;
                } else if (propValue == byte_REPORT_WITH_FULL_DATA) {
                    result = 0xE00000;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unexpected property value received: " + value));
                    }
                    result = null;
                }
            }
        } else if (propName.equals("JMS_IBM_Report_COA")) {
            Byte value = coreMsg.getReportCOA();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Byte returned from core message getReportCOA():" + value));
            }
            if (value != null) {
                byte propValue = value;
                if (propValue == byte_REPORT_NO_DATA) {
                    result = 256;
                } else if (propValue == byte_REPORT_WITH_DATA) {
                    result = 768;
                } else if (propValue == byte_REPORT_WITH_FULL_DATA) {
                    result = 1792;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unexpected property value received: " + value));
                    }
                    result = null;
                }
            }
        } else if (propName.equals("JMS_IBM_Report_COD")) {
            Byte value = coreMsg.getReportCOD();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Byte returned from core message getReportCOD():" + value));
            }
            if (value != null) {
                byte propValue = value;
                if (propValue == byte_REPORT_NO_DATA) {
                    result = 2048;
                } else if (propValue == byte_REPORT_WITH_DATA) {
                    result = 6144;
                } else if (propValue == byte_REPORT_WITH_FULL_DATA) {
                    result = 14336;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unexpected property value received: " + value));
                    }
                    result = null;
                }
            }
        } else if (propName.equals("JMS_IBM_Report_PAN")) {
            Boolean value = coreMsg.getReportPAN();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Boolean returned from core message getReportPAN():" + value));
            }
            if (value != null) {
                boolean propValue = value;
                result = propValue ? Integer.valueOf(1) : Integer.valueOf(0);
            }
        } else if (propName.equals("JMS_IBM_Report_NAN")) {
            Boolean value = coreMsg.getReportNAN();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Boolean returned from core message getReportNAN():" + value));
            }
            if (value != null) {
                boolean propValue = value;
                result = propValue ? Integer.valueOf(2) : Integer.valueOf(0);
            }
        } else if (propName.equals("JMS_IBM_Report_Pass_Msg_ID")) {
            Boolean value = coreMsg.getReportPassMsgId();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Boolean returned from core message getReportPassMsgId():" + value));
            }
            if (value != null) {
                boolean propValue = value;
                result = propValue ? Integer.valueOf(128) : Integer.valueOf(0);
            }
        } else if (propName.equals("JMS_IBM_Report_Pass_Correl_ID")) {
            Boolean value = coreMsg.getReportPassCorrelId();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Boolean returned from core message getReportPassCorrelId():" + value));
            }
            if (value != null) {
                boolean propValue = value;
                result = propValue ? Integer.valueOf(64) : Integer.valueOf(0);
            }
        } else if (propName.equals("JMS_IBM_Report_Discard_Msg")) {
            Boolean value = coreMsg.getReportDiscardMsg();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Boolean returned from core message getReportDiscardMsg():" + value));
            }
            if (value != null) {
                boolean propValue = value;
                result = propValue ? Integer.valueOf(0x8000000) : Integer.valueOf(0);
            }
        } else if (propName.equals("JMS_IBM_Feedback")) {
            Integer value = coreMsg.getReportFeedback();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Byte returned from core message getReportFeedback():" + value));
            }
            if (value != null) {
                if (utils == null) {
                    try {
                        utils = JmsInternalsFactory.getSharedUtils();
                    }
                    catch (JMSException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.impl.ReportMessageConverter", (String)"getReportOption#1", (Object[])new Object[]{propName, coreMsg});
                        return null;
                    }
                }
                result = utils.convertJSFeedbackToMQ((int)value);
            }
        } else if (propName.equals("JMS_IBM_MsgType")) {
            Integer value = coreMsg.getReportFeedback();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Value returned from core message getReportFeedback():" + value));
            }
            if (value != null) {
                int propValue = value;
                if (propValue != 0) {
                    result = 4;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"byte returned from getReportFeedback() is not one of the expected values");
                    }
                    result = null;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReportOption", (Object)result);
        }
        return result;
    }
}

