/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.app;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.dd.app.Module;
import com.ibm.ws.javaee.dd.common.Description;
import com.ibm.ws.javaee.dd.common.DisplayName;
import com.ibm.ws.javaee.dd.common.Icon;
import com.ibm.ws.javaee.dd.common.MessageDestination;
import com.ibm.ws.javaee.dd.common.SecurityRole;
import com.ibm.ws.javaee.ddmodel.AnySimpleType;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.TokenType;
import com.ibm.ws.javaee.ddmodel.common.DescriptionType;
import com.ibm.ws.javaee.ddmodel.common.DisplayNameType;
import com.ibm.ws.javaee.ddmodel.common.IconType;
import com.ibm.ws.javaee.ddmodel.common.JNDIEnvironmentRefs;
import com.ibm.ws.javaee.ddmodel.common.MessageDestinationType;
import com.ibm.ws.javaee.ddmodel.common.SecurityRoleType;
import com.ibm.ws.javaee.ddmodel.common.XSDBooleanType;
import com.ibm.ws.javaee.ddmodel.common.XSDTokenType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ApplicationType
extends JNDIEnvironmentRefs
implements Application,
DDParser.RootParsable {
    TokenType version;
    XSDTokenType application_name;
    DescriptionType.ListType description;
    DisplayNameType.ListType display_name;
    IconType.ListType icon;
    GenericBooleanType initialize_in_order;
    ModuleType.ListType module = new ModuleType.ListType();
    SecurityRoleType.ListType security_role;
    XSDTokenType library_directory;
    MessageDestinationType.ListType message_destination;
    Map<XSDTokenType, WebType> contextRootToWebMap;
    Map<XSDTokenType, SecurityRoleType> roleNameToSecurityRoleMap;
    final String path;
    DDParser.ComponentIDMap idMap;
    static final long serialVersionUID = -3971088979249128444L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ApplicationType(String path) {
        this.path = path;
    }

    public String getDeploymentDescriptorPath() {
        return this.path;
    }

    public Object getComponentForId(String id) {
        return this.idMap.getComponentForId(id);
    }

    public String getIdForComponent(Object ddComponent) {
        return this.idMap.getIdForComponent(ddComponent);
    }

    public String getVersion() {
        return this.version.getValue();
    }

    public String getApplicationName() {
        return this.application_name != null ? this.application_name.getValue() : null;
    }

    public List<Description> getDescriptions() {
        if (this.description != null) {
            return this.description.getList();
        }
        return Collections.emptyList();
    }

    public List<DisplayName> getDisplayNames() {
        if (this.display_name != null) {
            return this.display_name.getList();
        }
        return Collections.emptyList();
    }

    public List<Icon> getIcons() {
        if (this.icon != null) {
            return this.icon.getList();
        }
        return Collections.emptyList();
    }

    public boolean isSetInitializeInOrder() {
        return AnySimpleType.isSet(this.initialize_in_order);
    }

    public boolean isInitializeInOrder() {
        if (this.initialize_in_order != null) {
            return this.initialize_in_order.getBooleanValue();
        }
        return false;
    }

    public List<Module> getModules() {
        return this.module.getList();
    }

    public List<SecurityRole> getSecurityRoles() {
        if (this.security_role != null) {
            return this.security_role.getList();
        }
        return Collections.emptyList();
    }

    public String getLibraryDirectory() {
        return this.library_directory != null ? this.library_directory.getValue() : null;
    }

    public List<MessageDestination> getMessageDestinations() {
        if (this.message_destination != null) {
            return this.message_destination.getList();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isIdAllowed() {
        return true;
    }

    @Override
    public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws DDParser.ParseException {
        if (nsURI == null && parser.version >= 14 && "version".equals(localName)) {
            this.version = parser.parseTokenAttributeValue(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
        if (super.handleChild(parser, localName)) {
            return true;
        }
        if ("application-name".equals(localName)) {
            XSDTokenType application_name = new XSDTokenType();
            parser.parse(application_name);
            this.application_name = application_name;
            return true;
        }
        if ("description".equals(localName)) {
            DescriptionType description = new DescriptionType();
            parser.parse(description);
            this.addDescription(description);
            return true;
        }
        if ("display-name".equals(localName)) {
            DisplayNameType display_name = new DisplayNameType();
            parser.parse(display_name);
            this.addDisplayName(display_name);
            return true;
        }
        if ("icon".equals(localName)) {
            IconType icon = new IconType();
            parser.parse(icon);
            this.addIcon(icon);
            return true;
        }
        if ("initialize-in-order".equals(localName)) {
            GenericBooleanType initialize_in_order = new GenericBooleanType();
            parser.parse(initialize_in_order);
            this.initialize_in_order = initialize_in_order;
            return true;
        }
        if ("module".equals(localName)) {
            ModuleType module = new ModuleType();
            parser.parse(module);
            this.module.add(module);
            return true;
        }
        if ("security-role".equals(localName)) {
            SecurityRoleType security_role = new SecurityRoleType();
            parser.parse(security_role);
            this.addSecurityRole(security_role);
            return true;
        }
        if ("library-directory".equals(localName)) {
            XSDTokenType library_directory = new XSDTokenType();
            parser.parse(library_directory);
            this.library_directory = library_directory;
            return true;
        }
        if ("message-destination".equals(localName)) {
            MessageDestinationType message_destination = new MessageDestinationType();
            parser.parse(message_destination);
            this.addMessageDestination(message_destination);
            return true;
        }
        return false;
    }

    private void addDescription(DescriptionType description) {
        if (this.description == null) {
            this.description = new DescriptionType.ListType();
        }
        this.description.add(description);
    }

    private void addDisplayName(DisplayNameType display_name) {
        if (this.display_name == null) {
            this.display_name = new DisplayNameType.ListType();
        }
        this.display_name.add(display_name);
    }

    private void addIcon(IconType icon) {
        if (this.icon == null) {
            this.icon = new IconType.ListType();
        }
        this.icon.add(icon);
    }

    private void addSecurityRole(SecurityRoleType security_role) {
        if (this.security_role == null) {
            this.security_role = new SecurityRoleType.ListType();
        }
        this.security_role.add(security_role);
    }

    private void addMessageDestination(MessageDestinationType message_destination) {
        if (this.message_destination == null) {
            this.message_destination = new MessageDestinationType.ListType();
        }
        this.message_destination.add(message_destination);
    }

    @Override
    public void finish(DDParser parser) throws DDParser.ParseException {
        if (this.version == null) {
            if (parser.version < 14) {
                this.version = parser.parseToken(parser.version == 12 ? "1.2" : "1.3");
            } else {
                throw new DDParser.ParseException(parser.requiredAttributeMissing("version"));
            }
        }
        this.idMap = parser.idMap;
    }

    @Override
    public void describe(DDParser.Diagnostics diag) {
        diag.describe("version", this.version);
        diag.describeIfSet("application-name", this.application_name);
        diag.describeIfSet("description", this.description);
        diag.describeIfSet("display-name", this.display_name);
        diag.describeIfSet("icon", this.icon);
        diag.describeIfSet("initialize-in-order", this.initialize_in_order);
        diag.describe("module", this.module);
        diag.describeIfSet("security-role", this.security_role);
        diag.describeIfSet("library-directory", this.library_directory);
        super.describe(diag);
        diag.describeIfSet("message-destination", this.message_destination);
    }

    @Override
    protected String toTracingSafeString() {
        return "application";
    }

    @Override
    public void describe(StringBuilder sb) {
        DDParser.Diagnostics diag = new DDParser.Diagnostics(this.idMap, sb);
        diag.describe(this.toTracingSafeString(), this);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationType.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class GenericBooleanType
    extends XSDBooleanType {
        static final long serialVersionUID = 2115552047071797690L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        protected void setValueFromLexical(DDParser parser, String lexical) throws DDParser.ParseException {
            if ("true".equals(lexical) || "yes".equals(lexical)) {
                this.value = Boolean.TRUE;
            } else if ("false".equals(lexical) || "no".equals(lexical)) {
                this.value = Boolean.FALSE;
            } else {
                throw new DDParser.ParseException(parser.invalidEnumValue(lexical, "true", "yes", "false", "no"));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(GenericBooleanType.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class WebType
    extends DDParser.ElementContentParsable {
        XSDTokenType web_uri = new XSDTokenType();
        XSDTokenType context_root = new XSDTokenType();
        static final long serialVersionUID = 405218074275088476L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public boolean isIdAllowed() {
            return true;
        }

        @Override
        public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
            if ("web-uri".equals(localName)) {
                parser.parse(this.web_uri);
                return true;
            }
            if ("context-root".equals(localName)) {
                parser.parse(this.context_root);
                return true;
            }
            return false;
        }

        @Override
        public void describe(DDParser.Diagnostics diag) {
            diag.describe("web-uri", this.web_uri);
            diag.describe("context-root", this.context_root);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WebType.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class ModuleType
    extends DDParser.ElementContentParsable
    implements Module {
        ModuleTypeEnum choiceType;
        DDParser.ParsableElement choice;
        XSDTokenType alt_dd;
        static final long serialVersionUID = -2739287402758705679L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public int getModuleType() {
            switch (this.choiceType) {
                case CONNECTOR: {
                    return 0;
                }
                case EJB: {
                    return 1;
                }
                case JAVA: {
                    return 2;
                }
            }
            return 3;
        }

        public String getModulePath() {
            if (this.choiceType == ModuleTypeEnum.WEB) {
                return ((WebType)this.choice).web_uri.getValue();
            }
            return ((XSDTokenType)this.choice).getValue();
        }

        public String getContextRoot() {
            return this.choiceType == ModuleTypeEnum.WEB ? ((WebType)this.choice).context_root.getValue() : null;
        }

        public String getAltDD() {
            return this.alt_dd != null ? this.alt_dd.getValue() : null;
        }

        @Override
        public boolean isIdAllowed() {
            return true;
        }

        @Override
        public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
            if ("connector".equals(localName)) {
                XSDTokenType connector = new XSDTokenType();
                parser.parse(connector);
                this.choiceType = ModuleTypeEnum.CONNECTOR;
                this.choice = connector;
                return true;
            }
            if ("ejb".equals(localName)) {
                XSDTokenType ejb = new XSDTokenType();
                parser.parse(ejb);
                this.choiceType = ModuleTypeEnum.EJB;
                this.choice = ejb;
                return true;
            }
            if ("java".equals(localName)) {
                XSDTokenType java = new XSDTokenType();
                parser.parse(java);
                this.choiceType = ModuleTypeEnum.JAVA;
                this.choice = java;
                return true;
            }
            if ("web".equals(localName)) {
                WebType web = new WebType();
                parser.parse(web);
                this.choiceType = ModuleTypeEnum.WEB;
                this.choice = web;
                return true;
            }
            if ("alt-dd".equals(localName)) {
                XSDTokenType alt_dd = new XSDTokenType();
                parser.parse(alt_dd);
                this.alt_dd = alt_dd;
                return true;
            }
            return false;
        }

        @Override
        public void describe(DDParser.Diagnostics diag) {
            if (this.choice != null) {
                switch (this.choiceType) {
                    case CONNECTOR: {
                        diag.describe("connector", this.choice);
                        break;
                    }
                    case EJB: {
                        diag.describe("ejb", this.choice);
                        break;
                    }
                    case JAVA: {
                        diag.describe("java", this.choice);
                        break;
                    }
                    case WEB: {
                        diag.describe("web", this.choice);
                    }
                }
            }
            diag.describeIfSet("alt-dd", this.alt_dd);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleType.class);
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        public static final class ModuleTypeEnum
        extends Enum<ModuleTypeEnum> {
            public static final /* enum */ ModuleTypeEnum CONNECTOR;
            public static final /* enum */ ModuleTypeEnum EJB;
            public static final /* enum */ ModuleTypeEnum JAVA;
            public static final /* enum */ ModuleTypeEnum WEB;
            private static final /* synthetic */ ModuleTypeEnum[] $VALUES;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public static ModuleTypeEnum[] values() {
                return (ModuleTypeEnum[])$VALUES.clone();
            }

            public static ModuleTypeEnum valueOf(String name) {
                return Enum.valueOf(ModuleTypeEnum.class, name);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(ModuleTypeEnum.class);
                CONNECTOR = new ModuleTypeEnum();
                EJB = new ModuleTypeEnum();
                JAVA = new ModuleTypeEnum();
                WEB = new ModuleTypeEnum();
                $VALUES = new ModuleTypeEnum[]{CONNECTOR, EJB, JAVA, WEB};
            }
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        public static class ListType
        extends DDParser.ParsableListImplements<ModuleType, Module> {
            static final long serialVersionUID = -5134826001636560305L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ModuleType newInstance(DDParser parser) {
                return new ModuleType();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(ListType.class);
            }
        }
    }
}

