/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.metadata.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class J2EENameImpl
implements J2EEName {
    private static final long serialVersionUID = 7488184044073147667L;
    private transient String application;
    private transient String module;
    private transient String component;
    private transient String string;
    private volatile byte[] j2eeNameBytes;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public J2EENameImpl(String application, String module, String component) {
        if (application == null) {
            throw new IllegalArgumentException("application");
        }
        if (application.indexOf(35) != -1) {
            throw new IllegalArgumentException("application name must not contain '#'");
        }
        if (module == null) {
            if (component != null) {
                throw new IllegalArgumentException("module");
            }
        } else {
            if (module.indexOf(35) != -1) {
                throw new IllegalArgumentException("module name must not contain '#'");
            }
            if (component != null && component.indexOf(35) != -1) {
                throw new IllegalArgumentException("component name must not contain '#'");
            }
        }
        this.application = application;
        this.module = module;
        this.component = component;
    }

    public J2EENameImpl(byte[] bytes) {
        this.j2eeNameBytes = bytes;
        this.readObject(bytes);
    }

    @Override
    public String toString() {
        String string = this.string;
        if (string == null) {
            string = this.module == null ? this.application : (this.component == null ? this.application + '#' + this.module : this.application + '#' + this.module + '#' + this.component);
            this.string = string;
        }
        return string;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == J2EENameImpl.class && this.toString().equals(((J2EENameImpl)o).toString());
    }

    public boolean equals(J2EENameImpl o) {
        return o != null && this.toString().equals(o.toString());
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes() {
        byte[] bytes = this.j2eeNameBytes;
        if (bytes == null) {
            try {
                bytes = this.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                void e;
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.container.service.metadata.internal.J2EENameImpl", (String)"129", (Object)this, (Object[])new Object[0]);
                throw new IllegalStateException((Throwable)e);
            }
            this.j2eeNameBytes = bytes;
        }
        return bytes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getBytes();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.readObject(this.j2eeNameBytes);
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(byte[] bytes) {
        String string;
        try {
            string = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.container.service.metadata.internal.J2EENameImpl", (String)"153", (Object)this, (Object[])new Object[]{bytes});
            throw new IllegalStateException((Throwable)e);
        }
        this.string = string;
        int modSepIndex = string.indexOf(35);
        if (modSepIndex == -1) {
            this.application = string;
        } else {
            this.application = string.substring(0, modSepIndex);
            int compSepIndex = string.indexOf(35, modSepIndex + 1);
            if (compSepIndex == -1) {
                this.module = string.substring(modSepIndex + 1);
            } else {
                this.module = string.substring(modSepIndex + 1, compSepIndex);
                this.component = string.substring(compSepIndex + 1);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(J2EENameImpl.class);
    }
}

