/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.GenericFile;
import com.ibm.websphere.logging.hpel.reader.LogQueryBean;
import com.ibm.websphere.logging.hpel.reader.LogRecordFilter;
import com.ibm.websphere.logging.hpel.reader.LogRecordHeaderFilter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecordHeader;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import com.ibm.websphere.logging.hpel.reader.RepositoryReader;
import com.ibm.websphere.logging.hpel.reader.ServerInstanceLogRecordList;
import com.ibm.websphere.logging.hpel.reader.filters.LevelFilter;
import com.ibm.websphere.logging.hpel.reader.filters.MultipleCriteriaFilter;
import com.ibm.ws.logging.hpel.LogRepositoryBrowser;
import com.ibm.ws.logging.hpel.MainLogRepositoryBrowser;
import com.ibm.ws.logging.hpel.impl.LogRecordBrowser;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBrowserImpl;
import com.ibm.ws.logging.hpel.impl.MainLogRepositoryBrowserImpl;
import com.ibm.ws.logging.hpel.impl.OneFileBrowserImpl;
import com.ibm.ws.logging.hpel.impl.OneInstanceBrowserImpl;
import com.ibm.ws.logging.hpel.impl.ServerInstanceLogRecordListImpl;
import com.ibm.ws.logging.hpel.impl.ZipGenericFile;
import com.ibm.ws.logging.object.hpel.RepositoryPointerImpl;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class RepositoryReaderImpl
implements RepositoryReader {
    private final MainLogRepositoryBrowser logInstanceBrowser;
    private final MainLogRepositoryBrowser traceInstanceBrowser;
    private static final Properties EMPTY_HEADER = new Properties();
    private static final ServerInstanceLogRecordList EMPTY_LIST = new ServerInstanceLogRecordList(){

        @Override
        public Iterator<RepositoryLogRecord> iterator() {
            return ServerInstanceLogRecordListImpl.EMPTY_ITERATOR;
        }

        @Override
        public Iterable<RepositoryLogRecord> range(int offset, int length) {
            return new Iterable<RepositoryLogRecord>(){

                @Override
                public Iterator<RepositoryLogRecord> iterator() {
                    return ServerInstanceLogRecordListImpl.EMPTY_ITERATOR;
                }
            };
        }

        @Override
        public Properties getHeader() {
            return EMPTY_HEADER;
        }

        @Override
        public Map<String, ServerInstanceLogRecordList> getChildren() {
            return new HashMap<String, ServerInstanceLogRecordList>();
        }

        @Override
        public Date getStartTime() {
            return null;
        }
    };
    private static final Iterable<ServerInstanceLogRecordList> EMPTY_ITERABLE = new Iterable<ServerInstanceLogRecordList>(){

        @Override
        public Iterator<ServerInstanceLogRecordList> iterator() {
            return new Iterator<ServerInstanceLogRecordList>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public ServerInstanceLogRecordList next() {
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Method is not applicable to this class");
                }
            };
        }
    };

    public RepositoryReaderImpl(String directory) {
        this(directory, directory);
    }

    public RepositoryReaderImpl(String logDirectory, String traceDirectory) {
        this(logDirectory == null ? null : new File(logDirectory), traceDirectory == null ? null : new File(traceDirectory));
    }

    public RepositoryReaderImpl(File directory) {
        this(directory, directory);
    }

    public RepositoryReaderImpl(File logLocation, File traceLocation) {
        if (logLocation == null && traceLocation == null) {
            throw new IllegalArgumentException("At least one \"logLocation\" or \"traceLocation\" should be specified.");
        }
        if (traceLocation != null) {
            traceLocation = RepositoryReaderImpl.checkKnownType(traceLocation);
            traceLocation = RepositoryReaderImpl.verifyLocation(traceLocation, "tracedata");
        }
        if (logLocation == null) {
            logLocation = traceLocation;
        } else {
            logLocation = RepositoryReaderImpl.checkKnownType(logLocation);
            logLocation = RepositoryReaderImpl.verifyLocation(logLocation, "logdata");
        }
        if (logLocation.equals(traceLocation)) {
            traceLocation = null;
        }
        this.logInstanceBrowser = RepositoryReaderImpl.createBrowser(logLocation);
        this.traceInstanceBrowser = traceLocation == null ? null : RepositoryReaderImpl.createBrowser(traceLocation);
    }

    private static MainLogRepositoryBrowser createBrowser(File location) {
        LogRepositoryBrowserImpl browser;
        if (RepositoryReaderImpl.isFile(location)) {
            return new OneInstanceBrowserImpl(new OneFileBrowserImpl(location));
        }
        if (location.isDirectory() && ((browser = new LogRepositoryBrowserImpl(location, new String[]{location.getName()})).findNext((File)null, -1L) != null || !browser.getSubProcesses().isEmpty())) {
            return new OneInstanceBrowserImpl(browser);
        }
        return new MainLogRepositoryBrowserImpl(location);
    }

    private static File verifyLocation(File location, String suffix) {
        if (RepositoryReaderImpl.isFile(location)) {
            return location;
        }
        if (suffix.equals(location.getName())) {
            return location;
        }
        File newLocation = RepositoryReaderImpl.getChild(location, suffix);
        if (newLocation.isDirectory()) {
            return newLocation;
        }
        if (location.isDirectory()) {
            LogRepositoryBrowserImpl browser = new LogRepositoryBrowserImpl(location, new String[]{location.getName()});
            if (browser.findNext((File)null, -1L) != null) {
                return location;
            }
            File[] wblDirs = location.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && new LogRepositoryBrowserImpl(pathname, new String[]{pathname.getName()}).findNext((File)null, -1L) != null;
                }
            });
            if (wblDirs.length > 0) {
                return location;
            }
            MainLogRepositoryBrowserImpl fileBrowser = new MainLogRepositoryBrowserImpl(location);
            if (fileBrowser.findByMillis(-1L) != null) {
                return location;
            }
        }
        if (!RepositoryReaderImpl.fileExists(newLocation)) {
            return newLocation;
        }
        return location;
    }

    private static boolean fileExists(final File newLocation) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return newLocation.exists();
            }
        });
    }

    public String getLogLocation() {
        return ((MainLogRepositoryBrowserImpl)this.logInstanceBrowser).getLocation().getAbsolutePath();
    }

    public String getTraceLocation() {
        if (this.traceInstanceBrowser != null) {
            return ((MainLogRepositoryBrowserImpl)this.traceInstanceBrowser).getLocation().getAbsolutePath();
        }
        return null;
    }

    private static File getChild(File pathname, String name) {
        if (pathname instanceof GenericFile) {
            return ((GenericFile)((Object)pathname)).getChild(name);
        }
        return new File(pathname, name);
    }

    private static File checkKnownType(File location) {
        if (location instanceof GenericFile || !RepositoryReaderImpl.isFile(location)) {
            return location;
        }
        try {
            return new ZipGenericFile(location);
        }
        catch (IOException iOException) {
            return location;
        }
    }

    public static boolean containsLogFiles(File location) {
        if (location == null) {
            return false;
        }
        if (RepositoryReaderImpl.isFile(location = RepositoryReaderImpl.checkKnownType(location))) {
            try {
                if (new OneFileBrowserImpl(location).getProcessId() != null) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return false;
        }
        if (location.isDirectory()) {
            LogRepositoryBrowserImpl browser = new LogRepositoryBrowserImpl(location, new String[]{location.getName()});
            if (browser.findNext((File)null, -1L) != null) {
                return true;
            }
            File[] wblDirs = location.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && new LogRepositoryBrowserImpl(pathname, new String[]{pathname.getName()}).findNext((File)null, -1L) != null;
                }
            });
            if (wblDirs.length > 0) {
                return true;
            }
        }
        for (File file : new File[]{location, RepositoryReaderImpl.getChild(location, "logdata"), RepositoryReaderImpl.getChild(location, "tracedata")}) {
            MainLogRepositoryBrowserImpl fileBrowser;
            if (!file.isDirectory() || (fileBrowser = new MainLogRepositoryBrowserImpl(file)).findByMillis(-1L) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isFile(final File location) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return location.isFile();
            }
        });
    }

    public static File[] listRepositories(File parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Input parameter can't be null.");
        }
        if (!(parent = RepositoryReaderImpl.checkKnownType(parent)).isDirectory()) {
            throw new IllegalArgumentException("Input parameter should be an existing directory: " + parent);
        }
        File[] result = parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && RepositoryReaderImpl.getChild(pathname, "logdata").isDirectory() || RepositoryReaderImpl.getChild(pathname, "tracedata").isDirectory();
            }
        });
        return result == null ? new File[]{} : result;
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists() {
        return this.getLogLists((Date)null, (Date)null, (LogRecordHeaderFilter)null);
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after) {
        return this.getLogLists(after, (Date)null, (LogRecordHeaderFilter)null);
    }

    public Iterable<ServerInstanceLogRecordList> getLogLists(Date beginTime, Date endTime, final LogRecordHeaderFilter filter) {
        LogRepositoryBrowser traces;
        LogRepositoryBrowser logs;
        long max;
        final long min = beginTime == null ? -1L : beginTime.getTime();
        long l = max = endTime == null ? -1L : endTime.getTime();
        if (beginTime == null) {
            logs = this.logInstanceBrowser.findNext((LogRepositoryBrowser)null, max);
        } else {
            logs = this.logInstanceBrowser.findByMillis(min);
            if (logs == null) {
                logs = this.logInstanceBrowser.findNext((LogRepositoryBrowser)null, max);
            }
        }
        if (this.traceInstanceBrowser != null) {
            if (beginTime == null) {
                traces = this.traceInstanceBrowser.findNext((LogRepositoryBrowser)null, max);
            } else {
                traces = this.traceInstanceBrowser.findByMillis(min);
                if (traces == null) {
                    traces = this.traceInstanceBrowser.findNext((LogRepositoryBrowser)null, max);
                }
            }
        } else {
            traces = null;
        }
        final LogRepositoryBrowser finalLogs = logs;
        final LogRepositoryBrowser finalTraces = traces;
        return new Iterable<ServerInstanceLogRecordList>(){

            @Override
            public Iterator<ServerInstanceLogRecordList> iterator() {
                return new ServerInstanceListsIterator(max, finalLogs, finalTraces){

                    @Override
                    protected LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                        return new LogRecordBrowser(browser).recordsInProcess(min, max, filter);
                    }
                };
            }
        };
    }

    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after, Date endTime, final LogRecordHeaderFilter filter) {
        if (after instanceof RepositoryPointerImpl) {
            RepositoryLogRecord current;
            final RepositoryPointerImpl location = (RepositoryPointerImpl)after;
            final long max = endTime == null ? -1L : endTime.getTime();
            LogRepositoryBrowser logs = this.logInstanceBrowser.find(location, false);
            LogRepositoryBrowser traces = null;
            if (this.traceInstanceBrowser != null) {
                traces = this.traceInstanceBrowser.find(location, false);
            }
            if (logs == null && traces == null) {
                return EMPTY_ITERABLE;
            }
            if (logs != null && (current = new LogRecordBrowser(logs).getRecord(location)) != null) {
                final LogRepositoryBrowser finalLogs = logs;
                final LogRepositoryBrowser finalTraces = this.traceInstanceBrowser == null ? null : this.traceInstanceBrowser.find(location, true);
                return new Iterable<ServerInstanceLogRecordList>(){

                    @Override
                    public Iterator<ServerInstanceLogRecordList> iterator() {
                        return new ServerInstanceListsIterator(max, finalLogs, finalTraces){

                            @Override
                            protected LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                                return new LogRecordBrowser(browser).recordsInProcess(-1L, max, filter);
                            }

                            @Override
                            protected ServerInstanceLogRecordList queryFirstInstance(LogRepositoryBrowser firstLog, LogRepositoryBrowser firstTrace) {
                                return new ServerInstanceLogRecordListHeaderPointerImpl(firstLog, firstTrace, false, location, current, filter, max);
                            }
                        };
                    }
                };
            }
            if (traces != null && (current = new LogRecordBrowser(traces).getRecord(location)) != null) {
                final LogRepositoryBrowser finalLogs = this.logInstanceBrowser.find(location, true);
                final LogRepositoryBrowser finalTraces = traces;
                return new Iterable<ServerInstanceLogRecordList>(){

                    @Override
                    public Iterator<ServerInstanceLogRecordList> iterator() {
                        return new ServerInstanceListsIterator(max, finalLogs, finalTraces){

                            @Override
                            protected LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                                return new LogRecordBrowser(browser).recordsInProcess(-1L, max, filter);
                            }

                            @Override
                            protected ServerInstanceLogRecordList queryFirstInstance(LogRepositoryBrowser firstLog, LogRepositoryBrowser firstTrace) {
                                return new ServerInstanceLogRecordListHeaderPointerImpl(firstTrace, firstLog, true, location, current, filter, max);
                            }
                        };
                    }
                };
            }
            final LogRepositoryBrowser finalLogs = this.logInstanceBrowser.find(location, true);
            final LogRepositoryBrowser finalTraces = this.traceInstanceBrowser == null ? null : this.traceInstanceBrowser.find(location, true);
            return new Iterable<ServerInstanceLogRecordList>(){

                @Override
                public Iterator<ServerInstanceLogRecordList> iterator() {
                    return new ServerInstanceListsIterator(max, finalLogs, finalTraces){

                        @Override
                        protected LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                            return new LogRecordBrowser(browser).recordsInProcess(-1L, max, filter);
                        }
                    };
                }
            };
        }
        if (after != null) {
            throw new IllegalArgumentException("This method accept only RepositoryPointer instances retrieved from previously read records");
        }
        return this.getLogLists((Date)null, endTime, filter);
    }

    public Iterable<ServerInstanceLogRecordList> getLogLists(Date beginTime, Date endTime, final LogRecordFilter filter) {
        LogRepositoryBrowser traces;
        LogRepositoryBrowser logs;
        long max;
        final long min = beginTime == null ? -1L : beginTime.getTime();
        long l = max = endTime == null ? -1L : endTime.getTime();
        if (beginTime == null) {
            logs = this.logInstanceBrowser.findNext((LogRepositoryBrowser)null, max);
        } else {
            logs = this.logInstanceBrowser.findByMillis(min);
            if (logs == null) {
                logs = this.logInstanceBrowser.findNext((LogRepositoryBrowser)null, max);
            }
        }
        if (this.traceInstanceBrowser != null) {
            if (beginTime == null) {
                traces = this.traceInstanceBrowser.findNext((LogRepositoryBrowser)null, max);
            } else {
                traces = this.traceInstanceBrowser.findByMillis(min);
                if (traces == null) {
                    traces = this.traceInstanceBrowser.findNext((LogRepositoryBrowser)null, max);
                }
            }
        } else {
            traces = null;
        }
        final LogRepositoryBrowser finalLogs = logs;
        final LogRepositoryBrowser finalTraces = traces;
        return new Iterable<ServerInstanceLogRecordList>(){

            @Override
            public Iterator<ServerInstanceLogRecordList> iterator() {
                return new ServerInstanceListsIterator(max, finalLogs, finalTraces){

                    @Override
                    protected LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                        return new LogRecordBrowser(browser).recordsInProcess(min, max, filter);
                    }
                };
            }
        };
    }

    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after, Date endTime, final LogRecordFilter filter) {
        if (after instanceof RepositoryPointerImpl) {
            RepositoryLogRecord current;
            final RepositoryPointerImpl location = (RepositoryPointerImpl)after;
            final long max = endTime == null ? -1L : endTime.getTime();
            LogRepositoryBrowser logs = this.logInstanceBrowser.find(location, false);
            LogRepositoryBrowser traces = null;
            if (this.traceInstanceBrowser != null) {
                traces = this.traceInstanceBrowser.find(location, false);
            }
            if (logs == null && traces == null) {
                return EMPTY_ITERABLE;
            }
            if (logs != null && (current = new LogRecordBrowser(logs).getRecord(location)) != null) {
                final LogRepositoryBrowser finalLogs = logs;
                final LogRepositoryBrowser finalTraces = this.traceInstanceBrowser == null ? null : this.traceInstanceBrowser.find(location, true);
                return new Iterable<ServerInstanceLogRecordList>(){

                    @Override
                    public Iterator<ServerInstanceLogRecordList> iterator() {
                        return new ServerInstanceListsIterator(max, finalLogs, finalTraces){

                            @Override
                            protected LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                                return new LogRecordBrowser(browser).recordsInProcess(-1L, max, filter);
                            }

                            @Override
                            protected ServerInstanceLogRecordList queryFirstInstance(LogRepositoryBrowser firstLog, LogRepositoryBrowser firstTrace) {
                                return new ServerInstanceLogRecordListPointerImpl(firstLog, firstTrace, false, location, current, filter, max);
                            }
                        };
                    }
                };
            }
            if (traces != null && (current = new LogRecordBrowser(traces).getRecord(location)) != null) {
                final LogRepositoryBrowser finalLogs = this.logInstanceBrowser.find(location, true);
                final LogRepositoryBrowser finalTraces = traces;
                return new Iterable<ServerInstanceLogRecordList>(){

                    @Override
                    public Iterator<ServerInstanceLogRecordList> iterator() {
                        return new ServerInstanceListsIterator(max, finalLogs, finalTraces){

                            @Override
                            protected LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                                return new LogRecordBrowser(browser).recordsInProcess(-1L, max, filter);
                            }

                            @Override
                            protected ServerInstanceLogRecordList queryFirstInstance(LogRepositoryBrowser firstLog, LogRepositoryBrowser firstTrace) {
                                return new ServerInstanceLogRecordListPointerImpl(firstTrace, firstLog, true, location, current, filter, max);
                            }
                        };
                    }
                };
            }
            final LogRepositoryBrowser finalLogs = this.logInstanceBrowser.find(location, true);
            final LogRepositoryBrowser finalTraces = this.traceInstanceBrowser == null ? null : this.traceInstanceBrowser.find(location, true);
            return new Iterable<ServerInstanceLogRecordList>(){

                @Override
                public Iterator<ServerInstanceLogRecordList> iterator() {
                    return new ServerInstanceListsIterator(max, finalLogs, finalTraces){

                        @Override
                        protected LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                            return new LogRecordBrowser(browser).recordsInProcess(-1L, max, filter);
                        }
                    };
                }
            };
        }
        if (after != null) {
            throw new IllegalArgumentException("This method accept only RepositoryPointer instances retrieved from previously read records");
        }
        return this.getLogLists((Date)null, endTime, filter);
    }

    public Iterable<ServerInstanceLogRecordList> getLogLists(int minLevel, int maxLevel) {
        return this.getLogLists((Date)null, (Date)null, (LogRecordHeaderFilter)new LevelFilter(minLevel, maxLevel));
    }

    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after, int minLevel, int maxLevel) {
        return this.getLogLists(after, (Date)null, (LogRecordHeaderFilter)new LevelFilter(minLevel, maxLevel));
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(Level minLevel, Level maxLevel) {
        return this.getLogLists((Date)null, (Date)null, (LogRecordHeaderFilter)new LevelFilter(minLevel, maxLevel));
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after, Level minLevel, Level maxLevel) {
        return this.getLogLists(after, (Date)null, (LogRecordHeaderFilter)new LevelFilter(minLevel, maxLevel));
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(Date minTime, Date maxTime) {
        return this.getLogLists(minTime, maxTime, (LogRecordFilter)null);
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after, Date maxTime) {
        return this.getLogLists(after, maxTime, (LogRecordFilter)null);
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(LogQueryBean query) {
        if (query == null) {
            query = new LogQueryBean();
        }
        MultipleCriteriaFilter multipleCriteriaFilter = new MultipleCriteriaFilter(query);
        return this.getLogLists(query.getMinTime(), query.getMaxTime(), (LogRecordFilter)multipleCriteriaFilter);
    }

    @Override
    public Iterable<ServerInstanceLogRecordList> getLogLists(RepositoryPointer after, LogQueryBean query) {
        if (query == null) {
            query = new LogQueryBean();
        }
        MultipleCriteriaFilter multipleCriteriaFilter = new MultipleCriteriaFilter(query);
        return this.getLogLists(after, query.getMaxTime(), (LogRecordFilter)multipleCriteriaFilter);
    }

    @Override
    public ServerInstanceLogRecordList getLogListForCurrentServerInstance() {
        return this.getLogListForServerInstance((Date)null, (LogRecordFilter)null);
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(Date time) {
        return this.getLogListForServerInstance(time, (LogRecordFilter)null);
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after) {
        return this.getLogListForServerInstance(after, (LogRecordFilter)null);
    }

    public ServerInstanceLogRecordList getLogListForServerInstance(Date time, final LogRecordHeaderFilter filter) {
        ServerInstanceByTime instance = new ServerInstanceByTime(time == null ? -1L : time.getTime());
        if (instance.logs == null && instance.traces == null) {
            return EMPTY_LIST;
        }
        return new ServerInstanceLogRecordListImpl(instance.logs, instance.traces, false){

            @Override
            public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                return new LogRecordBrowser(browser).recordsInProcess(-1L, -1L, filter);
            }
        };
    }

    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after, final LogRecordHeaderFilter filter) {
        if (after instanceof RepositoryPointerImpl) {
            ServerInstanceByPointer instance = new ServerInstanceByPointer((RepositoryPointerImpl)after);
            if (instance.logs == null && instance.traces == null) {
                return EMPTY_LIST;
            }
            if (instance.record != null) {
                return new ServerInstanceLogRecordListHeaderPointerImpl(instance.logs, instance.traces, instance.switched, (RepositoryPointerImpl)after, instance.record, filter, -1L);
            }
            return new ServerInstanceLogRecordListImpl(instance.logs, instance.traces, instance.switched){

                @Override
                public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                    return new LogRecordBrowser(browser).recordsInProcess(-1L, -1L, filter);
                }
            };
        }
        if (after != null) {
            throw new IllegalArgumentException("This method accept only RepositoryPointer instances retrieved from previously read records");
        }
        return this.getLogListForServerInstance((Date)null, filter);
    }

    public ServerInstanceLogRecordList getLogListForServerInstance(Date time, final LogRecordFilter filter) {
        ServerInstanceByTime instance = new ServerInstanceByTime(time == null ? -1L : time.getTime());
        if (instance.logs == null && instance.traces == null) {
            return EMPTY_LIST;
        }
        return new ServerInstanceLogRecordListImpl(instance.logs, instance.traces, false){

            @Override
            public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                return new LogRecordBrowser(browser).recordsInProcess(-1L, -1L, filter);
            }
        };
    }

    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after, final LogRecordFilter filter) {
        if (after instanceof RepositoryPointerImpl) {
            ServerInstanceByPointer instance = new ServerInstanceByPointer((RepositoryPointerImpl)after);
            if (instance.logs == null && instance.traces == null) {
                return EMPTY_LIST;
            }
            if (instance.record != null) {
                return new ServerInstanceLogRecordListPointerImpl(instance.logs, instance.traces, instance.switched, (RepositoryPointerImpl)after, instance.record, filter, -1L);
            }
            return new ServerInstanceLogRecordListImpl(instance.logs, instance.traces, instance.switched){

                @Override
                public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                    return new LogRecordBrowser(browser).recordsInProcess(-1L, -1L, filter);
                }
            };
        }
        if (after != null) {
            throw new IllegalArgumentException("This method accept only RepositoryPointer instances retrieved from previously read records");
        }
        return this.getLogListForServerInstance((Date)null, filter);
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(Date time, Level minLevel, Level maxLevel) {
        return this.getLogListForServerInstance(time, (LogRecordHeaderFilter)new LevelFilter(minLevel, maxLevel));
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after, Level minLevel, Level maxLevel) {
        return this.getLogListForServerInstance(after, (LogRecordHeaderFilter)new LevelFilter(minLevel, maxLevel));
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(Date time, final int threadID) {
        return this.getLogListForServerInstance(time, threadID < 0 ? (LogRecordHeaderFilter)null : new LogRecordHeaderFilter(){

            @Override
            public boolean accept(RepositoryLogRecordHeader record) {
                return record.getThreadID() == threadID;
            }
        });
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after, final int threadID) {
        return this.getLogListForServerInstance(after, threadID < 0 ? (LogRecordHeaderFilter)null : new LogRecordHeaderFilter(){

            @Override
            public boolean accept(RepositoryLogRecordHeader record) {
                return record.getThreadID() == threadID;
            }
        });
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(Date time, LogQueryBean query) {
        ServerInstanceByTime instance = new ServerInstanceByTime(time == null ? -1L : time.getTime());
        if (instance.logs == null && instance.traces == null) {
            return EMPTY_LIST;
        }
        if (query == null) {
            query = new LogQueryBean();
        }
        final MultipleCriteriaFilter filter = new MultipleCriteriaFilter(query);
        final long min = query.getMinTime() == null ? -1L : query.getMinTime().getTime();
        final long max = query.getMaxTime() == null ? -1L : query.getMaxTime().getTime();
        return new ServerInstanceLogRecordListImpl(instance.logs, instance.traces, false){

            @Override
            public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                return new LogRecordBrowser(browser).recordsInProcess(min, max, (LogRecordFilter)filter);
            }
        };
    }

    @Override
    public ServerInstanceLogRecordList getLogListForServerInstance(RepositoryPointer after, LogQueryBean query) {
        if (after instanceof RepositoryPointerImpl) {
            ServerInstanceByPointer instance = new ServerInstanceByPointer((RepositoryPointerImpl)after);
            if (instance.logs == null && instance.traces == null) {
                return EMPTY_LIST;
            }
            if (query == null) {
                query = new LogQueryBean();
            }
            final MultipleCriteriaFilter filter = new MultipleCriteriaFilter(query);
            if (instance.record != null) {
                return new ServerInstanceLogRecordListPointerImpl(instance.logs, instance.traces, instance.switched, (RepositoryPointerImpl)after, instance.record, filter, -1L);
            }
            final long min = query.getMinTime() == null ? -1L : query.getMinTime().getTime();
            final long max = query.getMaxTime() == null ? -1L : query.getMaxTime().getTime();
            return new ServerInstanceLogRecordListImpl(instance.logs, instance.traces, instance.switched){

                @Override
                public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                    return new LogRecordBrowser(browser).recordsInProcess(min, max, (LogRecordFilter)filter);
                }
            };
        }
        if (after != null) {
            throw new IllegalArgumentException("This method accept only RepositoryPointer instances retrieved from previously read records");
        }
        return this.getLogListForServerInstance((Date)null, query);
    }

    private abstract class ServerInstanceListsIterator
    implements Iterator<ServerInstanceLogRecordList> {
        boolean readFirstInstance = false;
        LogRepositoryBrowser nextLog;
        LogRepositoryBrowser nextTrace;
        LogRepositoryBrowser nextToNextLog;
        private final long max;

        ServerInstanceListsIterator(long max, LogRepositoryBrowser firstLog, LogRepositoryBrowser firstTrace) {
            this.max = max;
            this.nextLog = firstLog;
            this.nextTrace = firstTrace;
            this.nextToNextLog = RepositoryReaderImpl.this.logInstanceBrowser.findNext(this.nextLog, max);
        }

        protected abstract LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser var1);

        protected ServerInstanceLogRecordList queryFirstInstance(LogRepositoryBrowser firstLog, LogRepositoryBrowser firstTrace) {
            return new ServerInstanceLogRecordListImpl(firstLog, firstTrace, false){

                @Override
                public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                    return ServerInstanceListsIterator.this.queryResult(browser);
                }
            };
        }

        @Override
        public boolean hasNext() {
            return this.nextLog != null || this.nextTrace != null;
        }

        @Override
        public ServerInstanceLogRecordList next() {
            if (this.nextLog == null && this.nextTrace == null) {
                return null;
            }
            LogRepositoryBrowser useLog = this.nextLog;
            LogRepositoryBrowser useTrace = this.nextTrace;
            LogRepositoryBrowser tmpNextToNextLog = this.nextToNextLog;
            if (this.nextLog != null && this.nextTrace != null && (this.nextLog.getProcessId() == null && this.nextTrace.getProcessId() != null || this.nextLog.getProcessId() != null)) {
                if (this.nextLog.getTimestamp() < this.nextTrace.getTimestamp()) {
                    if (tmpNextToNextLog != null && this.nextTrace.getTimestamp() > tmpNextToNextLog.getTimestamp()) {
                        useTrace = null;
                    }
                } else {
                    useLog = null;
                }
            }
            if (useLog != null) {
                this.nextLog = RepositoryReaderImpl.this.logInstanceBrowser.findNext(this.nextLog, this.max);
                this.nextToNextLog = RepositoryReaderImpl.this.logInstanceBrowser.findNext(this.nextLog, this.max);
            }
            if (useTrace != null) {
                this.nextTrace = RepositoryReaderImpl.this.traceInstanceBrowser.findNext(this.nextTrace, this.max);
            }
            if (this.readFirstInstance) {
                return new ServerInstanceLogRecordListImpl(useLog, useTrace, false){

                    @Override
                    public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
                        return ServerInstanceListsIterator.this.queryResult(browser);
                    }
                };
            }
            this.readFirstInstance = true;
            return this.queryFirstInstance(useLog, useTrace);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method is not applicable to this class");
        }
    }

    private static class ServerInstanceLogRecordListPointerImpl
    extends ServerInstanceLogRecordListImpl {
        private final LogRecordFilter filter;
        private final long max;
        private final RepositoryPointerImpl location;
        private final RepositoryLogRecord current;

        public ServerInstanceLogRecordListPointerImpl(LogRepositoryBrowser pointerBrowser, LogRepositoryBrowser recordBrowser, boolean switched, RepositoryPointerImpl location, RepositoryLogRecord current, LogRecordFilter filter, long max) {
            super(pointerBrowser, recordBrowser, switched);
            this.location = location;
            this.current = current;
            this.filter = filter;
            this.max = max;
        }

        @Override
        public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
            return new LogRecordBrowser(browser).recordsInProcess(-1L, this.max, this.filter);
        }

        @Override
        protected LogRecordBrowser.OnePidRecordListImpl getLogResult() {
            if (this.logResult == null && this.logBrowser != null) {
                this.logResult = new LogRecordBrowser(this.logBrowser).recordsInProcess((RepositoryPointer)this.location, this.max, this.filter);
            }
            return this.logResult;
        }

        @Override
        protected LogRecordBrowser.OnePidRecordListImpl getTraceResult() {
            if (this.traceResult == null && this.traceBrowser != null) {
                this.traceResult = new LogRecordBrowser(this.traceBrowser).recordsInProcess(this.current, this.max, this.filter);
            }
            return this.traceResult;
        }
    }

    private static class ServerInstanceLogRecordListHeaderPointerImpl
    extends ServerInstanceLogRecordListImpl {
        private final LogRecordHeaderFilter filter;
        private final long max;
        private final RepositoryPointerImpl location;
        private final RepositoryLogRecord current;

        public ServerInstanceLogRecordListHeaderPointerImpl(LogRepositoryBrowser pointerBrowser, LogRepositoryBrowser recordBrowser, boolean switched, RepositoryPointerImpl location, RepositoryLogRecord current, LogRecordHeaderFilter filter, long max) {
            super(pointerBrowser, recordBrowser, switched);
            this.location = location;
            this.current = current;
            this.filter = filter;
            this.max = max;
        }

        @Override
        public LogRecordBrowser.OnePidRecordListImpl queryResult(LogRepositoryBrowser browser) {
            return new LogRecordBrowser(browser).recordsInProcess(-1L, this.max, this.filter);
        }

        @Override
        protected LogRecordBrowser.OnePidRecordListImpl getLogResult() {
            if (this.logResult == null && this.logBrowser != null) {
                this.logResult = new LogRecordBrowser(this.logBrowser).recordsInProcess((RepositoryPointer)this.location, this.max, this.filter);
            }
            return this.logResult;
        }

        @Override
        protected LogRecordBrowser.OnePidRecordListImpl getTraceResult() {
            if (this.traceResult == null && this.traceBrowser != null) {
                this.traceResult = new LogRecordBrowser(this.traceBrowser).recordsInProcess(this.current, this.max, this.filter);
            }
            return this.traceResult;
        }
    }

    private class ServerInstanceByPointer {
        final LogRepositoryBrowser logs;
        final LogRepositoryBrowser traces;
        final RepositoryLogRecord record;
        boolean switched = false;

        ServerInstanceByPointer(RepositoryPointerImpl location) {
            LogRepositoryBrowser iLogs = RepositoryReaderImpl.this.logInstanceBrowser.find(location, false);
            LogRepositoryBrowser iTraces = null;
            RepositoryLogRecord iRecord = null;
            if (RepositoryReaderImpl.this.traceInstanceBrowser != null) {
                iTraces = RepositoryReaderImpl.this.traceInstanceBrowser.find(location, false);
            }
            if (iLogs != null || iTraces != null) {
                if (iLogs != null && (iRecord = new LogRecordBrowser(iLogs).getRecord(location)) != null) {
                    LogRepositoryBrowser logRepositoryBrowser = iTraces = RepositoryReaderImpl.this.traceInstanceBrowser == null ? null : RepositoryReaderImpl.this.traceInstanceBrowser.find(location, true);
                }
                if (iRecord == null && iTraces != null && (iRecord = new LogRecordBrowser(iTraces).getRecord(location)) != null) {
                    iLogs = iTraces;
                    iTraces = RepositoryReaderImpl.this.logInstanceBrowser.find(location, true);
                    this.switched = true;
                }
            }
            this.logs = iLogs;
            this.traces = iTraces;
            this.record = iRecord;
        }
    }

    private class ServerInstanceByTime {
        final LogRepositoryBrowser logs;
        final LogRepositoryBrowser traces;

        ServerInstanceByTime(long timestamp) {
            LogRepositoryBrowser iLogs = RepositoryReaderImpl.this.logInstanceBrowser.findByMillis(timestamp);
            LogRepositoryBrowser iTraces = null;
            if (RepositoryReaderImpl.this.traceInstanceBrowser != null) {
                iTraces = RepositoryReaderImpl.this.traceInstanceBrowser.findByMillis(timestamp);
                if (iLogs == null && iTraces != null) {
                    iLogs = RepositoryReaderImpl.this.logInstanceBrowser.findNext(iLogs, -1L);
                } else if (iTraces == null && iLogs != null) {
                    iTraces = RepositoryReaderImpl.this.traceInstanceBrowser.findNext(iLogs, -1L);
                }
            }
            if (iLogs != null && iTraces != null) {
                String logPid = iLogs.getProcessId();
                String tracePid = iTraces.getProcessId();
                if (logPid == null && tracePid != null || logPid != null && !logPid.equals(tracePid)) {
                    long traceTimestamp;
                    long logTimestamp = iLogs.getTimestamp();
                    if (logTimestamp < (traceTimestamp = iTraces.getTimestamp())) {
                        if (timestamp < 0L) {
                            iLogs = null;
                        } else if (timestamp < traceTimestamp) {
                            iTraces = null;
                        } else {
                            iLogs = RepositoryReaderImpl.this.logInstanceBrowser.findNext(iLogs, -1L);
                            if (iLogs != null && ((logPid = iLogs.getProcessId()) == null && tracePid != null || logPid != null && !logPid.equals(tracePid))) {
                                iLogs = null;
                            }
                        }
                    } else if (timestamp < 0L) {
                        iTraces = null;
                    } else if (timestamp < logTimestamp) {
                        iLogs = null;
                    } else {
                        iTraces = RepositoryReaderImpl.this.traceInstanceBrowser.findNext(iLogs, -1L);
                        if (iTraces != null) {
                            tracePid = iTraces.getProcessId();
                            if (logPid == null && tracePid != null || logPid != null && !logPid.equals(tracePid)) {
                                iTraces = null;
                            }
                        }
                    }
                }
            }
            this.logs = iLogs;
            this.traces = iTraces;
        }
    }
}

