/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServiceReg<T> {
    private final AtomicReference<ServiceRegistration<T>> _reg = new AtomicReference();
    private final AtomicReference<Hashtable<String, Object>> _props = new AtomicReference();
    private final ConcurrentMap<String, Object> _additionalProps = new ConcurrentHashMap<String, Object>();
    private final AtomicBoolean _dirty = new AtomicBoolean();
    private final AtomicBoolean _registering = new AtomicBoolean();
    static final long serialVersionUID = 1837496963689640910L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={IllegalStateException.class})
    private void setPropertiesInternal(Dictionary props) {
        ServiceRegistration<T> reg = this._reg.get();
        if (reg == null) {
            this._dirty.set(true);
        } else {
            try {
                reg.setProperties(props);
            }
            catch (IllegalStateException e) {
                this._reg.compareAndSet(reg, null);
            }
        }
    }

    public void setProperties(Map<String, ?> props) {
        Hashtable ps = new Hashtable(props);
        ps.putAll(this._additionalProps);
        this._props.set(ps);
        this.setPropertiesInternal(ps);
    }

    public boolean setProperty(String name, Object value) {
        Object original = this._additionalProps.put(name, value);
        if (!value.equals(original)) {
            Hashtable<String, Object> props = this._props.get();
            if (props != null) {
                props.put(name, value);
                this.setPropertiesInternal(props);
            }
            return true;
        }
        return false;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    public void register(BundleContext ctx, Class<T> clazz, T service) {
        if (this._reg.get() == null) {
            try {
                if (this._registering.compareAndSet(false, true)) {
                    ServiceRegistration reg = ctx.registerService(clazz, service, (Dictionary)this._props.get());
                    if (this._registering.compareAndSet(true, false) && this._reg.compareAndSet(null, reg)) {
                        if (this._dirty.compareAndSet(true, false)) {
                            reg.setProperties((Dictionary)this._props.get());
                        }
                    } else {
                        reg.unregister();
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @FFDCIgnore(value={IllegalStateException.class})
    public void unregister() {
        ServiceRegistration reg = this._reg.getAndSet(null);
        if (reg != null) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this._registering.set(false);
    }

    @FFDCIgnore(value={IllegalStateException.class})
    public boolean isRegistered() {
        ServiceRegistration<T> reg = this._reg.get();
        if (reg != null) {
            try {
                reg.getReference();
                return true;
            }
            catch (IllegalStateException ise) {
                this._reg.compareAndSet(reg, null);
            }
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServiceReg.class);
    }
}

