/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.TimeoutElement;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.failover.SfFailoverCache;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class StatefulBeanReaper
implements Runnable {
    private static final TraceComponent tc = Tr.register(StatefulBeanReaper.class, (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.StatefulBeanReaper";
    private long ivSweepInterval;
    private final FastHashtable<BeanId, TimeoutElement> ivStatefulBeanList;
    private static final long DEFAULT_MIN_CLEANUP_INTERVAL = 60000L;
    private static final long DEFAULT_CLEANUP_INTERVAL = 4200000L;
    private Activator ivActivator;
    private final SfFailoverCache ivSfFailoverCache;
    private boolean ivIsCanceled;
    private boolean ivIsRunning;
    private final ScheduledExecutorService ivScheduledExecutorService;
    private ScheduledFuture<?> ivScheduledFuture;
    protected boolean dumped = false;
    protected int numObjects = 0;
    protected int numAdds = 0;
    protected int numRemoves = 0;
    protected int numNullRemoves = 0;
    protected int numDeletes = 0;

    public StatefulBeanReaper(Activator a, int numBuckets, SfFailoverCache failoverCache, ScheduledExecutorService scheduledExecutorService) {
        this(a, numBuckets, 60000L, failoverCache, scheduledExecutorService);
    }

    public StatefulBeanReaper(Activator a, int numBuckets, long cleanupInterval, SfFailoverCache failoverCache, ScheduledExecutorService scheduledExecutorService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.ivSweepInterval = EJSPlatformHelper.isZOS() && cleanupInterval == 0L ? 4200000L : (cleanupInterval < 60000L ? 60000L : cleanupInterval);
        this.ivStatefulBeanList = new FastHashtable(numBuckets);
        this.ivActivator = a;
        this.ivSfFailoverCache = failoverCache;
        this.ivScheduledExecutorService = scheduledExecutorService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : sweep = " + this.ivSweepInterval + " ms"));
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            if (this.ivIsCanceled) {
                return;
            }
            this.ivIsRunning = true;
        }
        try {
            this.sweep();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.StatefulBeanReaper.alarm", (String)"226", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"UNEXPECTED_EXCEPTION_DURING_STATEFUL_BEAN_CLEANUP_CNTR0015W", (Object[])new Object[]{this, e});
        }
        finally {
            StatefulBeanReaper statefulBeanReaper2 = this;
            synchronized (statefulBeanReaper2) {
                this.ivIsRunning = false;
                if (this.ivIsCanceled) {
                    this.notify();
                } else if (this.numObjects != 0) {
                    this.startAlarm();
                } else {
                    this.ivScheduledFuture = null;
                }
            }
        }
    }

    public void sweep() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("Sweep : Stateful Beans = " + this.ivStatefulBeanList.size()), (Object[])new Object[0]);
        }
        Enumeration e = this.ivStatefulBeanList.elements();
        while (e.hasMoreElements()) {
            TimeoutElement elt = (TimeoutElement)e.nextElement();
            if (!elt.isTimedOut()) continue;
            this.deleteBean(elt.beanId);
        }
        if (this.ivSfFailoverCache != null) {
            this.ivSfFailoverCache.sweep();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Sweep : Stateful Beans = " + this.ivStatefulBeanList.size()));
        }
    }

    public void finalSweep(StatefulPassivator passivator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("finalSweep : Stateful Beans = " + this.ivStatefulBeanList.size()), (Object[])new Object[0]);
        }
        Enumeration e = this.ivStatefulBeanList.elements();
        while (e.hasMoreElements()) {
            TimeoutElement elt = (TimeoutElement)e.nextElement();
            if (!elt.passivated) continue;
            try {
                if (!this.remove(elt.beanId)) continue;
                passivator.remove(elt.beanId, false);
            }
            catch (RemoteException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.StatefulBeanReaper.finalSweep", (String)"298", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"REMOVE_FROM_PASSIVATION_STORE_FAILED_CNTR0016W", (Object[])new Object[]{elt.beanId, ex});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finalSweep : Stateful Beans = " + this.ivStatefulBeanList.size()));
        }
    }

    public TimeoutElement getTimeoutElement(BeanId beanId) {
        return (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
    }

    public boolean beanExistsAndTimedOut(TimeoutElement elt, BeanId beanId) {
        if (elt == null) {
            if (this.ivSfFailoverCache != null) {
                return this.ivSfFailoverCache.beanExistsAndTimedOut(beanId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Session bean not in Reaper: Timeout = false", (Object[])new Object[0]);
            }
            return false;
        }
        return elt.isTimedOut();
    }

    public boolean beanDoesNotExistOrHasTimedOut(TimeoutElement elt, BeanId beanId) {
        if (elt == null) {
            if (this.ivSfFailoverCache != null) {
                return this.ivSfFailoverCache.beanDoesNotExistOrHasTimedOut(beanId);
            }
            return true;
        }
        return elt.isTimedOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBean(BeanId beanId) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("deleteBean " + beanId), (Object[])new Object[0]);
            }
            StatefulBeanReaper statefulBeanReaper = this;
            synchronized (statefulBeanReaper) {
                ++this.numDeletes;
            }
            try {
                this.ivActivator.timeoutBean(beanId);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.StatefulBeanReaper.deleteBean", (String)"367", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Unable to timeout session bean", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(StatefulBeanO beanO) {
        BeanId id = beanO.beanId;
        TimeoutElement elt = beanO.ivTimeoutElement;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("add " + beanO.beanId + ", " + elt.timeout), (Object[])new Object[0]);
        }
        Object obj = this.ivStatefulBeanList.put((Object)id, (Object)elt);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(obj != null ? "Stateful bean information replaced" : "Stateful bean information added"), (Object[])new Object[0]);
        }
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            if (this.numObjects == 0 && !this.ivIsCanceled) {
                this.startAlarm();
            }
            ++this.numObjects;
            ++this.numAdds;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"add");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BeanId id) {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("remove (" + id + ")"), (Object[])new Object[0]);
        }
        TimeoutElement elt = null;
        elt = (TimeoutElement)this.ivStatefulBeanList.remove((Object)id);
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            if (elt != null) {
                --this.numObjects;
                ++this.numRemoves;
                if (this.numObjects == 0) {
                    this.stopAlarm();
                }
            } else {
                ++this.numNullRemoves;
            }
        }
        boolean bl = result = elt != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("remove (" + result + ")"));
        }
        return result;
    }

    public synchronized Iterator<BeanId> getPassivatedStatefulBeanIds(J2EEName homeName) {
        ArrayList<BeanId> beanList = new ArrayList<BeanId>();
        Enumeration e = this.ivStatefulBeanList.elements();
        while (e.hasMoreElements()) {
            TimeoutElement elt = (TimeoutElement)e.nextElement();
            if (!homeName.equals(elt.beanId.getJ2EEName()) || !elt.passivated) continue;
            beanList.add(elt.beanId);
        }
        return beanList.iterator();
    }

    public long getBeanTimeoutTime(BeanId beanId) {
        TimeoutElement elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        long timeoutTime = 0L;
        if (elt != null && elt.timeout != 0L && (timeoutTime = elt.lastAccessTime + elt.timeout) < 0L) {
            timeoutTime = Long.MAX_VALUE;
        }
        return timeoutTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump((TraceComponent)tc, (String)"-- StatefulBeanReaper Dump -- ", (Object[])new Object[]{this});
            StatefulBeanReaper statefulBeanReaper = this;
            synchronized (statefulBeanReaper) {
                Tr.dump((TraceComponent)tc, (String)("Number of objects:      " + this.numObjects), (Object[])new Object[0]);
                Tr.dump((TraceComponent)tc, (String)("Number of adds:         " + this.numAdds), (Object[])new Object[0]);
                Tr.dump((TraceComponent)tc, (String)("Number of removes:      " + this.numRemoves), (Object[])new Object[0]);
                Tr.dump((TraceComponent)tc, (String)("Number of null removes: " + this.numNullRemoves), (Object[])new Object[0]);
                Tr.dump((TraceComponent)tc, (String)("Number of deletes:      " + this.numDeletes), (Object[])new Object[0]);
            }
        }
        finally {
            this.dumped = true;
        }
    }

    public void resetDump() {
        this.dumped = false;
    }

    private void startAlarm() {
        this.ivScheduledFuture = this.ivScheduledExecutorService.schedule(this, this.ivSweepInterval, TimeUnit.MILLISECONDS);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("started alarm: " + this.ivScheduledFuture), (Object[])new Object[0]);
        }
    }

    private void stopAlarm() {
        if (this.ivScheduledFuture != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("stopping alarm: " + this.ivScheduledFuture), (Object[])new Object[0]);
            }
            this.ivScheduledFuture.cancel(false);
            this.ivScheduledFuture = null;
        }
    }

    public synchronized void cancel() {
        this.ivIsCanceled = true;
        this.stopAlarm();
        this.ivActivator = null;
        while (this.ivIsRunning) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"interrupted", (Object[])new Object[]{ex});
                }
                Thread.currentThread().interrupt();
            }
        }
    }
}

