/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.jaas.modules;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.CertificateAuthenticator;
import com.ibm.ws.security.authentication.collective.CollectiveAuthenticationPlugin;
import com.ibm.ws.security.authentication.internal.jaas.JAASServiceImpl;
import com.ibm.ws.security.authentication.internal.jaas.modules.ServerCommonLoginModule;
import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.auth.x500.X500Principal;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CertificateLoginModule
extends ServerCommonLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(CertificateLoginModule.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private String username = null;
    private String authenticatedId = null;
    private boolean collectiveCert = false;
    static final long serialVersionUID = -251503513561511931L;

    @Override
    public Callback[] getRequiredCallbacks(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = new Callback[]{new WSX509CertificateChainCallback(null)};
        callbackHandler.handle(callbacks);
        return callbacks;
    }

    @Override
    @FFDCIgnore(value={RegistryException.class, CertificateMapFailedException.class, LoginException.class})
    public boolean login() throws LoginException {
        if (this.isAlreadyProcessed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Already processed by other login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        X509Certificate[] certChain = null;
        try {
            Callback[] callbacks = this.getRequiredCallbacks(this.callbackHandler);
            certChain = ((WSX509CertificateChainCallback)callbacks[0]).getX509CertificateChain();
            if (certChain == null || certChain.length == 0) {
                return false;
            }
            this.setAlreadyProcessed();
            CollectiveAuthenticationPlugin plugin = this.getCollectiveAuthenticationPlugin();
            this.collectiveCert = plugin.isCollectiveCertificateChain(certChain);
            if (this.collectiveCert || plugin.isCollectiveCACertificate(certChain)) {
                this.handleCollectiveLogin(certChain, plugin, this.collectiveCert);
            } else {
                CertificateAuthenticator certAuthen = this.getCertificateAuthenticator(certChain);
                if (certAuthen != null) {
                    this.handleCertificateAuthenticator(certChain, certAuthen);
                } else {
                    this.handleUserLogin(certChain);
                }
            }
            this.updateSharedState();
            return true;
        }
        catch (CertificateMapFailedException e) {
            String dn = certChain[0].getSubjectX500Principal().getName();
            String msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages", (String)"JAAS_AUTHENTICATION_FAILED_CERTNOMAP", (Object[])new Object[]{dn}, (String)"CWWKS1101I: CLIENT-CERT Authentication failed for the client certificate with dn {0}. The dn did not map to a user in the registry.");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CLIENT-CERT Authentication failed for the client certificate with dn " + dn + ". The dn did not map to a user in the registry."), (Object[])new Object[0]);
            }
            throw new AuthenticationException(msg, (Exception)((Object)e));
        }
        catch (RegistryException e) {
            String dn = certChain[0].getSubjectX500Principal().getName();
            String msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages", (String)"JAAS_AUTHENTICATION_FAILED_CERTNOMAP", (Object[])new Object[]{dn}, (String)"CWWKS1101I: CLIENT-CERT Authentication failed for the client certificate with dn {0}. The dn did not map to a user in the registry.");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CLIENT-CERT Authentication failed for the client certificate with dn " + dn + ". The dn did not map to a user in the registry."), (Object[])new Object[0]);
            }
            throw new AuthenticationException(msg, (Exception)((Object)e));
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.CertificateLoginModule", (String)"144", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while processing CertificateLoginModule.login.", (Object[])new Object[]{e});
            }
            String dn = certChain != null ? certChain[0].getSubjectX500Principal().getName() : "certChain=null";
            String msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages", (String)"JAAS_AUTHENTICATION_FAILED_CERT_INTERNAL_ERROR", (Object[])new Object[]{dn, e}, (String)("CWWKS1102E: CLIENT-CERT Authentication failed for the client certificate with dn " + dn + ". An internal error occurred: " + e.getLocalizedMessage()));
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"JAAS_AUTHENTICATION_FAILED_CERT_INTERNAL_ERROR", (Object[])new Object[]{dn, e.getLocalizedMessage()});
            }
            throw new AuthenticationException(msg, e);
        }
    }

    private void handleCertificateAuthenticator(X509Certificate[] certChain, CertificateAuthenticator certAuthen) throws Exception {
        String realm;
        String type = certAuthen.getType();
        if (type == null) {
            type = "user";
        }
        if ((realm = certAuthen.getRealm()) == null) {
            realm = "defaultRealm";
        }
        this.username = this.authenticatedId = certAuthen.getUsername();
        String accessId = AccessIdUtil.createAccessId((String)type, (String)realm, (String)this.authenticatedId);
        this.addCredentials(accessId);
    }

    private CertificateAuthenticator getCertificateAuthenticator(X509Certificate[] certChain) throws LoginException {
        CertificateAuthenticator certAuthen = null;
        ConcurrentServiceReferenceMap<String, CertificateAuthenticator> certAuthens = JAASServiceImpl.getCertificateAuthenticators();
        Set keys = certAuthens.keySet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CertificateAuthenticator keys:", (Object[])new Object[]{keys});
        }
        for (String key : keys) {
            CertificateAuthenticator current = (CertificateAuthenticator)certAuthens.getService((Object)key);
            if (!current.authenticateCertificateChain(certChain)) continue;
            certAuthen = current;
            break;
        }
        return certAuthen;
    }

    private void handleCollectiveLogin(X509Certificate[] certChain, CollectiveAuthenticationPlugin plugin, boolean collectiveCert) throws InvalidNameException, AuthenticationException, Exception {
        plugin.authenticateCertificateChain(certChain, collectiveCert);
        X509Certificate cert = certChain[0];
        X500Principal x509Subject = cert.getSubjectX500Principal();
        String accessId = AccessIdUtil.createAccessId((String)"server", (String)"collective", (String)x509Subject.getName());
        this.username = x509Subject.getName();
        this.authenticatedId = x509Subject.getName();
        this.addCredentials(accessId);
    }

    private void addCredentials(String accessId) throws Exception {
        this.temporarySubject = new Subject();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("com.ibm.wsspi.security.cred.uniqueId", AccessIdUtil.getUniqueId((String)accessId));
        this.temporarySubject.getPublicCredentials().add(hashtable);
        this.setPrincipalAndCredentials(this.temporarySubject, this.username, null, accessId, "certificate");
        this.temporarySubject.getPublicCredentials().remove(hashtable);
    }

    private void handleUserLogin(X509Certificate[] certChain) throws RegistryException, CertificateMapNotSupportedException, CertificateMapFailedException, EntryNotFoundException, Exception {
        X509Certificate cert = certChain[0];
        UserRegistry userRegistry = this.getUserRegistry();
        this.username = userRegistry.mapCertificate(cert);
        this.authenticatedId = userRegistry.getUniqueUserId(this.username);
        this.setUpTemporarySubject();
    }

    private void setUpTemporarySubject() throws Exception {
        this.temporarySubject = new Subject();
        UserRegistry ur = this.getUserRegistry();
        String accessId = AccessIdUtil.createAccessId((String)"user", (String)ur.getRealm(), (String)ur.getUniqueUserId(this.username));
        this.setPrincipalAndCredentials(this.temporarySubject, this.username, this.authenticatedId, accessId, "certificate");
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.authenticatedId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Authentication did not occur for this login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        this.setUpSubject();
        return true;
    }

    @Override
    public boolean abort() {
        this.cleanUpSubject();
        this.authenticatedId = null;
        this.username = null;
        return true;
    }

    @Override
    public boolean logout() {
        this.cleanUpSubject();
        this.authenticatedId = null;
        this.username = null;
        return true;
    }
}

