/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.jaas.modules;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.internal.jaas.modules.ServerCommonLoginModule;
import com.ibm.ws.security.jaas.common.callback.AuthenticationHelper;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.wsspi.security.ltpa.Token;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TokenLoginModule
extends ServerCommonLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(TokenLoginModule.class);
    private String accessId = null;
    private Token recreatedToken;
    static final long serialVersionUID = -4079650138805076390L;

    @Override
    @FFDCIgnore(value={InvalidTokenException.class, TokenExpiredException.class})
    public boolean login() throws LoginException {
        if (this.isAlreadyProcessed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Already processed by other login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        try {
            Callback[] callbacks = this.getRequiredCallbacks(this.callbackHandler);
            byte[] token = ((WSCredTokenCallbackImpl)callbacks[0]).getCredToken();
            if (token == null) {
                return false;
            }
            this.setAlreadyProcessed();
            byte[] credToken = AuthenticationHelper.copyCredToken((byte[])token);
            TokenManager tokenManager = this.getTokenManager();
            this.recreatedToken = tokenManager.recreateTokenFromBytes(credToken);
            this.accessId = this.recreatedToken.getAttributes("u")[0];
            if (AccessIdUtil.isServerAccessId((String)this.accessId)) {
                this.setUpTemporaryServerSubject();
            } else {
                this.setUpTemporaryUserSubject();
            }
            this.updateSharedState();
            return true;
        }
        catch (InvalidTokenException e) {
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (TokenExpiredException e) {
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.TokenLoginModule", (String)"83", (Object)this, (Object[])new Object[0]);
            throw new AuthenticationException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Callback[] getRequiredCallbacks(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = new Callback[]{new WSCredTokenCallbackImpl("Credential Token")};
        callbackHandler.handle(callbacks);
        return callbacks;
    }

    private void setUpTemporaryServerSubject() throws Exception {
        this.temporarySubject = new Subject();
        this.temporarySubject.getPrivateCredentials().add(this.recreatedToken);
        String securityName = AccessIdUtil.getUniqueId((String)this.accessId);
        this.setPrincipalAndCredentials(this.temporarySubject, securityName, null, this.accessId, "token");
    }

    private void setUpTemporaryUserSubject() throws Exception {
        this.temporarySubject = new Subject();
        this.temporarySubject.getPrivateCredentials().add(this.recreatedToken);
        UserRegistry ur = this.getUserRegistry();
        String securityName = ur.getUserSecurityName(AccessIdUtil.getUniqueId((String)this.accessId));
        securityName = this.getSecurityName(securityName, securityName);
        this.setPrincipalAndCredentials(this.temporarySubject, securityName, null, this.accessId, "token");
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.accessId == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Authentication did not occur for this login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        this.setUpSubject();
        return true;
    }

    @Override
    public boolean abort() {
        this.cleanUpSubject();
        this.accessId = null;
        return true;
    }

    @Override
    public boolean logout() {
        this.cleanUpSubject();
        this.accessId = null;
        return true;
    }
}

