/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.opentracing.OpentracingTracerManager;
import com.ibm.ws.opentracing.OpentracingUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.ActiveSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component
public class OpentracingClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final TraceComponent tc = Tr.register(OpentracingClientFilter.class);
    public static final String CLIENT_SPAN_PROP_ID = OpentracingClientFilter.class.getName() + ".Span";
    public static final String CLIENT_SPAN_SKIPPED_ID = OpentracingClientFilter.class.getName() + ".Skipped";
    static final long serialVersionUID = 2157894108101323963L;

    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        SpanContext nextContext;
        boolean process;
        String methodName = "filter(outgoing)";
        Tracer tracer = OpentracingTracerManager.getTracer();
        if (tracer == null) {
            Tr.error((TraceComponent)tc, (String)"OPENTRACING_NO_TRACER_FOR_OUTBOUND_REQUEST", (Object[])new Object[0]);
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{OpentracingUtils.getTracerText(tracer)});
        }
        URI outgoingUri = clientRequestContext.getUri();
        String outgoingURL = outgoingUri.toURL().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " outgoing URL"), (Object[])new Object[]{outgoingURL});
        }
        ActiveSpan priorIncomingSpan = tracer.activeSpan();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " parent"), (Object[])new Object[]{priorIncomingSpan});
        }
        if (process = true) {
            Tracer.SpanBuilder spanBuilder = tracer.buildSpan(outgoingURL);
            spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "client");
            spanBuilder.withTag(Tags.HTTP_URL.getKey(), outgoingURL);
            spanBuilder.withTag(Tags.HTTP_METHOD.getKey(), clientRequestContext.getMethod());
            if (priorIncomingSpan != null) {
                spanBuilder.asChildOf(priorIncomingSpan.context());
            }
            Span newOutoingSpan = spanBuilder.startManual();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " outgoingSpan"), (Object[])new Object[]{newOutoingSpan});
            }
            nextContext = newOutoingSpan.context();
            clientRequestContext.setProperty(CLIENT_SPAN_PROP_ID, (Object)newOutoingSpan);
        } else {
            nextContext = priorIncomingSpan.context();
        }
        tracer.inject(nextContext, Format.Builtin.HTTP_HEADERS, new MultivaluedMapToTextMap((MultivaluedMap<String, Object>)clientRequestContext.getHeaders()));
        clientRequestContext.setProperty(CLIENT_SPAN_SKIPPED_ID, (Object)(!process ? 1 : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        String methodName = "filter(incoming)";
        if (((Boolean)clientRequestContext.getProperty(CLIENT_SPAN_SKIPPED_ID)).booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"skipped"});
            }
            clientRequestContext.removeProperty(CLIENT_SPAN_SKIPPED_ID);
            return;
        }
        Span priorOutgoingSpan = (Span)clientRequestContext.getProperty(CLIENT_SPAN_PROP_ID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{priorOutgoingSpan});
        }
        if (priorOutgoingSpan == null) {
            Tr.error((TraceComponent)tc, (String)"OPENTRACING_NO_SPAN_FOR_RESPONSE_TO_OUTBOUND_REQUEST", (Object[])new Object[0]);
            return;
        }
        try {
            Integer httpStatus = clientResponseContext.getStatus();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " httpStatus"), (Object[])new Object[]{httpStatus});
            }
            priorOutgoingSpan.setTag(Tags.HTTP_STATUS.getKey(), httpStatus);
            if (clientResponseContext.getStatus() >= 400) {
                priorOutgoingSpan.setTag(Tags.ERROR.getKey(), true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " error"), (Object[])new Object[]{Boolean.TRUE});
                }
            }
            priorOutgoingSpan.finish();
        }
        finally {
            clientRequestContext.removeProperty(CLIENT_SPAN_PROP_ID);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, Object> mvMap;
        static final long serialVersionUID = 4322697928672580337L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapToTextMap(MultivaluedMap<String, Object> mvMap) {
            this.mvMap = mvMap;
        }

        @Override
        @Trivial
        public Iterator<Map.Entry<String, String>> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Trivial
        public void put(String key, String value) {
            this.mvMap.add((Object)key, (Object)value);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MultivaluedMapToTextMap.class);
        }
    }
}

