/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.opentracing.OpentracingTracerManager;
import com.ibm.ws.opentracing.OpentracingUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OpentracingContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final TraceComponent tc = Tr.register(OpentracingContainerFilter.class);
    public static final String SERVER_SPAN_PROP_ID = OpentracingContainerFilter.class.getName() + ".Span";
    public static final String SERVER_SPAN_SKIPPED_ID = OpentracingContainerFilter.class.getName() + ".Skipped";
    static final long serialVersionUID = -9011762026406231265L;

    public void filter(ContainerRequestContext incomingRequestContext) throws IOException {
        boolean process;
        String methodName = "filter(incoming)";
        Tracer tracer = OpentracingTracerManager.getTracer();
        if (tracer == null) {
            Tr.error((TraceComponent)tc, (String)"OPENTRACING_NO_TRACER_FOR_INBOUND_REQUEST", (Object[])new Object[0]);
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{OpentracingUtils.getTracerText(tracer)});
        }
        URI incomingUri = incomingRequestContext.getUriInfo().getRequestUri();
        String incomingURL = incomingUri.toURL().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " incomingURL"), (Object[])new Object[]{incomingURL});
        }
        SpanContext priorOutgoingContext = tracer.extract(Format.Builtin.HTTP_HEADERS, new MultivaluedMapToTextMap((MultivaluedMap<String, String>)incomingRequestContext.getHeaders()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " priorContext"), (Object[])new Object[]{priorOutgoingContext});
        }
        if (process = true) {
            Tracer.SpanBuilder spanBuilder = tracer.buildSpan(incomingURL);
            spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server");
            spanBuilder.withTag(Tags.HTTP_URL.getKey(), incomingURL);
            spanBuilder.withTag(Tags.HTTP_METHOD.getKey(), incomingRequestContext.getMethod());
            if (priorOutgoingContext != null) {
                spanBuilder.asChildOf(priorOutgoingContext);
            } else {
                spanBuilder.ignoreActiveSpan();
            }
            Span newIncomingSpan = spanBuilder.startManual();
            tracer.makeActive(newIncomingSpan);
            incomingRequestContext.setProperty(SERVER_SPAN_PROP_ID, (Object)newIncomingSpan);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " contextSpan"), (Object[])new Object[]{newIncomingSpan});
            }
        }
        incomingRequestContext.setProperty(SERVER_SPAN_SKIPPED_ID, (Object)(!process ? 1 : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext incomingRequestContext, ContainerResponseContext outgoingResponseContext) throws IOException {
        String methodName = "filter(outgoing)";
        if (((Boolean)incomingRequestContext.getProperty(SERVER_SPAN_SKIPPED_ID)).booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " skipped"), (Object[])new Object[0]);
            }
            incomingRequestContext.removeProperty(SERVER_SPAN_SKIPPED_ID);
            return;
        }
        Span incomingSpan = (Span)incomingRequestContext.getProperty(SERVER_SPAN_PROP_ID);
        if (incomingSpan == null) {
            Tr.error((TraceComponent)tc, (String)"OPENTRACING_NO_SPAN_FOR_RESPONSE_TO_INBOUND_REQUEST", (Object[])new Object[0]);
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " incomingSpan"), (Object[])new Object[]{incomingSpan});
        }
        try {
            Integer httpStatus = outgoingResponseContext.getStatus();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " httpStatus"), (Object[])new Object[]{httpStatus});
            }
            incomingSpan.setTag(Tags.HTTP_STATUS.getKey(), httpStatus);
            if (outgoingResponseContext.getStatus() >= 400) {
                incomingSpan.setTag(Tags.ERROR.getKey(), true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " error"), (Object[])new Object[]{Boolean.TRUE});
                }
            }
        }
        finally {
            incomingSpan.finish();
            incomingRequestContext.removeProperty(SERVER_SPAN_PROP_ID);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class MultivaluedMapFlatIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, List<V>>> mapIterator;
        private Map.Entry<K, List<V>> mapEntry;
        private Iterator<V> mapEntryIterator;
        static final long serialVersionUID = -6974682979189613423L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapFlatIterator(Set<Map.Entry<K, List<V>>> multiValuesEntrySet) {
            this.mapIterator = multiValuesEntrySet.iterator();
            this.mapEntry = null;
            this.mapEntryIterator = null;
        }

        @Override
        @Trivial
        public boolean hasNext() {
            return this.mapEntryIterator != null && this.mapEntryIterator.hasNext() || this.mapIterator.hasNext();
        }

        @Override
        @Trivial
        public Map.Entry<K, V> next() {
            if (this.mapEntry == null || !this.mapEntryIterator.hasNext() && this.mapIterator.hasNext()) {
                this.mapEntry = this.mapIterator.next();
                this.mapEntryIterator = this.mapEntry.getValue().iterator();
            }
            if (this.mapEntryIterator.hasNext()) {
                return new AbstractMap.SimpleImmutableEntry<K, V>(this.mapEntry.getKey(), this.mapEntryIterator.next());
            }
            return new AbstractMap.SimpleImmutableEntry<K, Object>(this.mapEntry.getKey(), null);
        }

        @Override
        @Trivial
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MultivaluedMapFlatIterator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, String> mvMap;
        static final long serialVersionUID = 6611779749445754816L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapToTextMap(MultivaluedMap<String, String> mvMap) {
            this.mvMap = mvMap;
        }

        @Override
        @Trivial
        public Iterator<Map.Entry<String, String>> iterator() {
            return new MultivaluedMapFlatIterator<String, String>(this.mvMap.entrySet());
        }

        @Override
        @Trivial
        public void put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MultivaluedMapToTextMap.class);
        }
    }
}

