/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility.extension;

import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandUtils;
import com.ibm.ws.product.utility.extension.FileUtils;
import com.ibm.ws.product.utility.extension.MD5Utils;
import com.ibm.ws.product.utility.extension.ifix.xml.BundleFile;
import com.ibm.ws.product.utility.extension.ifix.xml.Bundles;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.LibertyProfileMetadataFile;
import com.ibm.ws.product.utility.extension.ifix.xml.Problem;
import com.ibm.ws.product.utility.extension.ifix.xml.UpdatedFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.aries.util.manifest.BundleManifest;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class IFixUtils {
    private static Unmarshaller unmarshaller;

    public static Set<IFixInfo> getInstalledIFixes(File wlpInstallationDirectory, CommandConsole console) {
        File[] iFixFiles;
        HashSet<IFixInfo> iFixInfos = new HashSet<IFixInfo>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{IFixInfo.class});
            unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.create.parser", e.getMessage()));
            return iFixInfos;
        }
        for (File file : iFixFiles = IFixUtils.findIFixXmlFiles(wlpInstallationDirectory)) {
            try {
                IFixInfo iFixInfo = (IFixInfo)unmarshaller.unmarshal(file);
                iFixInfos.add(iFixInfo);
            }
            catch (JAXBException e) {
                console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.read.file", file.getAbsolutePath(), e.getMessage()));
            }
        }
        return iFixInfos;
    }

    public static Set<LibertyProfileMetadataFile> getInstalledLibertyProfileMetadataFiles(File wlpInstallationDirectory, CommandConsole console) {
        File[] lpmfFiles;
        HashSet<LibertyProfileMetadataFile> lpmfInfos = new HashSet<LibertyProfileMetadataFile>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LibertyProfileMetadataFile.class});
            unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.create.parser", e.getMessage()));
            return lpmfInfos;
        }
        for (File file : lpmfFiles = IFixUtils.findLPMFXmlFiles(wlpInstallationDirectory)) {
            try {
                LibertyProfileMetadataFile lpmfInfo = (LibertyProfileMetadataFile)unmarshaller.unmarshal(file);
                lpmfInfos.add(lpmfInfo);
            }
            catch (JAXBException e) {
                console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.read.file", file.getAbsolutePath(), e.getMessage()));
            }
        }
        return lpmfInfos;
    }

    public static IFixInfo parseIFix(InputStream in, String path, CommandConsole console) {
        try {
            return (IFixInfo)unmarshaller.unmarshal(in);
        }
        catch (JAXBException e) {
            console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.read.file", path, e.getMessage()));
            return null;
        }
    }

    private static File[] findIFixXmlFiles(File wlpInstallationDirectory) {
        File iFixDirectory = new File(wlpInstallationDirectory, "lib/fixes");
        if (!iFixDirectory.exists() || !iFixDirectory.isDirectory()) {
            return new File[0];
        }
        File[] iFixFiles = iFixDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return FileUtils.matchesFileExtension(".xml", fileName);
            }
        });
        return iFixFiles;
    }

    private static File[] findLPMFXmlFiles(File wlpInstallationDirectory) {
        File lpmfDirectory = new File(wlpInstallationDirectory, "lib/fixes");
        if (!lpmfDirectory.exists() || !lpmfDirectory.isDirectory()) {
            return new File[0];
        }
        File[] lpmfFiles = lpmfDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return FileUtils.matchesFileExtension(".lpmf", fileName);
            }
        });
        return lpmfFiles;
    }

    protected static String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    public static Set<String> getIFixesThatMustBeReapplied(File installDir, Map<String, ProvisioningFeatureDefinition> features, ContentBasedLocalBundleRepository repo, CommandConsole console) {
        HashSet<String> ifixesToReApply = new HashSet<String>();
        HashMap<File, Map<String, Version>> allBaseBundleJarContent = new HashMap<File, Map<String, Version>>();
        HashSet<File> allBundleJarContent = new HashSet<File>();
        HashSet<File> allStaticFileContent = new HashSet<File>();
        IFixUtils.processSubsystemContent(installDir, features, repo, allBaseBundleJarContent, allBundleJarContent, allStaticFileContent, console);
        Map<String, BundleFile> bundleFiles = IFixUtils.processLPMFXmls(installDir, console);
        for (Map.Entry<String, IFixInfo> ifixInfoEntry : IFixUtils.processIFixXmls(installDir, bundleFiles, console).entrySet()) {
            String updateFileName = ifixInfoEntry.getKey();
            IFixInfo ifixInfo = ifixInfoEntry.getValue();
            for (UpdatedFile updatedFile : ifixInfo.getUpdates().getFiles()) {
                String ifixHash;
                if (!updatedFile.getId().equals(updateFileName)) continue;
                File updateFile = new File(installDir, updateFileName);
                if (allStaticFileContent.contains(updateFile)) {
                    if (updateFile.exists()) {
                        ifixHash = updatedFile.getHash();
                        try {
                            if (IFixUtils.equalsHashes(updateFile, ifixHash)) continue;
                            ifixesToReApply.add(ifixInfo.getId());
                        }
                        catch (IOException ioe) {
                            console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.read.file", updateFile.getAbsolutePath(), ioe.getMessage()));
                        }
                        continue;
                    }
                    ifixesToReApply.add(ifixInfo.getId());
                    continue;
                }
                if (allBundleJarContent.contains(updateFile)) {
                    ifixHash = updatedFile.getHash();
                    try {
                        if (IFixUtils.equalsHashes(updateFile, ifixHash)) continue;
                        ifixesToReApply.add(ifixInfo.getId());
                    }
                    catch (IOException ioe) {
                        console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.read.file", updateFile.getAbsolutePath(), ioe.getMessage()));
                    }
                    continue;
                }
                BundleFile bundleFile = bundleFiles.get(updatedFile.getId());
                if (bundleFile == null) continue;
                String bundleSymbolicName = bundleFile.getSymbolicName();
                Version bundleVersion = new Version(bundleFile.getVersion());
                boolean found = false;
                Iterator iter = allBaseBundleJarContent.values().iterator();
                while (iter.hasNext() && !found) {
                    for (Map.Entry bundleEntry : ((Map)iter.next()).entrySet()) {
                        String entrySymbolicName = (String)bundleEntry.getKey();
                        Version entryVersion = (Version)bundleEntry.getValue();
                        if (!bundleSymbolicName.equals(entrySymbolicName) || bundleVersion.getMajor() != entryVersion.getMajor() || bundleVersion.getMinor() != entryVersion.getMinor() || bundleVersion.getMicro() != entryVersion.getMicro()) continue;
                        found = true;
                    }
                }
                if (!found) continue;
                ifixesToReApply.add(ifixInfo.getId());
            }
        }
        return ifixesToReApply;
    }

    private static boolean equalsHashes(File fileToHash, String hashToCompare) throws IOException {
        boolean result = false;
        String fileHash = MD5Utils.getFileMD5String(fileToHash);
        if (fileHash.equals(hashToCompare)) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void processSubsystemContent(File installDir, Map<String, ProvisioningFeatureDefinition> features, ContentBasedLocalBundleRepository repo, Map<File, Map<String, Version>> allBaseBundleJarContent, Set<File> allBundleJarContent, Set<File> allStaticFileContent, CommandConsole console) {
        for (Map.Entry<String, ProvisioningFeatureDefinition> entry : features.entrySet()) {
            ProvisioningFeatureDefinition featureDef = entry.getValue();
            allStaticFileContent.add(new File(featureDef.getFeatureDefinitionFile().getAbsolutePath()));
            for (FeatureResource featureRes : featureDef.getConstituents(null)) {
                VersionRange versionRange;
                SubsystemContentType type = featureRes.getType();
                if (type == SubsystemContentType.FEATURE_TYPE) continue;
                String symbolicName = featureRes.getSymbolicName();
                String location = featureRes.getLocation();
                File runtimeFile = repo.selectBundle(location, symbolicName, versionRange = featureRes.getVersionRange());
                if (runtimeFile != null) {
                    allBundleJarContent.add(runtimeFile);
                    File runtimeBaseBundle = repo.selectBaseBundle(location, symbolicName, versionRange);
                    if (runtimeBaseBundle == null) continue;
                    InputStream zis = null;
                    ZipFile zipFile = null;
                    zipFile = new ZipFile(runtimeBaseBundle);
                    ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
                    zis = zipFile.getInputStream(zipEntry);
                    Manifest manifest = ManifestProcessor.parseManifest((InputStream)zis);
                    BundleManifest bundleManifest = new BundleManifest(manifest);
                    HashMap<String, Version> bundleNameVersion = new HashMap<String, Version>();
                    bundleNameVersion.put(bundleManifest.getSymbolicName(), bundleManifest.getVersion());
                    allBaseBundleJarContent.put(runtimeBaseBundle, bundleNameVersion);
                    try {
                        if (zis != null) {
                            zis.close();
                        }
                        if (zipFile == null) continue;
                        zipFile.close();
                    }
                    catch (IOException ioe) {
                        console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.read.file", runtimeFile.getAbsolutePath(), ioe.getMessage()));
                    }
                    continue;
                    catch (Exception e) {
                        try {
                            console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.read.file", runtimeFile.getAbsolutePath(), e.getMessage()));
                        }
                        catch (Throwable throwable) {
                            try {
                                if (zis != null) {
                                    zis.close();
                                }
                                if (zipFile != null) {
                                    zipFile.close();
                                }
                            }
                            catch (IOException ioe) {
                                console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.read.file", runtimeFile.getAbsolutePath(), ioe.getMessage()));
                            }
                            throw throwable;
                        }
                        try {
                            if (zis != null) {
                                zis.close();
                            }
                            if (zipFile == null) continue;
                            zipFile.close();
                        }
                        catch (IOException ioe) {
                            console.printlnErrorMessage(IFixUtils.getMessage("ifixutils.unable.to.read.file", runtimeFile.getAbsolutePath(), ioe.getMessage()));
                        }
                        continue;
                    }
                }
                if (location == null) continue;
                allStaticFileContent.add(new File(installDir, location));
            }
        }
    }

    private static Map<String, IFixInfo> processIFixXmls(File wlpInstallationDirectory, Map<String, BundleFile> bundleFiles, CommandConsole console) {
        HashMap<String, IFixInfo> filteredIfixInfos = new HashMap<String, IFixInfo>();
        HashMap<String, UpdatedFile> latestIfixFiles = new HashMap<String, UpdatedFile>();
        Set<IFixInfo> ifixInfos = IFixUtils.getInstalledIFixes(wlpInstallationDirectory, console);
        for (IFixInfo chkinfo : ifixInfos) {
            for (UpdatedFile updateFile : chkinfo.getUpdates().getFiles()) {
                String updateId = updateFile.getId();
                String existingUpdateFileID = bundleFiles.containsKey(updateId) ? IFixUtils.getExistingMatchingIfixID(bundleFiles.get(updateId), latestIfixFiles.keySet(), bundleFiles) : updateId;
                UpdatedFile existingUpdateFile = (UpdatedFile)latestIfixFiles.get(existingUpdateFileID);
                if (existingUpdateFile != null) {
                    int dateComparison = updateFile.getDate().compareTo(existingUpdateFile.getDate());
                    boolean replaceInMap = false;
                    if (dateComparison > 0) {
                        replaceInMap = true;
                    } else if (dateComparison == 0) {
                        IFixInfo existingFixInfo = (IFixInfo)filteredIfixInfos.get(existingUpdateFileID);
                        List<Problem> existingProblems = existingFixInfo.getResolves().getProblems();
                        List<Problem> problems = chkinfo.getResolves().getProblems();
                        if (existingProblems.size() < problems.size()) {
                            replaceInMap = true;
                        }
                    }
                    if (!replaceInMap) continue;
                    filteredIfixInfos.remove(existingUpdateFileID);
                    latestIfixFiles.remove(existingUpdateFileID);
                    filteredIfixInfos.put(updateId, chkinfo);
                    latestIfixFiles.put(updateId, updateFile);
                    continue;
                }
                filteredIfixInfos.put(updateId, chkinfo);
                latestIfixFiles.put(updateId, updateFile);
            }
        }
        return filteredIfixInfos;
    }

    static Map<String, IFixInfo> getLatestFixInfos(File wlpInstallationDirectory, CommandConsole console) {
        return IFixUtils.processIFixXmls(wlpInstallationDirectory, IFixUtils.processLPMFXmls(wlpInstallationDirectory, console), console);
    }

    private static String getExistingMatchingIfixID(BundleFile bundleFile, Set<String> existingIDs, Map<String, BundleFile> bundleFiles) {
        String existingIfixKey = null;
        for (String existingID : existingIDs) {
            if (!bundleFiles.containsKey(existingID)) continue;
            BundleFile existingBundleFile = bundleFiles.get(existingID);
            if (!bundleFile.getSymbolicName().equals(existingBundleFile.getSymbolicName())) continue;
            Version existingBundleVersion = new Version(existingBundleFile.getVersion());
            Version bundleVersion = new Version(bundleFile.getVersion());
            if (bundleVersion.getMajor() != existingBundleVersion.getMajor() || bundleVersion.getMinor() != existingBundleVersion.getMinor() || bundleVersion.getMicro() != existingBundleVersion.getMicro()) continue;
            existingIfixKey = existingID;
        }
        return existingIfixKey;
    }

    private static Map<String, BundleFile> processLPMFXmls(File wlpInstallationDirectory, CommandConsole console) {
        HashMap<String, BundleFile> bundleFiles = new HashMap<String, BundleFile>();
        for (LibertyProfileMetadataFile chklpmf : IFixUtils.getInstalledLibertyProfileMetadataFiles(wlpInstallationDirectory, console)) {
            List<BundleFile> bundleEntries;
            Bundles bundles = chklpmf.getBundles();
            if (bundles == null || (bundleEntries = bundles.getBundleFiles()) == null) continue;
            for (BundleFile bundleFile : bundleEntries) {
                bundleFiles.put(bundleFile.getId(), bundleFile);
            }
        }
        return bundleFiles;
    }
}

