/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.impl.FastHashtableEntry;
import com.ibm.ws.sib.matchspace.impl.FastHashtableEnumerator;
import com.ibm.ws.sib.matchspace.utils.FFDC;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;

public class MatchCache
extends Dictionary
implements Cloneable,
Serializable {
    private static final Class cclass = MatchCache.class;
    private static Trace tc = TraceUtils.getTrace(MatchCache.class, (String)"SIBMatchSpace");
    protected transient FastHashtableEntry[] table;
    protected transient int count;
    protected int threshold;
    private float loadFactor;
    private RehashFilter filter;
    private static final long serialVersionUID = 1421746759512286392L;

    public MatchCache(int initialCapacity, float loadFactor) {
        if (tc.isEntryEnabled()) {
            tc.entry(cclass, "MatchCache", new Object[]{new Integer(initialCapacity), new Float(loadFactor)});
        }
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new FastHashtableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
        if (tc.isEntryEnabled()) {
            tc.exit(cclass, "MatchCache", (Object)this);
        }
    }

    public MatchCache(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public MatchCache() {
        this(101, 0.75f);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new FastHashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new FastHashtableEnumerator(this.table, false);
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        FastHashtableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            FastHashtableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        FastHashtableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(Object key) {
        FastHashtableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object get(Object key, int hash) {
        FastHashtableEntry[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public void setRehashFilter(RehashFilter filter) {
        this.filter = filter;
    }

    private boolean ableToFilter() {
        if (this.filter == null) {
            return false;
        }
        int i = this.table.length;
        while (i-- > 0) {
            FastHashtableEntry newContents = null;
            FastHashtableEntry next = null;
            FastHashtableEntry e = this.table[i];
            while (e != null) {
                next = e.next;
                if (this.filter.shouldRetain(e.key, e.value)) {
                    e.next = newContents;
                    newContents = e;
                } else {
                    --this.count;
                }
                e = next;
            }
            this.table[i] = newContents;
        }
        return this.count < this.threshold;
    }

    protected void rehash() {
        if (this.ableToFilter()) {
            return;
        }
        int oldCapacity = this.table.length;
        FastHashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        FastHashtableEntry[] newTable = new FastHashtableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        int i = oldCapacity;
        while (i-- > 0) {
            FastHashtableEntry old = oldTable[i];
            while (old != null) {
                FastHashtableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
        this.table = newTable;
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        FastHashtableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new FastHashtableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object put(Object key, int hash, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        FastHashtableEntry[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new FastHashtableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object remove(Object key) {
        FastHashtableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        FastHashtableEntry e = tab[index];
        FastHashtableEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        FastHashtableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            MatchCache t = (MatchCache)super.clone();
            t.table = new FastHashtableEntry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (FastHashtableEntry)this.table[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchCache.clone", (Throwable)e, (String)"1:589:1.16");
            throw new IllegalStateException();
        }
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append("Cache:" + this.hashCode());
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        for (int index = this.table.length - 1; index >= 0; --index) {
            FastHashtableEntry entry = this.table[index];
            while (entry != null) {
                s.writeObject(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int origlength = s.readInt();
        int elements = s.readInt();
        int length = (int)((float)elements * this.loadFactor) + elements / 20 + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        if (origlength > 0 && length > origlength) {
            length = origlength;
        }
        this.table = new FastHashtableEntry[length];
        this.count = 0;
        while (elements > 0) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
            --elements;
        }
    }

    static interface RehashFilter {
        public boolean shouldRetain(Object var1, Object var2);
    }
}

