/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPReferenceStream;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class SIMPItemStream
extends ItemStream {
    private static final TraceComponent tc = SibTr.register(SIMPItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int DEFAULT_PERSISTENT_VERSION = 1;
    private int storageStrategy = 4;

    public void removeAll(Transaction tran) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAll", (Object)tran);
        }
        Item item = null;
        SIMPItemStream itemStream = null;
        SIMPReferenceStream referenceStream = null;
        while (null != (item = this.findFirstMatchingItem(null))) {
            item.remove(tran, -2L);
        }
        while (null != (itemStream = (SIMPItemStream)this.findFirstMatchingItemStream(null))) {
            itemStream.removeAll(tran);
        }
        while (null != (referenceStream = (SIMPReferenceStream)this.findFirstMatchingReferenceStream(null))) {
            referenceStream.removeAll(tran);
        }
        this.removeItemStream(tran, -2L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAllItems");
        }
    }

    public void removeItemStream(Transaction transaction, long lockID) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeItemStream", (Object)new Object[]{transaction, new Long(lockID)});
        }
        this.remove(transaction, lockID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeItemStream");
        }
    }

    public final int getStorageStrategy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(this.storageStrategy));
        }
        return this.storageStrategy;
    }

    protected final void setStorageStrategy(int setStrategy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStorageStrategy", (Object)new Integer(setStrategy));
        }
        this.storageStrategy = setStrategy;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStorageStrategy");
        }
    }

    public int getPersistentVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentVersion");
            SibTr.exit((TraceComponent)tc, (String)"getPersistentVersion", (Object)new Integer(1));
        }
        return 1;
    }

    protected void getPersistentData(ObjectOutputStream oos) {
    }

    protected void restore(ObjectInputStream ois, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Integer(dataVersion));
        }
        this.checkPersistentVersionId(dataVersion);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public final List<DataSlice> getPersistentData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeInt(this.getPersistentVersion());
            this.getPersistentData(oos);
            oos.close();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream.getPersistentData", (String)"1:297:1.54", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)e);
            }
            throw new SIErrorException((Throwable)e);
        }
        byte[] data = bos.toByteArray();
        ArrayList<DataSlice> dataSlices = new ArrayList<DataSlice>(1);
        dataSlices.add(new DataSlice(data));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData", dataSlices);
        }
        return dataSlices;
    }

    protected void checkPersistentVersionId(int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)new Integer(dataVersion));
        }
        if (dataVersion != this.getPersistentVersion()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"ITEM_RESTORE_ERROR_CWSIP0261", (Object)new Object[]{new Integer(this.getPersistentVersion()), new Integer(dataVersion)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("ITEM_RESTORE_ERROR_CWSIP0261", new Object[]{new Integer(this.getPersistentVersion()), new Integer(dataVersion)}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId");
        }
    }

    public final void restore(List<DataSlice> dataSlices) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", dataSlices);
        }
        try {
            DataSlice slice = dataSlices.get(0);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(slice.getBytes()));
            this.restore(ois, ois.readInt());
            ois.close();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream.restore", (String)"1:372:1.54", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)e);
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void setCurrentTransaction(SIMPMessage msg, boolean isRemote) {
    }
}

