/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1OctetString;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DEROutputStream;
import com.ibm.ws.transport.iiop.asn1.DERString;
import java.io.IOException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DERVisibleString
extends DERObject
implements DERString {
    String string;
    static final long serialVersionUID = 4211326883787017537L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static DERVisibleString getInstance(Object obj) {
        if (obj == null || obj instanceof DERVisibleString) {
            return (DERVisibleString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERVisibleString(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERVisibleString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERVisibleString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERVisibleString.getInstance(obj.getObject());
    }

    public DERVisibleString(byte[] string) {
        char[] cs = new char[string.length];
        for (int i = 0; i != cs.length; ++i) {
            cs[i] = (char)(string[i] & 0xFF);
        }
        this.string = new String(cs);
    }

    public DERVisibleString(String string) {
        this.string = string;
    }

    @Override
    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cs = this.string.toCharArray();
        byte[] bs = new byte[cs.length];
        for (int i = 0; i != cs.length; ++i) {
            bs[i] = (byte)cs[i];
        }
        return bs;
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(26, this.getOctets());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERVisibleString)) {
            return false;
        }
        return this.getString().equals(((DERVisibleString)o).getString());
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DERVisibleString.class);
    }
}

