/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1EncodableVector;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERObjectIdentifier;
import com.ibm.ws.transport.iiop.asn1.DERSequence;
import com.ibm.ws.transport.iiop.asn1.x509.AccessDescription;
import com.ibm.ws.transport.iiop.asn1.x509.GeneralName;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthorityInformationAccess
extends ASN1Encodable {
    private AccessDescription[] descriptions;
    static final long serialVersionUID = 8998723063153156836L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static AuthorityInformationAccess getInstance(Object obj) {
        if (obj instanceof AuthorityInformationAccess) {
            return (AuthorityInformationAccess)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new AuthorityInformationAccess((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AuthorityInformationAccess(ASN1Sequence seq) {
        this.descriptions = new AccessDescription[seq.size()];
        for (int i = 0; i != seq.size(); ++i) {
            this.descriptions[i] = AccessDescription.getInstance(seq.getObjectAt(i));
        }
    }

    public AuthorityInformationAccess(DERObjectIdentifier oid, GeneralName location) {
        this.descriptions = new AccessDescription[1];
        this.descriptions[0] = new AccessDescription(oid, location);
    }

    public AccessDescription[] getAccessDescriptions() {
        return this.descriptions;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i != this.descriptions.length; ++i) {
            vec.add(this.descriptions[i]);
        }
        return new DERSequence(vec);
    }

    public String toString() {
        return "AuthorityInformationAccess: Oid(" + this.descriptions[0].getAccessMethod().getId() + ")";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AuthorityInformationAccess.class);
    }
}

