/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1EncodableVector;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.DERInteger;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERSequence;
import com.ibm.ws.transport.iiop.asn1.x509.DisplayText;
import java.util.Enumeration;
import java.util.Vector;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NoticeReference
extends ASN1Encodable {
    DisplayText organization;
    ASN1Sequence noticeNumbers;
    static final long serialVersionUID = 5603896261686125559L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public NoticeReference(String orgName, Vector numbers) {
        this.organization = new DisplayText(orgName);
        Object o = numbers.elementAt(0);
        ASN1EncodableVector av = new ASN1EncodableVector();
        if (o instanceof Integer) {
            Enumeration it = numbers.elements();
            while (it.hasMoreElements()) {
                Integer nm = (Integer)it.nextElement();
                DERInteger di = new DERInteger(nm);
                av.add(di);
            }
        }
        this.noticeNumbers = new DERSequence(av);
    }

    public NoticeReference(String orgName, ASN1Sequence numbers) {
        this.organization = new DisplayText(orgName);
        this.noticeNumbers = numbers;
    }

    public NoticeReference(int displayTextType, String orgName, ASN1Sequence numbers) {
        this.organization = new DisplayText(displayTextType, orgName);
        this.noticeNumbers = numbers;
    }

    public NoticeReference(ASN1Sequence as) {
        this.organization = DisplayText.getInstance(as.getObjectAt(0));
        this.noticeNumbers = (ASN1Sequence)as.getObjectAt(1);
    }

    public static NoticeReference getInstance(Object as) {
        if (as instanceof NoticeReference) {
            return (NoticeReference)as;
        }
        if (as instanceof ASN1Sequence) {
            return new NoticeReference((ASN1Sequence)as);
        }
        throw new IllegalArgumentException("unknown object in getInstance.");
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector av = new ASN1EncodableVector();
        av.add(this.organization);
        av.add(this.noticeNumbers);
        return new DERSequence(av);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(NoticeReference.class);
    }
}

