/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SSLConfigValidator.class}, property={"service.vendor=IBM"})
public class SSLConfigValidator {
    private static final int VALIDATION_DELAY_IN_SECONDS = 60;
    private static final TraceComponent tc = Tr.register(SSLConfigValidator.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private ConfigurationAdmin configAdmin;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> scheduled;

    @Reference(service=ConfigurationAdmin.class)
    protected void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    @Reference(service=ScheduledExecutorService.class)
    protected void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    protected void unsetExecutorService(ScheduledExecutorService executorService) {
        this.executorService = null;
    }

    public void validate(Map<String, Object> map, Map<String, Map<String, Object>> repertoires, Map<String, WSKeyStore> keystores) {
        if (!FrameworkState.isStopping()) {
            Validator validator = new Validator(map, repertoires, keystores);
            if (this.executorService != null) {
                this.scheduleValidation(validator);
            } else {
                validator.run();
            }
        }
    }

    private void scheduleValidation(Validator validator) {
        if (this.scheduled != null) {
            this.scheduled.cancel(false);
        }
        this.scheduled = this.executorService.schedule(validator, 60L, TimeUnit.SECONDS);
    }

    private class Validator
    implements Runnable {
        private final Map<String, Object> map;
        private final Map<String, Map<String, Object>> repertoires;
        private final Map<String, WSKeyStore> keystores;

        public Validator(Map<String, Object> map, Map<String, Map<String, Object>> repertoires, Map<String, WSKeyStore> keystores) {
            this.map = map;
            this.repertoires = repertoires;
            this.keystores = keystores;
        }

        @Override
        public void run() {
            this.validateNow();
        }

        private void validateNow() {
            String defaultSSLKeyStoreRef = this.getDefaultRepetorieKeyStore();
            if (defaultSSLKeyStoreRef != null) {
                if ("defaultKeyStore".equals(defaultSSLKeyStoreRef)) {
                    this.warnIfUsingUnresolvedDefaultConfiguration();
                } else {
                    this.reportErrorIfDefaultSSLConfigReferencesMissingKeystore(defaultSSLKeyStoreRef);
                }
            }
        }

        private void warnIfUsingUnresolvedDefaultConfiguration() {
            if (this.isUsingDefaultSSLRepertoire() && this.defaultRepertoireIsNotAvailable() && this.defaultKeyStoreIsNotAvailable()) {
                Tr.audit((TraceComponent)tc, (String)"ssl.defaultKeyStore.expected.CWPKI0817A", (Object[])new Object[]{"defaultKeyStore"});
            }
        }

        private boolean isUsingDefaultSSLRepertoire() {
            return this.map.get("com.ibm.ssl.defaultAlias").equals("defaultSSLConfig");
        }

        private boolean defaultRepertoireIsNotAvailable() {
            return this.repertoires.get("defaultSSLConfig") == null;
        }

        private boolean defaultKeyStoreIsNotAvailable() {
            return this.keystores.get("defaultKeyStore") == null;
        }

        private void reportErrorIfDefaultSSLConfigReferencesMissingKeystore(String configuredKeyStore) {
            if (configuredKeyStore != null && this.keystores.get(configuredKeyStore) == null) {
                Tr.warning((TraceComponent)tc, (String)"ssl.defaultSSLConfig.noSuchKeyStore.CWPKI0818E", (Object[])new Object[]{configuredKeyStore});
            }
        }

        private String getDefaultRepetorieKeyStore() {
            if (SSLConfigValidator.this.configAdmin != null) {
                try {
                    Configuration[] configurations = SSLConfigValidator.this.configAdmin.listConfigurations("(service.pid=com.ibm.ws.ssl.repertoire*)");
                    if (configurations != null) {
                        for (Configuration config : configurations) {
                            Dictionary properties = config.getProperties();
                            if (!"defaultSSLConfig".equals(properties.get("id"))) continue;
                            return (String)properties.get("keyStoreRef");
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

