/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.impl.JsDestinationAddressImpl;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class RoutingPathList
extends AbstractList<SIDestinationAddress> {
    private static TraceComponent tc = SibTr.register(RoutingPathList.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final List<String> EMPTY_LIST_OF_STRINGS = new ArrayList<String>();
    private static final List<byte[]> EMPTY_LIST_OF_BYTEARRAYS = new ArrayList<byte[]>();
    private List<SIDestinationAddress> addrList;
    private List<String> jmfNames;
    private List<byte[]> jmfMEs;
    private List<String> jmfBuses;
    private byte[] jmfLocalOnlys;

    RoutingPathList(List<SIDestinationAddress> addrList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RoutingPathList", addrList);
        }
        ArrayList arrayList = this.addrList = addrList != null ? addrList : new ArrayList();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RoutingPathList");
        }
    }

    RoutingPathList(List<String> names, byte[] los, List<byte[]> mes, List<String> buses) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RoutingPathList", (Object)new Object[]{names, los, mes, buses});
        }
        if (names != null) {
            this.jmfNames = names;
            this.jmfMEs = mes;
            this.jmfBuses = buses;
            this.jmfLocalOnlys = los;
        } else {
            this.jmfNames = EMPTY_LIST_OF_STRINGS;
            this.jmfMEs = EMPTY_LIST_OF_BYTEARRAYS;
            this.jmfBuses = EMPTY_LIST_OF_STRINGS;
            this.jmfLocalOnlys = new byte[0];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RoutingPathList");
        }
    }

    List<String> getNames() {
        if (this.addrList == null) {
            return this.jmfNames;
        }
        return new AbstractList<String>(){

            @Override
            public int size() {
                return RoutingPathList.this.addrList.size();
            }

            @Override
            public String get(int index) {
                return ((JsDestinationAddress)RoutingPathList.this.addrList.get(index)).getDestinationName();
            }
        };
    }

    List<byte[]> getMEs() {
        if (this.addrList == null) {
            return this.jmfMEs;
        }
        return new AbstractList<byte[]>(){

            @Override
            public int size() {
                return RoutingPathList.this.addrList.size();
            }

            @Override
            public byte[] get(int index) {
                SIBUuid8 uid = ((JsDestinationAddress)RoutingPathList.this.addrList.get(index)).getME();
                return uid != null ? uid.toByteArray() : null;
            }
        };
    }

    List<String> getBusNames() {
        if (this.addrList == null) {
            return this.jmfBuses;
        }
        return new AbstractList<String>(){

            @Override
            public int size() {
                return RoutingPathList.this.addrList.size();
            }

            @Override
            public String get(int index) {
                return ((JsDestinationAddress)RoutingPathList.this.addrList.get(index)).getBusName();
            }
        };
    }

    byte[] getLocalOnlys() {
        if (this.addrList == null) {
            return this.jmfLocalOnlys;
        }
        int size = this.addrList.size();
        byte[] bitflags = new byte[(size + 7) / 8];
        for (int i = 0; i < size; ++i) {
            RoutingPathList.setFlag(bitflags, i, ((JsDestinationAddress)this.addrList.get(i)).isLocalOnly());
        }
        return bitflags;
    }

    @Override
    public int size() {
        if (this.addrList != null) {
            return this.addrList.size();
        }
        return this.jmfNames.size();
    }

    @Override
    public SIDestinationAddress get(int index) {
        if (this.addrList != null) {
            return this.addrList.get(index);
        }
        String name = this.jmfNames.get(index);
        byte[] me = this.jmfMEs.get(index);
        String bus = this.jmfBuses.get(index);
        boolean localOnly = RoutingPathList.getFlag(this.jmfLocalOnlys, index);
        SIBUuid8 uid = me == null ? null : new SIBUuid8(me);
        return new JsDestinationAddressImpl(name, localOnly, uid, bus);
    }

    @Override
    public SIDestinationAddress set(int index, SIDestinationAddress value) {
        if (this.addrList == null) {
            this.copyLists();
        }
        return this.addrList.set(index, value);
    }

    @Override
    public void add(int index, SIDestinationAddress value) {
        if (this.addrList == null) {
            this.copyLists();
        }
        this.addrList.add(index, value);
    }

    @Override
    public SIDestinationAddress remove(int index) {
        if (this.addrList == null) {
            this.copyLists();
        }
        return this.addrList.remove(index);
    }

    private void copyLists() {
        this.addrList = new ArrayList<SIDestinationAddress>();
        for (int i = 0; i < this.jmfNames.size(); ++i) {
            String name = this.jmfNames.get(i);
            byte[] me = this.jmfMEs.get(i);
            String bus = this.jmfBuses.get(i);
            boolean localOnly = RoutingPathList.getFlag(this.jmfLocalOnlys, i);
            SIBUuid8 uid = me == null ? null : new SIBUuid8(me);
            this.addrList.add(new JsDestinationAddressImpl(name, localOnly, uid, bus));
        }
        this.jmfNames = null;
        this.jmfMEs = null;
        this.jmfBuses = null;
        this.jmfLocalOnlys = null;
    }

    private static boolean getFlag(byte[] bitflags, int index) {
        byte flags = bitflags[index / 8];
        byte bit = (byte)(1 << index % 8);
        return (flags & bit) != 0;
    }

    private static void setFlag(byte[] bitflags, int index, boolean value) {
        byte flags = bitflags[index / 8];
        byte bit = (byte)(1 << index % 8);
        bitflags[index / 8] = flags = value ? (byte)(flags | bit) : (byte)(flags & ~bit);
    }
}

