/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.jmf.JMFEncapsulation;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFList;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSBoxManager;
import com.ibm.ws.sib.mfp.jmf.impl.JSDynamic;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSFixedListImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSMessageData;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.jmf.impl.JSVaryingListImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.mfp.jmf.impl.JSchemaInterpreterImpl;
import com.ibm.ws.sib.mfp.jmf.impl.MessageMap;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class JSMessageImpl
extends JSMessageData
implements JMFMessage {
    private static TraceComponent tc = JmfTr.register(JSMessageImpl.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private JSchema schema;
    private JSField[] fields;
    private JSVariant[] variants;
    private final int firstBoxed;
    private final int accessorLimit;
    private JSBoxManager boxManager;
    private int messageOffset;
    private int tableOffset;
    private int dataOffset;
    private boolean reallocated;
    private int length;
    private JMFSchema[] schemata;
    private MessageMap map;
    private int[] oTable;
    private int[] choiceCache;

    public JSMessageImpl(JSchema schema) {
        super(schema.getFields().length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "<init>", schema);
        }
        this.schema = schema;
        this.fields = schema.getFields();
        if (this.cacheSize > 0) {
            this.cache = new Object[this.cacheSize];
        }
        this.variants = schema.getVariants();
        this.firstBoxed = this.cacheSize + this.variants.length;
        int[][] boxed = schema.getBoxed();
        if (boxed.length > 0) {
            this.boxManager = new JSBoxManager(this, boxed);
        }
        this.accessorLimit = this.firstBoxed + boxed.length;
        this.setMaster();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "<init>");
        }
    }

    public JSMessageImpl(JSchema schema, byte[] contents, int offset, int length, boolean readSchemata) throws JMFMessageCorruptionException {
        this(schema);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "<init>", new Object[]{schema, contents, offset, length, readSchemata});
        }
        this.contents = contents;
        this.messageOffset = offset;
        this.length = length;
        try {
            if (readSchemata) {
                int nSchemata = ArrayUtil.readShort(contents, offset);
                if (nSchemata < 0 || offset + 2 + nSchemata * 8 > contents.length) {
                    JMFMessageCorruptionException jmce = new JMFMessageCorruptionException("Bad schemata length: " + nSchemata + " at offset " + offset);
                    FFDCFilter.processException((Throwable)jmce, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl.<init>", (String)"226", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, contents, 0, contents.length});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        JmfTr.exit(this, tc, "<init>", "JMFMessageCorruptionException");
                    }
                    throw jmce;
                }
                offset += 2;
                this.schemata = new JMFSchema[nSchemata + 1];
                this.schemata[0] = schema;
                for (int i = 0; i < nSchemata; ++i) {
                    long schemaId = ArrayUtil.readLong(contents, offset);
                    offset += 8;
                    this.schemata[i + 1] = JMFRegistry.instance.retrieve(schemaId);
                }
            }
            short len = ArrayUtil.readShort(contents, offset);
            byte[] b = ArrayUtil.readBytes(contents, offset += 2, len);
            BigInteger multiChoice = new BigInteger(b);
            this.map = JSchemaInterpreterImpl.getMessageMap(schema, multiChoice);
            this.tableOffset = offset += len;
            this.oTable = new int[this.map.offsetsNeeded];
            for (int i = 0; i < this.oTable.length; ++i) {
                this.oTable[i] = ArrayUtil.readInt(contents, offset);
                offset += 4;
            }
            this.dataOffset = offset;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl.<init>", (String)"275", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, contents, 0, contents.length});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "<init>", "JMFMessageCorruptionException");
            }
            throw new JMFMessageCorruptionException("Attempt to read beyond end of data buffer", e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "<init>");
        }
    }

    private JSMessageImpl(JSMessageImpl original) {
        super(original.cacheSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "<init>", original);
        }
        this.schema = original.schema;
        this.fields = original.fields;
        this.variants = original.variants;
        this.firstBoxed = original.firstBoxed;
        this.accessorLimit = original.accessorLimit;
        if (original.boxManager != null) {
            this.boxManager = new JSBoxManager(this, this.schema.getBoxed());
        }
        this.schemata = original.schemata;
        this.messageOffset = original.messageOffset;
        this.tableOffset = original.tableOffset;
        this.dataOffset = original.dataOffset;
        this.reallocated = original.reallocated;
        this.length = original.length;
        this.map = original.map;
        if (original.oTable != null) {
            this.oTable = (int[])original.oTable.clone();
        }
        if (original.choiceCache != null) {
            this.choiceCache = (int[])original.choiceCache.clone();
        }
        if (this.boxManager != null) {
            this.boxManager.reset();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "<init>");
        }
    }

    @Override
    int getAbsoluteOffset(int index) throws JMFUninitializedAccessException {
        MessageMap.Remap remap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getAbsoluteOffset", new Object[]{index});
        }
        if ((remap = this.map.fields[index]) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "getAbsoluteOffset", "JMFUninitializedAccessException");
            }
            throw new JMFUninitializedAccessException(this.schema.getPathName(this.fields[index]) + " Schema: " + this.schema.getName());
        }
        int varOffset = remap.offsetIndex;
        varOffset = varOffset < 0 ? 0 : this.oTable[varOffset];
        int result = this.dataOffset + varOffset + remap.fixedIncr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getAbsoluteOffset", result);
        }
        return result;
    }

    @Override
    JSField getFieldDef(int accessor, boolean mustBePresent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getFieldDef", new Object[]{accessor, mustBePresent});
        }
        if (mustBePresent && (this.map == null || this.map.fields[accessor] == null)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "getFieldDef", null);
            }
            return null;
        }
        JSField result = this.fields[accessor];
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getFieldDef", result);
        }
        return result;
    }

    @Override
    boolean assembledForField(int index) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "assembledForField", new Object[]{index});
        }
        if (this.contents != null) {
            if (this.map.fields[index] != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "assembledForField", Boolean.TRUE);
                }
                return true;
            }
            this.unassemble();
        } else {
            if (this.choiceCache == null) {
                this.makeChoiceCache();
            }
            this.map = null;
        }
        if (this.setDominatingCases(this.fields[index])) {
            this.unsetCachesByCases();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "assembledForField", Boolean.FALSE);
        }
        return false;
    }

    private void unsetCachesByCases() throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "unsetCachesByCases");
        }
        if (this.sharedCache) {
            this.copyCache();
        }
        for (i = 0; i < this.choiceCache.length; ++i) {
            if (this.choiceCache[i] == -1 || this.consistentChoice(i)) continue;
            this.choiceCache[i] = -1;
        }
        if (this.cache != null) {
            for (i = 0; i < this.cache.length; ++i) {
                if (this.cache[i] == null || this.consistentCache(i)) continue;
                this.cache[i] = null;
                if (!(this.fields[i] instanceof JSVariant)) continue;
                this.boxManager.cleanupBoxedCache(i);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "unsetCachesByCases");
        }
    }

    boolean consistentChoice(int varIndex) {
        JSType field;
        JSVariant parent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "consistentChoice", new Object[]{varIndex});
        }
        if ((parent = (JSVariant)(field = JSMessageImpl.findDominatingCase(this.variants[varIndex])).getParent()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "consistentChoice", Boolean.TRUE);
            }
            return true;
        }
        int domIndex = parent.getIndex();
        if (this.choiceCache[domIndex] != field.getSiblingPosition()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "consistentChoice", Boolean.FALSE);
            }
            return false;
        }
        if (!this.consistentChoice(domIndex)) {
            this.choiceCache[domIndex] = -1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "consistentChoice", Boolean.FALSE);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "consistentChoice", Boolean.TRUE);
        }
        return true;
    }

    static JSType findDominatingCase(JSType field) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(tc, "findDominatingCase", field);
        }
        JSType parent = (JSType)field.getParent();
        while (parent != null && !(parent instanceof JSVariant)) {
            field = parent;
            parent = (JSType)field.getParent();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(tc, "findDominatingCase", (Object)field.getFeatureName());
        }
        return field;
    }

    private boolean consistentCache(int accessor) {
        JSType field;
        JSVariant parent;
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "consistentCache", new Object[]{accessor});
        }
        boolean bl = result = (parent = (JSVariant)(field = JSMessageImpl.findDominatingCase(this.fields[accessor])).getParent()) == null || this.choiceCache[parent.getIndex()] == field.getSiblingPosition();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "consistentCache", result);
        }
        return result;
    }

    @Override
    boolean isFieldVarying(int index) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "isFieldVarying", new Object[]{index});
        }
        boolean result = this.map.fields[index].varying;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "isFieldVarying", result);
        }
        return result;
    }

    @Override
    public JMFSchema getJMFSchema() {
        return this.schema;
    }

    @Override
    public int getModelID() {
        return 0;
    }

    @Override
    public JMFSchema getEncodingSchema() {
        return this.schema;
    }

    @Override
    public short getJMFEncodingVersion() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int originalFrame() {
        int result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "originalFrame");
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            result = this.contents == null || this.reallocated ? -1 : this.length;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "originalFrame", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMFSchema[] getSchemata() throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        JMFSchema[] result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getSchemata");
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.schemata == null) {
                HashSet<JMFSchema> accum = new HashSet<JMFSchema>();
                this.getSchemata2(accum, false);
                this.schemata = new JMFSchema[1 + accum.size()];
                this.schemata[0] = this.schema;
                Iterator iter = accum.iterator();
                for (int i = 1; i < this.schemata.length; ++i) {
                    this.schemata[i] = (JMFSchema)iter.next();
                }
            }
            result = this.schemata;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getSchemata", result);
        }
        return result;
    }

    private void getSchemata2(Set<JMFSchema> accum, boolean addThis) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getSchemata2", new Object[]{accum, addThis});
        }
        if (addThis) {
            accum.add(this.schema);
        }
        if (this.map != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.map.fields[i] == null) continue;
                JSField field = this.fields[i];
                if (field instanceof JSDynamic) {
                    this.getSchemata3(accum, true, this.getInternal(i));
                    continue;
                }
                if (!(field instanceof JSVariant)) continue;
                this.getSchemata3(accum, false, this.getInternal(i));
            }
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.cache[i] == null) continue;
                if (this.fields[i] instanceof JSDynamic) {
                    this.getSchemata3(accum, true, this.cache[i]);
                    continue;
                }
                if (!(this.fields[i] instanceof JSVariant)) continue;
                this.getSchemata3(accum, false, this.cache[i]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getSchemata2");
        }
    }

    private void getSchemata3(Set<JMFSchema> accum, boolean addThis, Object obj) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getSchemata3", new Object[]{accum, addThis, obj});
        }
        if (obj != null) {
            if (obj instanceof JMFList) {
                List list = (List)obj;
                for (int i = 0; i < list.size(); ++i) {
                    this.getSchemata3(accum, addThis, list.get(i));
                }
            } else if (obj instanceof JSMessageImpl) {
                ((JSMessageImpl)obj).getSchemata2(accum, addThis);
            } else {
                ((JMFEncapsulation)obj).getSchemata(accum);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getSchemata3");
        }
    }

    @Override
    void invalidateSchemaCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "invalidateSchemaCache");
        }
        if (this.isMaster()) {
            this.schemata = null;
        } else {
            this.getParent().invalidateSchemaCache();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "invalidateSchemaCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEncodedLength() throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getEncodedLength");
        }
        try {
            int ans;
            Object object = this.getMessageLockArtefact();
            synchronized (object) {
                JMFException e;
                byte[] bytes;
                if (this.contents != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        JmfTr.exit(this, tc, "getEncodedLength", this.length);
                    }
                    return this.length;
                }
                if (this.map == null) {
                    this.map = JSchemaInterpreterImpl.getMessageMap(this.schema, this.choiceCache);
                    if (this.map == null) {
                        JMFException e2 = new JMFException("Map was null after getMessageMap.");
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl.getEncodedLength", (String)"770", (Object)this);
                    }
                }
                ans = this.map.offsetsNeeded * 4;
                for (int i = 0; i < this.fields.length; ++i) {
                    if (this.map.fields[i] == null) continue;
                    ans += this.getLength(this.cache[i], this.fields[i]);
                }
                BigInteger multiC = this.map.multiChoice;
                if (multiC == null) {
                    JMFException e3 = new JMFException("multiChoice was null.");
                    FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl.getEncodedLength", (String)"795", (Object)this);
                }
                if ((bytes = multiC.toByteArray()) == null) {
                    e = new JMFException("bytes was null.");
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl.getEncodedLength", (String)"803", (Object)this);
                }
                ans += bytes.length + 2;
                if (this.isMaster()) {
                    ans += 2;
                    if (this.schemata == null) {
                        this.getSchemata();
                    }
                    if (this.schemata == null) {
                        e = new JMFException("schemata was null after getSchemata.");
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl.getEncodedLength", (String)"819", (Object)this);
                    }
                    ans += 8 * (this.schemata.length - 1);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "getEncodedLength", ans);
            }
            return ans;
        }
        catch (NullPointerException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl.getEncodedLength", (String)"830", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "getEncodedLength", e);
            }
            throw e;
        }
    }

    private int getLength(Object val, JSField fieldDef) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getLength", new Object[]{val, fieldDef});
        }
        if (val == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "getLength", "JMFUninitializedAccessException");
            }
            throw new JMFUninitializedAccessException(this.schema.getPathName(fieldDef) + " Schema: " + this.schema.getName());
        }
        if (val == nullIndicator) {
            int result = fieldDef.getEncodedValueLength(null, this.indirect, this.master);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "getLength", result);
            }
            return result;
        }
        int result = fieldDef.getEncodedValueLength(val, this.indirect, this.master);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getLength", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int toByteArray(byte[] buffer, int offset, int length) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        int result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "toByteArray", new Object[]{buffer, offset, length});
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.contents != null && length < this.length) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    JmfTr.exit(this, tc, "toByteArray", "IllegalStateException");
                }
                throw new IllegalStateException();
            }
            result = this.toByteArray(buffer, offset);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "toByteArray", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int toByteArray(byte[] buffer, int offset) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        int result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "toByteArray", new Object[]{buffer, offset});
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            int route = 0;
            int probe = 0;
            try {
                if (this.contents != null) {
                    route |= 4;
                    probe = 102;
                    System.arraycopy(this.contents, this.messageOffset, buffer, offset, this.length);
                    result = this.length;
                } else {
                    route |= 8;
                    probe = 200;
                    int messageOffset = offset;
                    if (this.isMaster()) {
                        route |= 0x10;
                        probe = 201;
                        if (this.schemata == null) {
                            route |= 0x20;
                            this.getSchemata();
                        }
                        probe = 202;
                        ArrayUtil.writeShort(buffer, offset, (short)(this.schemata.length - 1));
                        offset += 2;
                        probe = 203;
                        for (int i = 1; i < this.schemata.length; ++i) {
                            route |= 0x40;
                            probe = 204;
                            ArrayUtil.writeLong(buffer, offset, this.schemata[i].getID());
                            offset += 8;
                        }
                        probe = 205;
                    }
                    probe = 300;
                    byte[] b = this.map.multiChoice.toByteArray();
                    probe = 301;
                    ArrayUtil.writeShort(buffer, offset, (short)b.length);
                    probe = 302;
                    ArrayUtil.writeBytes(buffer, offset += 2, b);
                    probe = 303;
                    int tableOffset = offset += b.length;
                    probe = 305;
                    int dataOffset = offset += this.map.offsetsNeeded * 4;
                    int[] oTable = new int[this.map.offsetsNeeded];
                    probe = 306;
                    int oTableIndex = 0;
                    for (int i = 0; i < this.fields.length; ++i) {
                        route |= 0x80;
                        probe = 400;
                        if (this.map.fields[i] == null) continue;
                        route |= 0x100;
                        probe = 401;
                        Object val = this.cache[i];
                        probe = 402;
                        if (val == null) {
                            probe = 403;
                            JMFUninitializedAccessException e = new JMFUninitializedAccessException(this.schema.getPathName(this.fields[i]) + " Schema: " + this.schema.getName());
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                JmfTr.exit(this, tc, "toByteArray", e);
                            }
                            throw e;
                        }
                        offset = this.writeObject(val, this.fields[i], buffer, offset);
                        probe = 404;
                        if (!this.map.fields[i].varying || oTableIndex >= oTable.length) continue;
                        route |= 0x200;
                        probe = 405;
                        oTable[oTableIndex++] = offset - dataOffset;
                    }
                    probe = 500;
                    int toff = tableOffset;
                    for (int i = 0; i < oTable.length; ++i) {
                        route |= 0x400;
                        probe = 501;
                        ArrayUtil.writeInt(buffer, toff, oTable[i]);
                        toff += 4;
                    }
                    probe = 502;
                    this.contents = buffer;
                    this.messageOffset = messageOffset;
                    this.tableOffset = tableOffset;
                    this.dataOffset = dataOffset;
                    this.length = offset - messageOffset;
                    this.oTable = oTable;
                    this.choiceCache = null;
                    this.sharedContents = false;
                    probe = 503;
                    if (this.isMaster()) {
                        route |= 0x800;
                        this.reallocated(buffer, -1);
                    }
                    result = offset - messageOffset;
                }
            }
            catch (NullPointerException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl.toByteArray", (String)"1104", (Object[])new Object[]{probe, route});
                String msgInsert = "NullPointerException in JSMessageImpl: Probe = " + probe + " route = " + route;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.info((TraceComponent)tc, (String)"TEMPORARY_CWSIF9999", (Object)new Object[]{msgInsert});
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "toByteArray", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toByteArray(int length) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "toByteArray", new Object[]{length});
        }
        byte[] buffer = null;
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.contents != null) {
                if (length < this.length) {
                    IllegalStateException e = new IllegalStateException();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        JmfTr.exit(this, tc, "toByteArray", e);
                    }
                    throw e;
                }
                if (this.messageOffset != 0) {
                    this.reallocate(0);
                }
                this.sharedContents = true;
                buffer = this.contents;
            } else {
                buffer = new byte[length];
                this.toByteArray(buffer, 0, length);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "toByteArray", buffer);
        }
        return buffer;
    }

    private int writeObject(Object val, JSField fieldDef, byte[] buffer, int offset) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "writeObject", new Object[]{val, fieldDef, buffer, offset});
        }
        int result = val == nullIndicator ? fieldDef.encodeValue(buffer, offset, null, this.indirect, this.master) : fieldDef.encodeValue(buffer, offset, val, this.indirect, this.master);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "writeObject", result);
        }
        return result;
    }

    @Override
    public JMFNativePart newNativePart(JMFSchema schema) {
        return new JSMessageImpl((JSchema)schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        Object result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getValue", new Object[]{accessor});
        }
        if (accessor < this.cacheSize) {
            result = super.getValue(accessor);
        } else if (accessor < this.firstBoxed) {
            result = this.getCase(accessor - this.cacheSize);
        } else if (accessor < this.accessorLimit) {
            Object object = this.getMessageLockArtefact();
            synchronized (object) {
                result = this.boxManager.getBoxedlValue(accessor - this.firstBoxed);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "getValue", "IndexOutOfBoundsException");
            }
            throw new IndexOutOfBoundsException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getValue", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(int accessor, Object val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "setValue", new Object[]{accessor, val});
        }
        if (accessor < this.cacheSize) {
            super.setValue(accessor, val);
        } else if (accessor < this.firstBoxed) {
            this.setCase(accessor - this.cacheSize, ((Number)val).intValue());
        } else if (accessor < this.accessorLimit) {
            Object object = this.getMessageLockArtefact();
            synchronized (object) {
                this.boxManager.setBoxedValue(accessor - this.firstBoxed, val);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "setValue", "IndexOutOfBoundsException");
            }
            throw new IndexOutOfBoundsException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "setValue");
        }
    }

    @Override
    public int getInt(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getInt", new Object[]{accessor});
        }
        int result = accessor >= this.cacheSize && accessor < this.firstBoxed ? this.getCase(accessor - this.cacheSize) : super.getInt(accessor);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getInt", result);
        }
        return result;
    }

    @Override
    public void setInt(int accessor, int val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "setInt", new Object[]{accessor, val});
        }
        if (accessor >= this.cacheSize && accessor < this.firstBoxed) {
            this.setCase(accessor - this.cacheSize, val);
        } else {
            super.setInt(accessor, val);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "setInt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPresent(int accessor) {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "isPresent", new Object[]{accessor});
        }
        if (accessor < this.cacheSize) {
            result = super.isPresent(accessor);
        } else if (accessor < this.firstBoxed) {
            result = this.getCase(accessor - this.cacheSize) > -1;
        } else if (accessor < this.accessorLimit) {
            Object object = this.getMessageLockArtefact();
            synchronized (object) {
                result = super.isPresent(this.boxManager.getBoxAccessor(accessor - this.firstBoxed));
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "isPresent", "IndexOutOfBoundsException");
            }
            throw new IndexOutOfBoundsException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "isPresent", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMFList createBoxList(int accessor, Object val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        JSVaryingListImpl ans;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "createBoxList", new Object[]{accessor, val});
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            JSVariant theVariant = (JSVariant)this.fields[accessor];
            ans = new JSVaryingListImpl(theVariant, val, theVariant.getIndirection(), this);
            this.setValue(accessor, ans);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "createBoxList", ans);
        }
        return ans;
    }

    @Override
    int reallocate(int offset) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "reallocate", new Object[]{offset});
        }
        byte[] oldContents = this.contents;
        int oldMessageOffset = this.messageOffset;
        this.contents = new byte[this.length];
        System.arraycopy(oldContents, this.messageOffset, this.contents, 0, this.length);
        this.tableOffset -= this.messageOffset;
        this.dataOffset -= this.messageOffset;
        this.messageOffset = 0;
        this.reallocated = true;
        this.reallocated(this.contents, -1);
        int result = offset - oldMessageOffset;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "reallocate", result);
        }
        return result;
    }

    @Override
    int reallocate(int index, int offset, int oldLen, int newLen) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "reallocate", new Object[]{index, offset, oldLen, newLen});
        }
        int oInx = this.map.fields[index].offsetIndex + 1;
        while (oInx < this.oTable.length) {
            int n = oInx++;
            this.oTable[n] = this.oTable[n] + (newLen - oldLen);
        }
        int balance = this.messageOffset + this.length - offset - 4 - oldLen;
        byte[] oldcontents = this.contents;
        int oldMessageOffset = this.messageOffset;
        int oldDataOffset = this.dataOffset;
        int oldTableOffset = this.tableOffset;
        this.length += newLen - oldLen;
        this.contents = new byte[this.length];
        this.messageOffset = 0;
        this.tableOffset = this.dataOffset = oldTableOffset - oldMessageOffset;
        System.arraycopy(oldcontents, oldMessageOffset, this.contents, 0, this.tableOffset);
        for (int i = 0; i < this.oTable.length; ++i) {
            ArrayUtil.writeInt(this.contents, this.dataOffset, this.oTable[i]);
            this.dataOffset += 4;
        }
        System.arraycopy(oldcontents, oldDataOffset, this.contents, this.dataOffset, offset - oldDataOffset);
        if (balance > 0) {
            System.arraycopy(oldcontents, offset + 4 + oldLen, this.contents, this.length - balance, balance);
        }
        this.reallocated = true;
        this.sharedContents = false;
        this.reallocated(this.contents, -1);
        int result = offset - oldMessageOffset;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "reallocate", result);
        }
        return result;
    }

    @Override
    void reallocated(byte[] newContents, int newOffset) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "reallocated", new Object[]{newContents, newOffset});
        }
        if (newOffset != -1 && this.contents != null) {
            int oldOffset = this.messageOffset;
            this.contents = newContents;
            this.messageOffset = newOffset + 16;
            this.tableOffset = this.messageOffset + this.tableOffset - oldOffset;
            this.dataOffset = this.messageOffset + this.dataOffset - oldOffset;
            this.reallocated = true;
            this.sharedContents = false;
        }
        if (this.cache != null) {
            for (int i = 0; i < this.cache.length; ++i) {
                try {
                    Object entry = this.cache[i];
                    if (entry == null || !(entry instanceof JSMessageData)) continue;
                    ((JSMessageData)entry).reallocated(newContents, this.getAbsoluteOffset(i));
                    continue;
                }
                catch (JMFUninitializedAccessException jMFUninitializedAccessException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "reallocated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCase(int varIndex, int choice) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "setCase", new Object[]{varIndex, choice});
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.contents != null) {
                if (this.map.choiceCodes[varIndex] == choice) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        JmfTr.exit(this, tc, "setCase");
                    }
                    return;
                }
                this.unassemble();
            } else {
                if (this.choiceCache == null) {
                    this.makeChoiceCache();
                }
                this.map = null;
            }
            if (this.setCaseChain(varIndex, choice)) {
                this.unsetCachesByCases();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "setCase");
        }
    }

    private boolean setCaseChain(int varIndex, int choiceIndex) {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "setCaseChain", new Object[]{varIndex, choiceIndex});
        }
        if (this.choiceCache[varIndex] == choiceIndex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "setCaseChain", Boolean.FALSE);
            }
            return false;
        }
        int prevChoiceIndex = this.choiceCache[varIndex];
        this.choiceCache[varIndex] = choiceIndex;
        boolean dominated = this.setDominatingCases(this.variants[varIndex]);
        boolean bl = result = dominated || prevChoiceIndex != -1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "setCaseChain", result);
        }
        return result;
    }

    private boolean setDominatingCases(JSType field) {
        JSVariant parent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "setDominatingCases", new Object[]{field});
        }
        if ((parent = (JSVariant)(field = JSMessageImpl.findDominatingCase(field)).getParent()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "setDominatingCases", Boolean.FALSE);
            }
            return false;
        }
        boolean result = this.setCaseChain(parent.getIndex(), field.getSiblingPosition());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "setDominatingCases", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unassemble() throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "unassemble");
        }
        if (this.contents == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "unassemble", "contents is null");
            }
            return;
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            super.unassemble();
            this.oTable = null;
            this.makeChoiceCache();
            this.map = null;
            this.invalidateSchemaCache();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "unassemble");
        }
    }

    private void makeChoiceCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "makeChoiceCache");
        }
        this.choiceCache = new int[this.variants.length];
        if (this.map == null) {
            for (int i = 0; i < this.choiceCache.length; ++i) {
                this.choiceCache[i] = -1;
            }
        } else {
            for (int i = 0; i < this.choiceCache.length; ++i) {
                this.choiceCache[i] = this.map.choiceCodes[i];
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "makeChoiceCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCase(int varIndex) {
        int result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getCase", new Object[]{varIndex});
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            result = this.map != null ? this.map.choiceCodes[varIndex] : (this.choiceCache == null ? -1 : this.choiceCache[varIndex]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getCase", result);
        }
        return result;
    }

    @Override
    public JMFMessage copy() {
        return (JSMessageImpl)this.getCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JSMessageData getCopy() {
        JSMessageImpl copy;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getCopy");
        }
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            copy = new JSMessageImpl(this);
            copy.lazyCopy(this);
            copy.setMaster();
            if (this.boxManager != null) {
                this.boxManager.reset();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getCopy", copy);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSlice getAssembledContent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "getAssembledContent");
        }
        DataSlice result = null;
        Object object = this.getMessageLockArtefact();
        synchronized (object) {
            if (this.contents != null) {
                this.sharedContents = true;
                result = new DataSlice(this.contents, this.messageOffset, this.length);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "getAssembledContent", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEMPTYlist(int accessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEMPTYlist", (Object)accessor);
        }
        boolean isEMPTY = false;
        if (accessor < this.cacheSize) {
            this.checkIndex(accessor);
            Object object = this.getMessageLockArtefact();
            synchronized (object) {
                Object val;
                if (this.cache != null && ((val = this.cache[accessor]) == JSVaryingListImpl.EMPTY_UNBOXED_VARYINGLIST || val == JSFixedListImpl.EMPTY_FIXEDLIST)) {
                    isEMPTY = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isEMPTYlist", (Object)isEMPTY);
        }
        return isEMPTY;
    }
}

