/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.urbridge.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.xpath.TokenMgrError;
import com.ibm.ws.security.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.security.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.security.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.wsspi.security.wim.exception.PropertyNotDefinedException;
import com.ibm.wsspi.security.wim.exception.SearchControlException;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class URBridgeXPathHelper {
    private static final TraceComponent tc = Tr.register(URBridgeXPathHelper.class);
    private XPathNode node = null;
    private List<String> entityTypes = null;
    static final long serialVersionUID = 7057145024572480385L;

    public URBridgeXPathHelper(String searchExpr) throws WIMException {
        this.parseSearchExpression(searchExpr);
    }

    public void parseSearchExpression(String searchExpr) throws WIMException {
        try {
            Iterator propNodesItr;
            if (searchExpr == null || searchExpr.trim().length() == 0) {
                return;
            }
            WIMXPathInterpreter parser = new WIMXPathInterpreter(new StringReader(searchExpr));
            this.node = parser.parse(null);
            this.entityTypes = parser.getEntityTypes();
            HashMap propNodes = new HashMap();
            if (this.node != null && (propNodesItr = this.node.getPropertyNodes(propNodes)).hasNext()) {
                PropertyNode propNode = (PropertyNode)propNodesItr.next();
                this.node = propNode;
                propNode.setName(this.removeNamespace(propNode.getName()));
                boolean foundProperty = false;
                String propName = propNode.getName();
                Iterator<String> iter = this.entityTypes.iterator();
                while (iter.hasNext() && !foundProperty) {
                    String entityType = iter.next();
                    if (entityType.equalsIgnoreCase("LoginAccount")) {
                        entityType = "PersonAccount";
                    }
                    foundProperty = Entity.getPropertyNames((String)entityType).contains(propName);
                }
                if (!foundProperty) {
                    throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED_FOR_ENTITY", Tr.formatMessage((TraceComponent)tc, (String)"PROPERTY_NOT_DEFINED_FOR_ENTITY", (Object[])WIMMessageHelper.generateMsgParms((Object)propName, this.entityTypes)));
                }
            }
        }
        catch (Exception parser) {
            FFDCFilter.processException((Throwable)parser, (String)"com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeXPathHelper", (String)"108", (Object)this, (Object[])new Object[]{searchExpr});
            throw new WIMApplicationException("MALFORMED_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"MALFORMED_SEARCH_EXPRESSION", (Object[])WIMMessageHelper.generateMsgParms((Object)searchExpr)));
        }
        catch (TokenMgrError e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeXPathHelper", (String)"111", (Object)this, (Object[])new Object[]{searchExpr});
            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_SEARCH_EXPRESSION", (Object[])WIMMessageHelper.generateMsgParms((Object)searchExpr)));
        }
    }

    public String removeNamespace(String entityType) {
        String str = entityType.replace('\'', ' ').trim();
        int index = str.indexOf(":");
        if (index > 0) {
            str = str.substring(index + 1);
        }
        return str;
    }

    public String getExpression() throws Exception {
        if (this.node != null) {
            switch (this.node.getNodeType()) {
                case 0: {
                    return this.getExpression((PropertyNode)this.node);
                }
            }
        }
        return "";
    }

    private String getExpression(PropertyNode propNode) throws Exception {
        String pattern = (String)propNode.getValue();
        return pattern;
    }

    public List<String> getEntityTypes() {
        return this.entityTypes;
    }
}

