/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyTaskCallback;
import com.ibm.ws.threading.PolicyTaskFuture;
import com.ibm.ws.threading.StartTimeoutException;
import com.ibm.ws.threading.internal.PolicyExecutorImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PolicyTaskFutureImpl<T>
implements PolicyTaskFuture<T> {
    private static final TraceComponent tc = Tr.register(PolicyTaskFutureImpl.class, (String)"concurrencyPolicy", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    static final int PRESUBMIT = 0;
    static final int SUBMITTED = 1;
    static final int RUNNING = 2;
    static final int ABORTED = 3;
    static final int CANCELING = 4;
    static final int CANCELED = 5;
    static final int FAILED = 6;
    static final int SUCCESSFUL = 7;
    private static final int TIMEOUT = -1;
    private final Callable<T> callable;
    final PolicyTaskCallback callback;
    final PolicyExecutorImpl executor;
    private final InvokeAnyLatch latch;
    final long nsAcceptBegin = System.nanoTime();
    volatile long nsAcceptEnd = this.nsAcceptBegin - 1L;
    volatile long nsQueueEnd = this.nsAcceptBegin - 2L;
    volatile long nsRunEnd = this.nsAcceptBegin - 3L;
    final long nsStartBy;
    private final T predefinedResult;
    private final Runnable runnable;
    private final State state = new State();
    final Object task;
    private volatile Thread thread;
    private final AtomicReference<Object> result = new AtomicReference<State>(this.state);
    static final long serialVersionUID = 4364359289512141919L;

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={RejectedExecutionException.class})
    PolicyTaskFutureImpl(PolicyExecutorImpl executor, Callable<T> task, PolicyTaskCallback callback, long startTimeoutNS) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.callable = executor.globalExecutor.wrap(task);
        this.callback = callback;
        this.executor = executor;
        this.latch = null;
        this.nsStartBy = this.nsAcceptBegin + startTimeoutNS;
        this.predefinedResult = null;
        this.runnable = null;
        this.task = task;
        if (callback != null) {
            try {
                callback.onSubmit(task, this, 0);
            }
            catch (Error error) {
                void x;
                FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.threading.internal.PolicyTaskFutureImpl", (String)"307", (Object)this, (Object[])new Object[]{executor, task, callback, startTimeoutNS});
                this.abort(false, (Throwable)x);
                throw x;
            }
            catch (RejectedExecutionException x) {
                this.abort(false, x);
                throw x;
            }
            catch (RuntimeException x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.threading.internal.PolicyTaskFutureImpl", (String)"313", (Object)this, (Object[])new Object[]{executor, task, callback, startTimeoutNS});
                this.abort(false, x);
                throw x;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={RejectedExecutionException.class})
    PolicyTaskFutureImpl(PolicyExecutorImpl executor, Callable<T> task, PolicyTaskCallback callback, long startTimeoutNS, InvokeAnyLatch latch) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.callable = executor.globalExecutor.wrap(task);
        this.callback = callback;
        this.executor = executor;
        this.latch = latch;
        this.nsStartBy = this.nsAcceptBegin + startTimeoutNS;
        this.predefinedResult = null;
        this.runnable = null;
        this.task = task;
        if (callback != null) {
            try {
                callback.onSubmit(task, this, latch.getCount());
            }
            catch (Error error) {
                void x;
                FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.threading.internal.PolicyTaskFutureImpl", (String)"335", (Object)this, (Object[])new Object[]{executor, task, callback, startTimeoutNS, latch});
                this.abort(false, (Throwable)x);
                throw x;
            }
            catch (RejectedExecutionException x) {
                this.abort(false, x);
                throw x;
            }
            catch (RuntimeException x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.threading.internal.PolicyTaskFutureImpl", (String)"341", (Object)this, (Object[])new Object[]{executor, task, callback, startTimeoutNS, latch});
                this.abort(false, x);
                throw x;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={RejectedExecutionException.class})
    PolicyTaskFutureImpl(PolicyExecutorImpl executor, Runnable task, T predefinedResult, PolicyTaskCallback callback, long startTimeoutNS) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.callable = null;
        this.callback = callback;
        this.executor = executor;
        this.latch = null;
        this.nsStartBy = this.nsAcceptBegin + startTimeoutNS;
        this.predefinedResult = predefinedResult;
        this.runnable = executor.globalExecutor.wrap(task);
        this.task = task;
        if (callback != null) {
            try {
                callback.onSubmit(task, this, 0);
            }
            catch (Error error) {
                void x;
                FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.threading.internal.PolicyTaskFutureImpl", (String)"363", (Object)this, (Object[])new Object[]{executor, task, predefinedResult, callback, startTimeoutNS});
                this.abort(false, (Throwable)x);
                throw x;
            }
            catch (RejectedExecutionException x) {
                this.abort(false, x);
                throw x;
            }
            catch (RuntimeException x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.threading.internal.PolicyTaskFutureImpl", (String)"369", (Object)this, (Object[])new Object[]{executor, task, predefinedResult, callback, startTimeoutNS});
                this.abort(false, x);
                throw x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean abort(boolean removeFromQueue, Throwable cause) {
        boolean aborted;
        if (removeFromQueue && this.executor.queue.remove(this)) {
            this.executor.maxQueueSizeConstraint.release();
        }
        if (this.nsAcceptEnd == this.nsAcceptBegin - 1L) {
            this.nsQueueEnd = this.nsAcceptEnd = System.nanoTime();
            this.nsRunEnd = this.nsAcceptEnd;
        }
        boolean bl = aborted = this.result.compareAndSet(this.state, cause) && this.state.releaseShared(3);
        if (aborted) {
            try {
                if (this.nsQueueEnd == this.nsAcceptBegin - 2L) {
                    this.nsRunEnd = this.nsQueueEnd = System.nanoTime();
                }
                if (this.callback != null) {
                    this.callback.onEnd(this.task, this, null, true, 0, cause);
                }
            }
            finally {
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }
        return aborted;
    }

    @Trivial
    final void accept(boolean runOnSubmitter) {
        long time;
        this.nsAcceptEnd = time = System.nanoTime();
        if (runOnSubmitter) {
            this.nsQueueEnd = time;
        }
        this.state.setSubmitted();
    }

    int await() throws InterruptedException {
        int s = this.state.get();
        if (s == 1 || s == 2 && this.thread != Thread.currentThread()) {
            if (s == 2 || this.nsStartBy == this.nsAcceptBegin - 1L) {
                this.state.acquireSharedInterruptibly(1);
                s = this.state.get();
            } else {
                long nsGetBegin = System.nanoTime();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("await start timeout for " + (this.nsStartBy - nsGetBegin) + "ns"), (Object[])new Object[0]);
                }
                this.state.tryAcquireSharedNanos(1, this.nsStartBy - nsGetBegin);
                s = this.state.get();
                if (s == 1) {
                    this.abort(true, new StartTimeoutException(this.getIdentifier(), this.getTaskName(), System.nanoTime() - this.nsAcceptBegin, this.nsStartBy - this.nsAcceptBegin));
                    s = this.state.get();
                }
                if (s == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"await completion", (Object[])new Object[0]);
                    }
                    this.state.acquireSharedInterruptibly(1);
                    s = this.state.get();
                }
            }
        }
        return s;
    }

    int await(long time, TimeUnit unit) throws InterruptedException {
        int s = this.state.get();
        if (s == 1 || s == 2 && this.thread != Thread.currentThread()) {
            long nsGetBegin;
            long maxWaitNS = unit.toNanos(time);
            if (s == 2 || this.nsStartBy == this.nsAcceptBegin - 1L || this.nsStartBy - (nsGetBegin = System.nanoTime()) > maxWaitNS) {
                s = this.state.tryAcquireSharedNanos(1, maxWaitNS) ? this.state.get() : -1;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("await start timeout for " + (this.nsStartBy - nsGetBegin) + "ns"), (Object[])new Object[0]);
                }
                this.state.tryAcquireSharedNanos(1, this.nsStartBy - nsGetBegin);
                s = this.state.get();
                if (s == 1) {
                    this.abort(true, new StartTimeoutException(this.getIdentifier(), this.getTaskName(), System.nanoTime() - this.nsAcceptBegin, this.nsStartBy - this.nsAcceptBegin));
                    s = this.state.get();
                }
                if (s == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"await remainder of timeout", (Object[])new Object[0]);
                    }
                    s = this.state.tryAcquireSharedNanos(1, maxWaitNS - (System.nanoTime() - nsGetBegin)) ? this.state.get() : -1;
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean cancel(boolean interruptIfRunning) {
        if (this.nsStartBy != this.nsAcceptBegin - 1L && State.access$200(this.state) < 2 && System.nanoTime() - this.nsStartBy > 0L) {
            this.abort(true, new StartTimeoutException(this.getIdentifier(), this.getTaskName(), System.nanoTime() - this.nsAcceptBegin, this.nsStartBy - this.nsAcceptBegin));
        }
        if (this.result.compareAndSet(this.state, 5)) {
            try {
                if (this.executor.queue.remove(this)) {
                    this.nsRunEnd = this.nsQueueEnd = System.nanoTime();
                    this.state.releaseShared(5);
                    this.executor.maxQueueSizeConstraint.release();
                    if (TraceComponent.isAnyTracingEnabled() && PolicyTaskFutureImpl.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)PolicyTaskFutureImpl.tc, (String)"canceled from queue", (Object[])new Object[0]);
                    }
                    if (this.callback != null) {
                        this.callback.onCancel(this.task, this, false);
                    }
                } else if (State.access$200(this.state) == 0) {
                    this.nsQueueEnd = this.nsAcceptEnd = System.nanoTime();
                    this.nsRunEnd = this.nsAcceptEnd;
                    this.state.releaseShared(5);
                    if (TraceComponent.isAnyTracingEnabled() && PolicyTaskFutureImpl.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)PolicyTaskFutureImpl.tc, (String)"canceled during pre-submit", (Object[])new Object[0]);
                    }
                    if (this.callback != null) {
                        this.callback.onCancel(this.task, this, false);
                    }
                } else if (interruptIfRunning) {
                    this.state.releaseShared(4);
                    t = this.thread;
                    try {
                        if (t == null) ** GOTO lbl47
                        if (TraceComponent.isAnyTracingEnabled() && PolicyTaskFutureImpl.tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)PolicyTaskFutureImpl.tc, (String)("interrupting " + t), (Object[])new Object[0]);
                        }
                        AccessController.doPrivileged(new InterruptAction(t));
                    }
                    finally {
                        this.state.releaseShared(5);
                        if (this.callback != null) {
                            this.callback.onCancel(this.task, this, true);
                        }
                    }
                } else {
                    this.state.releaseShared(5);
                    if (this.callback != null) {
                        this.callback.onCancel(this.task, this, true);
                    }
                }
lbl47:
                // 7 sources

                var2_3 = true;
                return var2_3;
            }
            finally {
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }
        while (this.result.get() == this.state) {
            Thread.yield();
        }
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        switch (this.await()) {
            case 7: {
                return (T)this.result.get();
            }
            case 3: {
                if (this.callback != null) {
                    this.callback.raiseAbortedException((Throwable)this.result.get());
                }
                throw new RejectedExecutionException((Throwable)this.result.get());
            }
            case 6: {
                throw new ExecutionException((Throwable)this.result.get());
            }
            case 4: 
            case 5: {
                throw new CancellationException();
            }
            case 0: 
            case 2: {
                if (this.callback != null) {
                    this.callback.resolveDeadlockOnFutureGet();
                }
                throw new InterruptedException();
            }
        }
        throw new IllegalStateException(Integer.toString(this.state.get()));
    }

    @Override
    public T get(long time, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        switch (this.await(time, unit)) {
            case 7: {
                return (T)this.result.get();
            }
            case 3: {
                if (this.callback != null) {
                    this.callback.raiseAbortedException((Throwable)this.result.get());
                }
                throw new RejectedExecutionException((Throwable)this.result.get());
            }
            case 6: {
                throw new ExecutionException((Throwable)this.result.get());
            }
            case 4: 
            case 5: {
                throw new CancellationException();
            }
            case -1: {
                throw new TimeoutException();
            }
            case 0: 
            case 2: {
                if (this.callback != null) {
                    this.callback.resolveDeadlockOnFutureGet();
                }
                throw new InterruptedException();
            }
        }
        throw new IllegalStateException(Integer.toString(this.state.get()));
    }

    @Override
    public final long getElapsedAcceptTime(TimeUnit unit) {
        long elapsed = this.nsAcceptEnd - this.nsAcceptBegin;
        return unit.convert(elapsed >= 0L ? elapsed : System.nanoTime() - this.nsAcceptBegin, TimeUnit.NANOSECONDS);
    }

    @Override
    public final long getElapsedQueueTime(TimeUnit unit) {
        long begin = this.nsAcceptEnd;
        long elapsed = this.nsQueueEnd - begin;
        return unit.convert(elapsed >= 0L ? elapsed : (begin - this.nsAcceptBegin > 0L ? System.nanoTime() - begin : 0L), TimeUnit.NANOSECONDS);
    }

    @Override
    public final long getElapsedRunTime(TimeUnit unit) {
        long begin = this.nsQueueEnd;
        long elapsed = this.nsRunEnd - begin;
        return unit.convert(elapsed >= 0L ? elapsed : (begin - this.nsAcceptBegin > 0L ? System.nanoTime() - begin : 0L), TimeUnit.NANOSECONDS);
    }

    @Trivial
    final String getIdentifier() {
        return this.callback == null ? this.executor.identifier : this.callback.getIdentifier(this.executor.identifier);
    }

    @Trivial
    final String getTaskName() {
        return this.callback == null ? this.task.toString() : this.callback.getName(this.task);
    }

    @Override
    public boolean isCancelled() {
        int s = this.state.get();
        return s == 5 || s == 4;
    }

    @Override
    public boolean isDone() {
        int s = this.state.get();
        return s > 2 || this.nsStartBy != this.nsAcceptBegin - 1L && s < 2 && System.nanoTime() - this.nsStartBy > 0L && (this.abort(true, new StartTimeoutException(this.getIdentifier(), this.getTaskName(), System.nanoTime() - this.nsAcceptBegin, this.nsStartBy - this.nsAcceptBegin)) || this.state.get() > 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Throwable.class})
    void run() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (!this.state.setRunning()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"unable to run", (Object[])new Object[]{this.state.get()});
            }
            this.nsRunEnd = System.nanoTime();
            if (this.callback != null) {
                this.callback.onEnd(this.task, this, null, true, 0, null);
            }
            return;
        }
        boolean aborted = true;
        Object callbackContext = null;
        this.thread = Thread.currentThread();
        try {
            if (this.callback == null) {
                aborted = false;
            } else {
                callbackContext = this.callback.onStart(this.task, this);
                boolean bl = aborted = this.state.get() == 5;
            }
            if (aborted) {
                this.nsRunEnd = System.nanoTime();
            } else {
                T t;
                if (this.callable == null) {
                    this.runnable.run();
                    t = this.predefinedResult;
                } else {
                    t = this.callable.call();
                }
                this.nsRunEnd = System.nanoTime();
                if (this.result.compareAndSet(this.state, t)) {
                    this.state.releaseShared(7);
                    if (this.latch != null) {
                        this.latch.countDown(t);
                    }
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{t});
                }
            }
            if (this.callback != null) {
                try {
                    this.callback.onEnd(this.task, this, callbackContext, aborted, 0, null);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        catch (Throwable x) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[]{x});
            }
            this.nsRunEnd = System.nanoTime();
            if (this.result.compareAndSet(this.state, x)) {
                this.state.releaseShared(aborted ? 3 : 6);
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
            if (this.callback != null) {
                this.callback.onEnd(this.task, this, callbackContext, aborted, 0, x);
            }
        }
        finally {
            this.thread = null;
            while (this.state.get() == 4) {
                Thread.yield();
            }
        }
    }

    @Trivial
    void throwIfInterrupted() throws InterruptedException {
        Object x;
        int s = this.state.get();
        if ((s == 6 || s == 3) && (x = this.result.get()) instanceof InterruptedException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"interrupted", (Object[])new Object[]{x});
            }
            throw (InterruptedException)x;
        }
    }

    @Trivial
    public String toString() {
        StringBuilder b = new StringBuilder("PolicyTaskFuture@").append(Integer.toHexString(this.hashCode())).append(" for ").append(this.task).append(' ');
        int s = this.state.get();
        switch (s) {
            case 0: {
                b.append("PRESUBMIT");
                break;
            }
            case 1: {
                b.append("SUBMITTED");
                break;
            }
            case 2: {
                b.append("RUNNING");
                break;
            }
            case 3: {
                b.append("ABORTED");
                break;
            }
            case 4: {
                b.append("CANCELING");
                break;
            }
            case 5: {
                b.append("CANCELED");
                break;
            }
            case 6: {
                b.append("FAILED");
                break;
            }
            case 7: {
                b.append("SUCCESSFUL");
                break;
            }
            default: {
                b.append(s);
            }
        }
        b.append(" on ").append(this.getIdentifier());
        if (s == 7 || s == 6) {
            b.append(": ").append(this.result.get());
        }
        return b.toString();
    }

    @Trivial
    private static class State
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;

        private State() {
        }

        private final int get() {
            return this.getState();
        }

        private boolean setRunning() {
            return this.compareAndSetState(1, 2);
        }

        private boolean setSubmitted() {
            return this.compareAndSetState(0, 1);
        }

        @Override
        protected final int tryAcquireShared(int ignored) {
            return this.getState() > 2 ? 1 : -1;
        }

        @Override
        protected final boolean tryReleaseShared(int newState) {
            int oldState;
            while (!this.compareAndSetState(oldState = this.getState(), newState)) {
            }
            return oldState <= 2;
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class InvokeAnyLatch
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;
        private final AtomicReference<Object> result;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        InvokeAnyLatch(int count) {
            this.setState(count);
            this.result = new AtomicReference<InvokeAnyLatch>(this);
        }

        <T> T await(long timeoutNS, List<PolicyTaskFutureImpl<T>> futures) throws ExecutionException, InterruptedException, TimeoutException {
            Object result;
            int countdown = this.getCount();
            if (countdown > 0) {
                if (timeoutNS < 0L) {
                    this.acquireSharedInterruptibly(countdown);
                } else if (!this.tryAcquireSharedNanos(countdown, timeoutNS)) {
                    throw new TimeoutException();
                }
            }
            if ((result = this.result.get()) != this) {
                return (T)result;
            }
            boolean canceled = false;
            for (PolicyTaskFutureImpl<T> f : futures) {
                int s = ((PolicyTaskFutureImpl)f).state.get();
                if (s == 6) {
                    throw new ExecutionException((Throwable)((PolicyTaskFutureImpl)f).result.get());
                }
                if (s == 3) {
                    Throwable x = (Throwable)((PolicyTaskFutureImpl)f).result.get();
                    if (f.callback != null) {
                        f.callback.raiseAbortedException(x);
                    }
                    throw new RejectedExecutionException(x);
                }
                if (s != 5 && s != 4) continue;
                canceled = true;
            }
            if (canceled) {
                throw new CancellationException();
            }
            throw new IllegalStateException(this + ", " + futures);
        }

        boolean countDown() {
            return this.releaseShared(1);
        }

        boolean countDown(Object result) {
            return this.result.compareAndSet(this, result) && this.releaseShared(this.getState());
        }

        @Trivial
        int getCount() {
            return this.getState();
        }

        @Override
        @Trivial
        public String toString() {
            Object r = this.result.get();
            return "InvokeAnyLatch@" + Integer.toHexString(this.hashCode()) + ' ' + "count:" + this.getState() + ", result:" + (r == this ? "<empty>" : r);
        }

        @Override
        @Trivial
        protected final int tryAcquireShared(int ignored) {
            return this.getState() > 0 ? -1 : 1;
        }

        @Override
        @Trivial
        protected final boolean tryReleaseShared(int amount) {
            int count;
            if (amount < 0) {
                throw new IllegalArgumentException(Integer.toString(amount));
            }
            while ((count = this.getState()) > 0 && !this.compareAndSetState(count, amount > count ? 0 : count - amount)) {
            }
            return count > 0 && count <= amount;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(InvokeAnyLatch.class);
        }
    }

    @Trivial
    private static class InterruptAction
    implements PrivilegedAction<Void> {
        private final Thread thread;

        private InterruptAction(Thread t) {
            this.thread = t;
        }

        @Override
        public Void run() {
            this.thread.interrupt();
            return null;
        }
    }
}

