/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.exceptions.ParseException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Currency;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.inject.Singleton;
import javax.xml.bind.DatatypeConverter;

@Singleton
public class DefaultDecoder
implements Decoder {
    private Map<Class<?>, Function<String, ?>> decoderRegistry = new IdentityHashMap(75);
    public static DefaultDecoder INSTANCE = new DefaultDecoder();

    public DefaultDecoder() {
        this.decoderRegistry.put(String.class, v -> v);
        this.decoderRegistry.put(Boolean.TYPE, v -> {
            if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("yes") || v.equalsIgnoreCase("on")) {
                return Boolean.TRUE;
            }
            if (v.equalsIgnoreCase("false") || v.equalsIgnoreCase("no") || v.equalsIgnoreCase("off")) {
                return Boolean.FALSE;
            }
            throw new ParseException("Error parsing value '" + v + "'", new Exception("Expected one of [true, yes, on, false, no, off]"));
        });
        this.decoderRegistry.put(Boolean.class, this.decoderRegistry.get(Boolean.TYPE));
        this.decoderRegistry.put(Integer.class, Integer::valueOf);
        this.decoderRegistry.put(Integer.TYPE, Integer::valueOf);
        this.decoderRegistry.put(Long.TYPE, Long::valueOf);
        this.decoderRegistry.put(Long.class, Long::valueOf);
        this.decoderRegistry.put(Short.TYPE, Short::valueOf);
        this.decoderRegistry.put(Short.class, Short::valueOf);
        this.decoderRegistry.put(Byte.TYPE, Byte::valueOf);
        this.decoderRegistry.put(Byte.class, Byte::valueOf);
        this.decoderRegistry.put(Double.TYPE, Double::valueOf);
        this.decoderRegistry.put(Double.class, Double::valueOf);
        this.decoderRegistry.put(Float.TYPE, Float::valueOf);
        this.decoderRegistry.put(Float.class, Float::valueOf);
        this.decoderRegistry.put(BigInteger.class, BigInteger::new);
        this.decoderRegistry.put(BigDecimal.class, BigDecimal::new);
        this.decoderRegistry.put(AtomicInteger.class, s -> new AtomicInteger(Integer.parseInt(s)));
        this.decoderRegistry.put(AtomicLong.class, s -> new AtomicLong(Long.parseLong(s)));
        this.decoderRegistry.put(Duration.class, Duration::parse);
        this.decoderRegistry.put(Period.class, Period::parse);
        this.decoderRegistry.put(LocalDateTime.class, LocalDateTime::parse);
        this.decoderRegistry.put(LocalDate.class, LocalDate::parse);
        this.decoderRegistry.put(LocalTime.class, LocalTime::parse);
        this.decoderRegistry.put(OffsetDateTime.class, OffsetDateTime::parse);
        this.decoderRegistry.put(OffsetTime.class, OffsetTime::parse);
        this.decoderRegistry.put(ZonedDateTime.class, ZonedDateTime::parse);
        this.decoderRegistry.put(Instant.class, v -> Instant.from(OffsetDateTime.parse(v)));
        this.decoderRegistry.put(Date.class, v -> new Date(Long.parseLong(v)));
        this.decoderRegistry.put(Currency.class, Currency::getInstance);
        this.decoderRegistry.put(BitSet.class, v -> BitSet.valueOf(DatatypeConverter.parseHexBinary((String)v)));
    }

    @Override
    public <T> T decode(Class<T> type, String encoded) {
        if (encoded == null) {
            return null;
        }
        if (this.decoderRegistry.containsKey(type)) {
            return (T)this.decoderRegistry.get(type).apply(encoded);
        }
        if (type.isArray()) {
            String[] elements = encoded.split(",");
            Object[] ar = (Object[])Array.newInstance(type.getComponentType(), elements.length);
            for (int i = 0; i < elements.length; ++i) {
                ar[i] = this.decode(type.getComponentType(), elements[i]);
            }
            return (T)ar;
        }
        try {
            try {
                Method method = type.getMethod("valueOf", String.class);
                return (T)method.invoke(null, encoded);
            }
            catch (NoSuchMethodException e1) {
                try {
                    Constructor<T> c = type.getConstructor(String.class);
                    return c.newInstance(encoded);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(type.getCanonicalName() + " has no String constructor or valueOf static method");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate value of type " + type.getCanonicalName(), e);
        }
    }
}

