/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.readers;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigReader;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.readers.URLConfigReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigReader
implements ConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesConfigReader.class);
    private static final String INCLUDE_KEY = "@next";
    private static final String SUFFIX = ".properties";

    @Override
    public Config load(ClassLoader loader, String resourceName, StrInterpolator strInterpolator, StrInterpolator.Lookup lookup) throws ConfigException {
        URL url = PropertiesConfigReader.getResource(loader, resourceName);
        if (url == null) {
            throw new ConfigException("Unable to resolve URL for resource " + resourceName);
        }
        return this.load(loader, url, strInterpolator, lookup);
    }

    @Override
    public Config load(ClassLoader loader, URL url, StrInterpolator strInterpolator, StrInterpolator.Lookup lookup) throws ConfigException {
        Properties props = new Properties();
        this.internalLoad(props, new HashSet<String>(), loader, url, strInterpolator, lookup);
        return MapConfig.from(props);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void internalLoad(Properties props, Set<String> seenUrls, ClassLoader loader, URL url, StrInterpolator strInterpolator, StrInterpolator.Lookup lookup) {
        LOG.debug("Attempting to load : {}", (Object)url.toExternalForm());
        if (!seenUrls.contains(url.toExternalForm())) {
            seenUrls.add(url.toExternalForm());
            try {
                Map<String, String> p = new URLConfigReader(url).call().getToAdd();
                LOG.debug("Loaded : {}", (Object)url.toExternalForm());
                props.putAll(p);
                String next = p.get(INCLUDE_KEY);
                if (next == null) return;
                p.remove(INCLUDE_KEY);
                for (String urlString : next.split(",")) {
                    URL nextUrl = PropertiesConfigReader.getResource(loader, strInterpolator.create(lookup).resolve(urlString));
                    if (nextUrl == null) continue;
                    this.internalLoad(props, seenUrls, loader, nextUrl, strInterpolator, lookup);
                }
                return;
            }
            catch (IOException e) {
                LOG.debug("Unable to load configuration file {}. {}", (Object)url, (Object)e.getMessage());
                return;
            }
        } else {
            LOG.debug("Circular dependency trying to load url : {}", (Object)url.toExternalForm());
        }
    }

    @Override
    public boolean canLoad(ClassLoader loader, String name) {
        return PropertiesConfigReader.getResource(loader, name) != null;
    }

    @Override
    public boolean canLoad(ClassLoader loader, URL uri) {
        return uri.getPath().endsWith(SUFFIX);
    }

    private static URL getResource(ClassLoader loader, String resourceName) {
        if (!resourceName.endsWith(SUFFIX)) {
            resourceName = resourceName + SUFFIX;
        }
        URL url = null;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader != null) {
            url = loader.getResource(resourceName);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName);
        }
        if (url == null) {
            try {
                resourceName = URLDecoder.decode(resourceName, "UTF-8");
                url = new File(resourceName).toURI().toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }
}

