/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.anno.info.internal.AnnotationInfoImpl;
import com.ibm.ws.anno.info.internal.ClassInfoImpl;
import com.ibm.ws.anno.info.internal.DelayedClassInfo;
import com.ibm.ws.anno.info.internal.FieldInfoImpl;
import com.ibm.ws.anno.info.internal.InfoStoreImpl;
import com.ibm.ws.anno.info.internal.MethodInfoImpl;
import com.ibm.ws.anno.info.internal.PackageInfoImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NonDelayedClassInfo
extends ClassInfoImpl {
    private static final TraceComponent tc = Tr.register(NonDelayedClassInfo.class);
    public static final String CLASS_NAME = NonDelayedClassInfo.class.getName();
    protected static final boolean IS_ARTIFICIAL = true;
    protected static final boolean IS_NOT_ARTIFICIAL = false;
    private final boolean isArtificial;
    private final boolean isInterface;
    private final String packageName;
    private PackageInfoImpl packageInfo;
    private final boolean isJavaClass;
    private final String[] interfaceNames;
    private ClassInfoImpl[] interfaces;
    private final String superClassName;
    private ClassInfoImpl superClass;
    private List<FieldInfoImpl> declaredFields = Collections.emptyList();
    private List<MethodInfoImpl> declaredConstructors = Collections.emptyList();
    private List<MethodInfoImpl> declaredMethods = Collections.emptyList();
    public static final String[] EMPTY_INTERFACE_NAMES = new String[0];
    public static final int MODIFIER_PUBLIC_NONINTERFACE = 1;
    private static final Comparator<MethodInfoImpl> METHOD_COMPARATOR = new Comparator<MethodInfoImpl>(){
        static final long serialVersionUID = -5711417425299416233L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public int compare(MethodInfoImpl m1, MethodInfoImpl m2) {
            int result = m1.getName().compareTo(m2.getName());
            if (result == 0) {
                result = m1.getDescription().compareTo(m2.getDescription());
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    protected boolean isFieldAnnotationPresent;
    protected boolean isMethodAnnotationPresent;
    private List<AnnotationInfoImpl> annotations;
    protected DelayedClassInfo delayedClassInfo;
    protected NonDelayedClassInfo priorClassInfo;
    protected NonDelayedClassInfo nextClassInfo;
    static final long serialVersionUID = -4717001816064823942L;

    public static boolean isInterface(int modifiers) {
        return Modifier.isInterface(modifiers);
    }

    protected NonDelayedClassInfo(String name, InfoStoreImpl infoStore) {
        this(name, "java.lang.Object", 1, EMPTY_INTERFACE_NAMES, true, infoStore);
    }

    public NonDelayedClassInfo(String name, String superClassName, int modifiers, String[] interfaceNames, InfoStoreImpl infoStore) {
        this(name, superClassName, modifiers, interfaceNames, false, infoStore);
    }

    public NonDelayedClassInfo(String name, String superClassName, int modifiers, String[] interfaceNames, boolean isArtificial, InfoStoreImpl infoStore) {
        super(name, modifiers, infoStore);
        if (name.equals("java.lang.Object")) {
            superClassName = null;
        }
        InfoStoreImpl useStore = this.getInfoStore();
        this.isArtificial = isArtificial;
        this.isInterface = NonDelayedClassInfo.isInterface(modifiers);
        this.packageName = useStore.internPackageName(ClassInfoImpl.getPackageName(name));
        this.packageInfo = null;
        this.isJavaClass = ClassInfoImpl.isJavaClass(name);
        for (int nameNo = 0; nameNo < interfaceNames.length; ++nameNo) {
            interfaceNames[nameNo] = useStore.internClassName(interfaceNames[nameNo]);
        }
        this.interfaceNames = interfaceNames;
        this.interfaces = null;
        if (superClassName == null && !name.equals("java.lang.Object") && !this.isInterface && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Strange: Null superclass name for non-interface!", (Object[])new Object[0]);
        }
        this.superClassName = useStore.internClassName(superClassName);
        this.superClass = null;
        if (tc.isDebugEnabled()) {
            if (this.isArtificial) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("<init> [ {0} ] Created [ ** ARTIFICIAL ** ]", this.getHashText()), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("<init> [ {0} ] Created", this.getHashText()), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public boolean isArtificial() {
        return this.isArtificial;
    }

    public boolean isNonDelayed() {
        return true;
    }

    @Override
    public NonDelayedClassInfo asNonDelayedClass() {
        return this;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public PackageInfoImpl getPackage() {
        if (this.packageInfo == null && this.packageName != null) {
            this.packageInfo = this.getInfoStore().getPackageInfo(this.packageName, true);
        }
        return this.packageInfo;
    }

    @Override
    public boolean isJavaClass() {
        return this.isJavaClass;
    }

    @Override
    public List<String> getInterfaceNames() {
        return Arrays.asList(this.interfaceNames);
    }

    public List<ClassInfoImpl> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new ClassInfoImpl[this.interfaceNames.length];
            int i = 0;
            for (String interfaceName : this.interfaceNames) {
                ClassInfoImpl nextInterface = this.getInfoStore().getDelayableClassInfo(interfaceName);
                this.interfaces[i++] = nextInterface;
            }
        }
        return Arrays.asList(this.interfaces);
    }

    @Override
    public boolean isAnnotationClass() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public String getSuperclassName() {
        return this.superClassName;
    }

    @Override
    public ClassInfoImpl getSuperclass() {
        if (this.superClass == null && this.superClassName != null) {
            this.superClass = this.getInfoStore().getDelayableClassInfo(this.superClassName);
        }
        return this.superClass;
    }

    @Override
    public boolean isInstanceOf(String className) {
        if (this.getName().equals(className)) {
            return true;
        }
        for (String intfName : this.interfaceNames) {
            if (!className.equals(intfName)) continue;
            return true;
        }
        if (this.isInterface()) {
            return false;
        }
        ClassInfoImpl useSuperClass = this.getSuperclass();
        return useSuperClass != null && useSuperClass.isInstanceOf(className);
    }

    @Override
    public boolean isAssignableFrom(String className) {
        if (this.getName().equals(className)) {
            return true;
        }
        return this.getInfoStore().getDelayableClassInfo(className).isInstanceOf(this.getName());
    }

    public List<FieldInfoImpl> getDeclaredFields() {
        return this.declaredFields;
    }

    public List<MethodInfoImpl> getDeclaredConstructors() {
        return this.declaredConstructors;
    }

    public List<MethodInfoImpl> getDeclaredMethods() {
        return this.declaredMethods;
    }

    @Override
    public List<MethodInfoImpl> getMethods() {
        LinkedList<MethodInfoImpl> methods = new LinkedList<MethodInfoImpl>();
        methods.addAll(this.declaredMethods);
        ClassInfoImpl superClass = this.getSuperclass();
        if (superClass != null) {
            Map<MethodInfoImpl, MethodInfoImpl> overriden = Collections.emptyMap();
            if (this.declaredMethods.size() > 0) {
                overriden = new TreeMap(METHOD_COMPARATOR);
                for (MethodInfoImpl method : this.declaredMethods) {
                    if (method.isPrivate()) continue;
                    overriden.put(method, method);
                }
            }
            List<MethodInfoImpl> superMethods = superClass.getMethods();
            for (MethodInfoImpl method : superMethods) {
                MethodInfoImpl oMethod;
                if (method.isPackagePrivate() && method.getDeclaringClass().getPackage() != this.getPackage() || !method.isPrivate() && (oMethod = (MethodInfoImpl)overriden.get(method)) != null) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    @Override
    public boolean isFieldAnnotationPresent() {
        return this.isFieldAnnotationPresent;
    }

    @Override
    public boolean isMethodAnnotationPresent() {
        return this.isMethodAnnotationPresent;
    }

    @Override
    public List<AnnotationInfoImpl> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations;
        }
        ClassInfoImpl useSuperClass = this.getSuperclass();
        if (useSuperClass == null) {
            this.annotations = this.declaredAnnotations;
            return this.annotations;
        }
        Collection superAnnos = useSuperClass.getAnnotations();
        if (superAnnos.isEmpty()) {
            this.annotations = this.declaredAnnotations;
            return this.annotations;
        }
        HashMap<String, AnnotationInfoImpl> allAnnotations = new HashMap<String, AnnotationInfoImpl>(superAnnos.size() + this.declaredAnnotations.size(), 1.0f);
        boolean sawInherited = false;
        for (AnnotationInfoImpl superAnno : superAnnos) {
            sawInherited = superAnno.isInherited();
            if (!sawInherited) continue;
            allAnnotations.put(superAnno.getAnnotationClassName(), superAnno);
        }
        if (!sawInherited) {
            this.annotations = this.declaredAnnotations;
            return this.annotations;
        }
        for (AnnotationInfoImpl declaredAnno : this.declaredAnnotations) {
            AnnotationInfoImpl overwrittenAnno = allAnnotations.put(declaredAnno.getAnnotationClassName(), declaredAnno);
            if (overwrittenAnno == null) continue;
        }
        this.annotations = new ArrayList(allAnnotations.values());
        return this.annotations;
    }

    public void setDelayedClassInfo(DelayedClassInfo delayedClassInfo) {
        this.delayedClassInfo = delayedClassInfo;
    }

    public DelayedClassInfo getDelayedClassInfo() {
        return this.delayedClassInfo;
    }

    public NonDelayedClassInfo setPriorClassInfo(NonDelayedClassInfo newPriorClassInfo) {
        NonDelayedClassInfo oldPriorClassInfo = this.priorClassInfo;
        this.priorClassInfo = newPriorClassInfo;
        return oldPriorClassInfo;
    }

    public NonDelayedClassInfo getPriorClassInfo() {
        return this.priorClassInfo;
    }

    public NonDelayedClassInfo setNextClassInfo(NonDelayedClassInfo newNextClassInfo) {
        NonDelayedClassInfo oldNextClassInfo = this.nextClassInfo;
        this.nextClassInfo = newNextClassInfo;
        return oldNextClassInfo;
    }

    public NonDelayedClassInfo getNextClassInfo() {
        return this.nextClassInfo;
    }

    @Override
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format(" Non-Delayed Class [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  delayedClassInfo [ {0} ]", this.delayedClassInfo == null ? null : this.delayedClassInfo.getHashText()), (Object[])new Object[0]);
        if (!logger.isDumpEnabled()) {
            return;
        }
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isInterface [ {0} ]", this.isInterface), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  packageName [ {0} ]", this.packageName), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  packageInfo [ {0} ]", this.packageInfo == null ? null : this.packageInfo.getHashText()), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isJavaClass [ {0} ]", this.isJavaClass), (Object[])new Object[0]);
        if (this.interfaceNames == null) {
            Tr.dump((TraceComponent)logger, (String)"  interfaceNames [ null ]", (Object[])new Object[0]);
        } else {
            for (String interfaceName : this.interfaceNames) {
                Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  interfaceName [ {0} ]", interfaceName), (Object[])new Object[0]);
            }
        }
        if (this.interfaces == null) {
            Tr.dump((TraceComponent)logger, (String)"  interfaces [ null ]", (Object[])new Object[0]);
        } else {
            for (ClassInfoImpl interfaceInfo : this.interfaces) {
                Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  interface [ {0} ]", interfaceInfo.getHashText()), (Object[])new Object[0]);
            }
        }
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  superClassName [ {0} ]", this.superClassName), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  superClass [ {0} ]", this.superClass == null ? null : this.superClass.getHashText()), (Object[])new Object[0]);
        if (this.declaredFields == null) {
            Tr.dump((TraceComponent)logger, (String)"  declaredFields [ null ]", (Object[])new Object[0]);
        } else {
            for (FieldInfoImpl fieldInfo : this.declaredFields) {
                Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  declaredFields [ {0} ]", fieldInfo.getHashText()), (Object[])new Object[0]);
            }
        }
        if (this.declaredConstructors == null) {
            Tr.dump((TraceComponent)logger, (String)"  declaredConstructors [ null ]", (Object[])new Object[0]);
        } else {
            for (MethodInfoImpl methodInfo : this.declaredConstructors) {
                Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  declaredConstructors [ {0} ]", methodInfo.getHashText()), (Object[])new Object[0]);
            }
        }
        if (this.declaredMethods == null) {
            Tr.dump((TraceComponent)logger, (String)"  declaredMethods [ null ]", (Object[])new Object[0]);
        } else {
            for (MethodInfoImpl methodInfo : this.declaredMethods) {
                Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  declaredMethods [ {0} ]", methodInfo.getHashText()), (Object[])new Object[0]);
            }
        }
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isFieldAnnotationPresent [ {0} ]", this.isFieldAnnotationPresent), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isMethodAnnotationPresent [ {0} ]", this.isMethodAnnotationPresent), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  delayedClassInfo [ {0} ]", this.delayedClassInfo == null ? null : this.delayedClassInfo.getHashText()), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  priorClassInfo [ {0} ]", this.priorClassInfo == null ? null : this.priorClassInfo.getHashText()), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  nextClassInfo [ {0} ]", this.nextClassInfo == null ? null : this.nextClassInfo.getHashText()), (Object[])new Object[0]);
        this.logAnnotations(logger);
        if (this.declaredConstructors != null) {
            for (MethodInfoImpl methodInfo : this.declaredConstructors) {
                methodInfo.log(logger);
            }
        }
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format(" Non-Delayed Class [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    public void setFields(FieldInfoImpl[] fields) {
        this.declaredFields = Arrays.asList(fields);
    }

    public void setConstructors(MethodInfoImpl[] constructors) {
        this.declaredConstructors = Arrays.asList(constructors);
    }

    public void setMethods(MethodInfoImpl[] methods) {
        this.declaredMethods = Arrays.asList(methods);
    }

    @Override
    public void setDeclaredAnnotations(AnnotationInfoImpl[] annos) {
        this.annotations = null;
        super.setDeclaredAnnotations(annos);
    }
}

