/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.targets.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.anno.service.internal.AnnotationServiceImpl_Logging;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Factory;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Fault;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_PolicyData;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Scanner;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsVisitor;
import com.ibm.ws.anno.util.internal.UtilImpl_BidirectionalMap;
import com.ibm.ws.anno.util.internal.UtilImpl_EmptyStringSet;
import com.ibm.ws.anno.util.internal.UtilImpl_Factory;
import com.ibm.ws.anno.util.internal.UtilImpl_InternMap;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Exception;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AnnotationTargetsImpl_Targets
implements AnnotationTargets_Targets {
    private static final TraceComponent tc = Tr.register(AnnotationTargetsImpl_Targets.class);
    public static final String CLASS_NAME = AnnotationTargetsImpl_Targets.class.getName();
    protected final String hashText = AnnotationServiceImpl_Logging.getBaseHash(this);
    protected final AnnotationTargetsImpl_Factory factory;
    protected final UtilImpl_InternMap classSourceInternMap;
    protected ClassSource_Aggregate rootClassSource;
    protected int directClassSourceCount;
    protected boolean haveScannedDirectClasses;
    protected int externalClassSourceCount;
    protected boolean haveScannedReferencedClasses;
    protected final UtilImpl_InternMap classInternMap;
    protected final AnnotationTargetsVisitor visitor;
    protected final Map<String, String> i_unresolvedPackageNames;
    protected final Map<String, String> i_scannedClassNames;
    protected Map<String, String> i_referencedClassNames;
    protected final Map<String, String> i_unresolvedClassNames;
    protected final UtilImpl_BidirectionalMap classSourceClassData;
    protected final Map<String, String> i_superclassNameMap;
    protected Map<String, String[]> i_interfaceNameMap;
    protected IdentityHashMap<String, Set<String>> i_allImplementersMap;
    protected IdentityHashMap<String, Set<String>> i_descendantsMap;
    protected final boolean isDetailEnabled;
    protected final AnnotationTargetsImpl_PolicyData seedData;
    protected final AnnotationTargetsImpl_PolicyData partialData;
    protected final AnnotationTargetsImpl_PolicyData excludedData;
    protected final AnnotationTargetsImpl_PolicyData externalData;
    static final long serialVersionUID = -3049218285772143434L;

    public String getHashText() {
        return this.hashText;
    }

    protected AnnotationTargetsImpl_Targets(AnnotationTargetsImpl_Factory factory, UtilImpl_InternMap classInternMap, boolean isDetailEnabled) {
        this.factory = factory;
        this.classSourceInternMap = this.createInternMap(Util_InternMap.ValueType.VT_OTHER, "class sources");
        this.classSourceClassData = this.createBidiMap("class source", this.classSourceInternMap, "class", classInternMap, true);
        this.classInternMap = classInternMap;
        this.i_scannedClassNames = new IdentityHashMap<String, String>();
        this.i_superclassNameMap = new IdentityHashMap<String, String>();
        this.i_interfaceNameMap = new IdentityHashMap<String, String[]>();
        this.isDetailEnabled = isDetailEnabled;
        this.seedData = new AnnotationTargetsImpl_PolicyData(this, classInternMap, ClassSource_Aggregate.ScanPolicy.SEED, isDetailEnabled);
        this.partialData = new AnnotationTargetsImpl_PolicyData(this, classInternMap, ClassSource_Aggregate.ScanPolicy.PARTIAL, isDetailEnabled);
        this.excludedData = new AnnotationTargetsImpl_PolicyData(this, classInternMap, ClassSource_Aggregate.ScanPolicy.EXCLUDED, isDetailEnabled);
        this.externalData = new AnnotationTargetsImpl_PolicyData(this, classInternMap, ClassSource_Aggregate.ScanPolicy.EXTERNAL, isDetailEnabled);
        this.i_referencedClassNames = new IdentityHashMap<String, String>();
        this.i_unresolvedPackageNames = new IdentityHashMap<String, String>();
        this.i_unresolvedClassNames = new IdentityHashMap<String, String>();
        this.visitor = new AnnotationTargetsVisitor(this);
        this.i_descendantsMap = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Visitor [ {1} ]", this.hashText, this.visitor.getHashText()), (Object[])new Object[0]);
        }
    }

    @Override
    public AnnotationTargetsImpl_Factory getFactory() {
        return this.factory;
    }

    protected AnnotationTargetsImpl_Fault createFault(String unresolvedText, String[] parameters) {
        return this.getFactory().createFault(unresolvedText, parameters);
    }

    protected AnnotationTargetsImpl_Scanner createScanner(ClassSource_Aggregate classSource) throws AnnotationTargets_Exception {
        return new AnnotationTargetsImpl_Scanner(this.getFactory(), classSource, this);
    }

    protected UtilImpl_BidirectionalMap createBidiMap(String holderTag, UtilImpl_InternMap holderInternMap, String heldTag, UtilImpl_InternMap heldInternMap, boolean isEnabled) {
        return this.getFactory().getUtilFactory().createBidirectionalMap(holderTag, holderInternMap, heldTag, heldInternMap, isEnabled);
    }

    protected UtilImpl_InternMap createInternMap(Util_InternMap.ValueType valueType, String mapName) {
        return this.getFactory().getUtilFactory().createInternMap(valueType, mapName);
    }

    protected UtilImpl_InternMap getClassSourceInternMap() {
        return this.classSourceInternMap;
    }

    protected String internClassSourceName(String classSourceName) {
        return this.getClassSourceInternMap().intern(classSourceName);
    }

    protected String internClassSourceName(String className, boolean doForce) {
        return this.getClassSourceInternMap().intern(className, doForce);
    }

    public boolean activated() {
        return this.haveScannedReferencedClasses || this.rootClassSource != null;
    }

    public ClassSource_Aggregate getRootClassSource() {
        return this.rootClassSource;
    }

    protected void setRootClassSource(ClassSource_Aggregate classSource) {
        this.rootClassSource = classSource;
        Set<? extends ClassSource> seedClassSources = classSource.getSeedClassSources();
        Set<? extends ClassSource> partialClassSources = classSource.getPartialClassSources();
        Set<? extends ClassSource> excludedClassSources = classSource.getExcludedClassSources();
        Set<? extends ClassSource> externalClassSources = classSource.getExternalClassSources();
        this.directClassSourceCount = seedClassSources.size() + partialClassSources.size() + excludedClassSources.size();
        this.externalClassSourceCount = externalClassSources.size();
    }

    public int getDirectClassSourceCount() {
        return this.directClassSourceCount;
    }

    public boolean scannedDirectClasses() {
        return this.haveScannedDirectClasses;
    }

    public int getExternalClassSourceCount() {
        return this.externalClassSourceCount;
    }

    public boolean scannedReferencedClasses() {
        return this.haveScannedReferencedClasses;
    }

    @Override
    public void addClassSource(ClassSource source, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (source == null) {
            throw new IllegalArgumentException("Null added class source");
        }
        if (this.haveScannedReferencedClasses) {
            if (tc.isDebugEnabled()) {
                String eMsg = MessageFormat.format("Attempt to add class source [ {0} ] [ {1} ] after both direct and reference scans", new Object[]{source, scanPolicy});
                Tr.debug((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
            }
        } else if (this.haveScannedDirectClasses && scanPolicy != ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
            if (tc.isDebugEnabled()) {
                String eMsg = MessageFormat.format("Non-external class source [ {0} ] [ {1} ] added after the direct scan", new Object[]{source, scanPolicy});
                Tr.debug((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
            }
        } else if (this.rootClassSource == null) {
            if (tc.isDebugEnabled()) {
                String eMsg = MessageFormat.format("Attempt to add class source [ {0} ] [ {1} ] before activation", new Object[]{source, scanPolicy});
                Tr.debug((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
            }
        } else {
            String eMsg;
            if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
                if (this.directClassSourceCount == 0 && tc.isDebugEnabled()) {
                    eMsg = MessageFormat.format("Strange addition external class source [ {0} ] [ {1} ] with no direct class sources", new Object[]{source, scanPolicy});
                    Tr.debug((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
                }
                ++this.externalClassSourceCount;
            } else if (this.externalClassSourceCount != 0) {
                if (tc.isDebugEnabled()) {
                    eMsg = MessageFormat.format("Strange addition direct class source [ {0} ] [ {1} ] after an external class source", new Object[]{source, scanPolicy});
                    Tr.debug((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
                }
                ++this.directClassSourceCount;
            }
            if (tc.isDebugEnabled()) {
                eMsg = MessageFormat.format("Adding class source [ {0} ] [ {1} ]", new Object[]{source, scanPolicy});
                Tr.debug((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
            }
            this.rootClassSource.addClassSource(source, scanPolicy);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void scanReferenceClasses() {
        block3: {
            if (this.haveScannedReferencedClasses) {
                return;
            }
            try {
                this.doScanReferenceClasses();
            }
            catch (AnnotationTargets_Exception annotationTargets_Exception) {
                void e;
                FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Targets", (String)"294", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Exception scanning referenced classes for annotations", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]", e.toString()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doScanReferenceClasses() throws AnnotationTargets_Exception {
        if (this.haveScannedReferencedClasses) {
            return;
        }
        try {
            this.doScanDirectClasses();
        }
        catch (AnnotationTargets_Exception annotationTargets_Exception) {
            void e;
            FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Targets", (String)"313", (Object)this, (Object[])new Object[0]);
            this.haveScannedReferencedClasses = true;
            this.rootClassSource = null;
            throw e;
        }
        this.haveScannedReferencedClasses = true;
        ClassSource_Aggregate useRootClassSource = this.rootClassSource;
        this.rootClassSource = null;
        if (useRootClassSource == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt scan referenced classes before activation", (Object[])new Object[0]);
            }
        } else {
            if (this.externalClassSourceCount == 0 && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Strange call to scan reference classes with no external class sources", (Object[])new Object[0]);
            }
            this.createScanner(useRootClassSource).scanReferenced();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void scanDirectClasses() {
        block3: {
            if (this.haveScannedDirectClasses) {
                return;
            }
            try {
                this.doScanDirectClasses();
            }
            catch (AnnotationTargets_Exception annotationTargets_Exception) {
                void e;
                FFDCFilter.processException((Throwable)annotationTargets_Exception, (String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Targets", (String)"350", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Exception scanning referenced classes for annotations", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]", e.toString()), (Object[])new Object[0]);
            }
        }
    }

    protected void doScanDirectClasses() throws AnnotationTargets_Exception {
        if (this.haveScannedDirectClasses) {
            return;
        }
        this.haveScannedDirectClasses = true;
        if (this.rootClassSource == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Call to scan direct classes before activation", (Object[])new Object[0]);
            }
        } else {
            if (this.directClassSourceCount == 0 && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Strange call to scan direct classes before adding direct class sources", (Object[])new Object[0]);
            }
            this.createScanner(this.rootClassSource).scanDirect();
        }
    }

    @Override
    public void scan(ClassSource_Aggregate classSource, boolean scanImmediate) throws AnnotationTargets_Exception {
        if (this.haveScannedReferencedClasses) {
            if (tc.isDebugEnabled()) {
                String eMsg = MessageFormat.format("Scan requested on class source [ {0} ] but a reference scan has already been performed", classSource);
                Tr.debug((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
            }
        } else if (this.rootClassSource != null) {
            if (tc.isDebugEnabled()) {
                String eMsg = MessageFormat.format("Scan requested on class source [ {0} ] but root class source [ {1} ] is already set", classSource, this.rootClassSource);
                Tr.debug((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
            }
        } else {
            this.setRootClassSource(classSource);
            if (scanImmediate) {
                this.doScanDirectClasses();
                this.doScanReferenceClasses();
            }
        }
    }

    @Override
    public void scan(ClassSource_Aggregate classSource) throws AnnotationTargets_Exception {
        this.scan(classSource, false);
    }

    @Override
    public void scan(ClassSource_Aggregate classSource, Set<String> specificClassNames) throws AnnotationTargets_Exception {
        try {
            this.createScanner(classSource).scan(specificClassNames);
        }
        finally {
            this.haveScannedDirectClasses = true;
            this.haveScannedReferencedClasses = true;
        }
    }

    public UtilImpl_InternMap getClassInternMap() {
        return this.classInternMap;
    }

    public String internClassName(String className) {
        return this.getClassInternMap().intern(className);
    }

    public String internClassName(String className, boolean doForce) {
        return this.getClassInternMap().intern(className, doForce);
    }

    @FFDCIgnore(value={AnnotationTargetsVisitor.VisitEnded.class, ArrayIndexOutOfBoundsException.class})
    protected boolean scanClass(String classSourceName, String className, InputStream inputStream, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        boolean failedScan;
        Object[] logParms;
        if (tc.isDebugEnabled()) {
            logParms = new Object[]{this.getHashText(), className, null};
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER class [ {1} ]", logParms), (Object[])new Object[0]);
        } else {
            logParms = null;
        }
        AnnotationTargetsVisitor useVisitor = this.getVisitor();
        useVisitor.i_setClassSourceName(this.internClassSourceName(classSourceName));
        useVisitor.setScanPolicy(scanPolicy);
        useVisitor.setExternalName(className);
        try {
            ClassReader classReader = new ClassReader(inputStream);
            classReader.accept((ClassVisitor)this.getVisitor(), 7);
            failedScan = false;
            if (logParms != null) {
                logParms[2] = "Success";
            }
        }
        catch (IOException classReader) {
            FFDCFilter.processException((Throwable)classReader, (String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Targets", (String)"507", (Object)this, (Object[])new Object[]{classSourceName, className, inputStream, scanPolicy});
            failedScan = true;
            Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_FAILED_TO_CREATE_READER", (Object[])new Object[]{className});
        }
        catch (AnnotationTargetsVisitor.VisitEnded e) {
            boolean bl = failedScan = !e.isDetailCase();
            if (logParms != null) {
                logParms[2] = "Halted: " + (Object)((Object)e.getEndCase());
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Tr.info((TraceComponent)tc, (String)"ANNO_TARGETS_CORRUPT_CLASS", (Object[])new Object[]{className, classSourceName});
            failedScan = true;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Targets", (String)"529", (Object)this, (Object[])new Object[]{classSourceName, className, inputStream, scanPolicy});
            Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
            if (logParms != null) {
                logParms[2] = "Exception: " + e.getMessage();
            }
            failedScan = true;
        }
        if (logParms != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN From class [ {1} ]: [ {2} ]", logParms), (Object[])new Object[0]);
        }
        return !failedScan;
    }

    protected AnnotationTargetsVisitor getVisitor() {
        return this.visitor;
    }

    protected void recordUnresolvedClass(String classOrPackageName) {
        String i_className;
        if (!AnnotationTargetsVisitor.isPackageName(classOrPackageName) && !this.i_containsScannedClassName(i_className = this.internClassName(classOrPackageName))) {
            this.i_addUnresolvedClassName(i_className);
        }
    }

    public Set<String> getUnresolvedPackageNames() {
        this.scanReferenceClasses();
        return this.i_unresolvedPackageNames.keySet();
    }

    protected boolean i_addUnresolvedPackageName(String i_packageName) {
        return this.i_unresolvedPackageNames.put(i_packageName, i_packageName) == null;
    }

    protected boolean i_addScannedClassName(String i_className, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        boolean result = this.i_scannedClassNames.put(i_className, i_className) == null;
        this.doGetPolicyData(scanPolicy).i_addScannedClassName(i_className);
        return result;
    }

    public Set<String> getScannedClassNames() {
        this.scanReferenceClasses();
        return this.i_scannedClassNames.keySet();
    }

    public boolean i_containsScannedClassName(String i_className) {
        this.scanDirectClasses();
        return this.i_scannedClassNames.containsKey(i_className);
    }

    @Override
    public Set<String> getSeedClassNames() {
        this.scanDirectClasses();
        return this.seedData.getClassNames();
    }

    @Override
    public boolean isSeedClassName(String className) {
        this.scanDirectClasses();
        String i_className = this.getClassInternMap().intern(className, false);
        if (i_className == null) {
            return false;
        }
        return this.seedData.i_isClassName(i_className);
    }

    @Override
    public Set<String> getPartialClassNames() {
        this.scanDirectClasses();
        return this.partialData.getClassNames();
    }

    @Override
    public boolean isPartialClassName(String className) {
        this.scanDirectClasses();
        String i_className = this.getClassInternMap().intern(className, false);
        if (i_className == null) {
            return false;
        }
        return this.partialData.i_isClassName(i_className);
    }

    @Override
    public Set<String> getExcludedClassNames() {
        this.scanDirectClasses();
        return this.excludedData.getClassNames();
    }

    @Override
    public boolean isExcludedClassName(String className) {
        this.scanDirectClasses();
        String i_className = this.getClassInternMap().intern(className, false);
        if (i_className == null) {
            return false;
        }
        return this.excludedData.i_isClassName(i_className);
    }

    @Override
    public Set<String> getExternalClassNames() {
        this.scannedReferencedClasses();
        return this.externalData.getClassNames();
    }

    @Override
    public boolean isExternalClassName(String className) {
        this.scannedReferencedClasses();
        String i_className = this.getClassInternMap().intern(className, false);
        if (i_className == null) {
            return false;
        }
        return this.externalData.i_isClassName(i_className);
    }

    @Override
    public Set<String> getClassNames(int scanPolicy) {
        return this.selectClassNames(scanPolicy);
    }

    protected void i_removeReferencedClassName(String i_className) {
        this.i_referencedClassNames.remove(i_className);
    }

    protected boolean i_addReferencedClassName(String i_className) {
        if (this.i_scannedClassNames.containsKey(i_className)) {
            return false;
        }
        if (this.i_unresolvedClassNames.containsKey(i_className)) {
            return false;
        }
        return this.i_referencedClassNames.put(i_className, i_className) == null;
    }

    public Set<String> getReferencedClassNames() {
        this.scanReferenceClasses();
        Set<String> i_retrievedClassNames = this.i_referencedClassNames.keySet();
        this.i_referencedClassNames = new IdentityHashMap<String, String>();
        return i_retrievedClassNames;
    }

    public Set<String> getUnresolvedClassNames() {
        this.scanReferenceClasses();
        return this.i_unresolvedClassNames.keySet();
    }

    protected boolean i_addUnresolvedClassName(String i_className) {
        return this.i_unresolvedClassNames.put(i_className, i_className) == null;
    }

    protected boolean i_placeClass(String i_classSourceName, String i_className) {
        return this.classSourceClassData.i_record(i_classSourceName, i_className);
    }

    protected UtilImpl_BidirectionalMap getClassSourceClassData() {
        return this.classSourceClassData;
    }

    public Set<String> getScannedClassNames(String classSourceName) {
        this.scanReferenceClasses();
        return this.getClassSourceClassData().selectHeldOf(classSourceName);
    }

    public String getClassClassSourceName(String className) {
        this.scanReferenceClasses();
        Set<String> classSourceNames = this.getClassSourceClassData().selectHoldersOf(className);
        Iterator<String> iterator = classSourceNames.iterator();
        if (iterator.hasNext()) {
            String classSourceName = iterator.next();
            return classSourceName;
        }
        return null;
    }

    @Override
    public Set<String> getAnnotatedPackages() {
        this.scanDirectClasses();
        return this.seedData.getAnnotatedTargets(AnnotationTargets_Targets.AnnotationCategory.PACKAGE);
    }

    @Override
    public Set<String> getAnnotatedPackages(String annotationName) {
        this.scanDirectClasses();
        return this.seedData.getAnnotatedTargets(annotationName, AnnotationTargets_Targets.AnnotationCategory.PACKAGE);
    }

    @Override
    public Set<String> getPackageAnnotations() {
        this.scanDirectClasses();
        return this.seedData.getAnnotations(AnnotationTargets_Targets.AnnotationCategory.PACKAGE);
    }

    @Override
    public Set<String> getPackageAnnotations(String packageName) {
        this.scanDirectClasses();
        return this.seedData.getAnnotations(packageName, AnnotationTargets_Targets.AnnotationCategory.PACKAGE);
    }

    @Override
    public Set<String> getAnnotatedClasses() {
        this.scanDirectClasses();
        return this.seedData.getAnnotatedTargets(AnnotationTargets_Targets.AnnotationCategory.CLASS);
    }

    @Override
    public Set<String> getAnnotatedClasses(String annotationName) {
        this.scanDirectClasses();
        return this.seedData.getAnnotatedTargets(annotationName, AnnotationTargets_Targets.AnnotationCategory.CLASS);
    }

    @Override
    public Set<String> getClassAnnotations() {
        this.scanDirectClasses();
        return this.seedData.getAnnotations(AnnotationTargets_Targets.AnnotationCategory.CLASS);
    }

    @Override
    public Set<String> getClassAnnotations(String className) {
        this.scanDirectClasses();
        return this.seedData.getAnnotations(className, AnnotationTargets_Targets.AnnotationCategory.CLASS);
    }

    public Set<String> getClassesWithFieldAnnotations() {
        this.scanDirectClasses();
        return this.seedData.getAnnotatedTargets(AnnotationTargets_Targets.AnnotationCategory.FIELD);
    }

    @Override
    public Set<String> getClassesWithFieldAnnotation(String annotationName) {
        this.scanDirectClasses();
        return this.seedData.getAnnotatedTargets(annotationName, AnnotationTargets_Targets.AnnotationCategory.FIELD);
    }

    @Override
    public Set<String> getFieldAnnotations() {
        this.scanDirectClasses();
        return this.seedData.getAnnotations(AnnotationTargets_Targets.AnnotationCategory.FIELD);
    }

    @Override
    public Set<String> getFieldAnnotations(String className) {
        this.scanDirectClasses();
        return this.seedData.getAnnotations(className, AnnotationTargets_Targets.AnnotationCategory.FIELD);
    }

    public Set<String> getClassesWithMethodAnnotations() {
        this.scanDirectClasses();
        return this.seedData.getAnnotatedTargets(AnnotationTargets_Targets.AnnotationCategory.METHOD);
    }

    @Override
    public Set<String> getClassesWithMethodAnnotation(String annotationName) {
        this.scanDirectClasses();
        return this.seedData.getAnnotatedTargets(annotationName, AnnotationTargets_Targets.AnnotationCategory.METHOD);
    }

    @Override
    public Set<String> getMethodAnnotations() {
        this.scanDirectClasses();
        return this.seedData.getAnnotations(AnnotationTargets_Targets.AnnotationCategory.METHOD);
    }

    @Override
    public Set<String> getMethodAnnotations(String className) {
        this.scanDirectClasses();
        return this.seedData.getAnnotations(className, AnnotationTargets_Targets.AnnotationCategory.METHOD);
    }

    @Override
    public Set<String> getAnnotatedPackages(int scanPolicies) {
        return this.selectAnnotatedTargets(scanPolicies, AnnotationTargets_Targets.AnnotationCategory.PACKAGE);
    }

    @Override
    public Set<String> getAnnotatedPackages(String annotationName, int scanPolicies) {
        return this.selectAnnotatedTargets(annotationName, scanPolicies, AnnotationTargets_Targets.AnnotationCategory.PACKAGE);
    }

    @Override
    public Set<String> getPackageAnnotations(int scanPolicies) {
        return this.selectAnnotations(scanPolicies, AnnotationTargets_Targets.AnnotationCategory.PACKAGE);
    }

    @Override
    public Set<String> getPackageAnnotations(String packageName, int scanPolicies) {
        return this.selectAnnotations(packageName, scanPolicies, AnnotationTargets_Targets.AnnotationCategory.PACKAGE);
    }

    @Override
    public Set<String> getAnnotatedClasses(int scanPolicies) {
        return this.selectAnnotatedTargets(scanPolicies, AnnotationTargets_Targets.AnnotationCategory.CLASS);
    }

    @Override
    public Set<String> getAnnotatedClasses(String annotationName, int scanPolicies) {
        return this.selectAnnotatedTargets(annotationName, scanPolicies, AnnotationTargets_Targets.AnnotationCategory.CLASS);
    }

    @Override
    public Set<String> getClassAnnotations(int scanPolicies) {
        return this.selectAnnotations(scanPolicies, AnnotationTargets_Targets.AnnotationCategory.CLASS);
    }

    @Override
    public Set<String> getClassAnnotations(String className, int scanPolicies) {
        return this.selectAnnotations(className, scanPolicies, AnnotationTargets_Targets.AnnotationCategory.CLASS);
    }

    @Override
    public Set<String> getClassesWithFieldAnnotations(int scanPolicies) {
        return this.selectAnnotatedTargets(scanPolicies, AnnotationTargets_Targets.AnnotationCategory.FIELD);
    }

    @Override
    public Set<String> getClassesWithFieldAnnotation(String annotationName, int scanPolicies) {
        return this.selectAnnotatedTargets(annotationName, scanPolicies, AnnotationTargets_Targets.AnnotationCategory.FIELD);
    }

    @Override
    public Set<String> getFieldAnnotations(int scanPolicies) {
        return this.selectAnnotations(scanPolicies, AnnotationTargets_Targets.AnnotationCategory.FIELD);
    }

    @Override
    public Set<String> getFieldAnnotations(String className, int scanPolicies) {
        return this.selectAnnotations(className, scanPolicies, AnnotationTargets_Targets.AnnotationCategory.FIELD);
    }

    @Override
    public Set<String> getClassesWithMethodAnnotations(int scanPolicies) {
        return this.selectAnnotatedTargets(scanPolicies, AnnotationTargets_Targets.AnnotationCategory.METHOD);
    }

    @Override
    public Set<String> getClassesWithMethodAnnotation(String annotationName, int scanPolicies) {
        return this.selectAnnotatedTargets(annotationName, scanPolicies, AnnotationTargets_Targets.AnnotationCategory.METHOD);
    }

    @Override
    public Set<String> getMethodAnnotations(int scanPolicies) {
        return this.selectAnnotations(scanPolicies, AnnotationTargets_Targets.AnnotationCategory.METHOD);
    }

    @Override
    public Set<String> getMethodAnnotations(String className, int scanPolicies) {
        return this.selectAnnotations(className, scanPolicies, AnnotationTargets_Targets.AnnotationCategory.METHOD);
    }

    @Override
    public Set<String> getAnnotatedClasses(String classSourceName, String annotationName) {
        Set<String> annotatedClassNames = this.getAnnotatedClasses(annotationName);
        Set<String> classSourceClassNames = this.getScannedClassNames(classSourceName);
        return this.restrict(annotatedClassNames, classSourceClassNames);
    }

    @Override
    public Set<String> getAnnotatedClasses(String classSourceName, String annotationName, int scanPolicies) {
        Set<String> annotatedClassNames = this.getAnnotatedClasses(annotationName, scanPolicies);
        Set<String> classSourceClassNames = this.getScannedClassNames(classSourceName);
        return this.restrict(annotatedClassNames, classSourceClassNames);
    }

    @Override
    public Set<String> getAllInheritedAnnotatedClasses(String annotationName) {
        this.scanDirectClasses();
        HashSet<String> allClassNames = new HashSet<String>();
        for (String className : this.getAnnotatedClasses(annotationName)) {
            allClassNames.add(className);
            allClassNames.addAll(this.getSubclassNames(className));
        }
        return allClassNames;
    }

    @Override
    public Set<String> getAllInheritedAnnotatedClasses(String annotationName, int scanResults) {
        return this.getAllInheritedAnnotatedClasses(annotationName, scanResults, scanResults);
    }

    @Override
    public Set<String> getAllInheritedAnnotatedClasses(String annotationName, int declarerScanPolicies, int inheritorScanPolicies) {
        this.scanDirectClasses();
        HashSet<String> allClassNames = new HashSet<String>();
        for (String className : this.getAnnotatedClasses(annotationName, declarerScanPolicies)) {
            allClassNames.add(className);
            allClassNames.addAll(this.getSubclassNames(className));
        }
        Set<String> regionClassNames = this.getClassNames(inheritorScanPolicies);
        return this.restrict(allClassNames, regionClassNames);
    }

    public String i_getSuperclassName(String i_subclassName) {
        return this.i_superclassNameMap.get(i_subclassName);
    }

    @Override
    public String getSuperclassName(String subclassName) {
        return this.i_getSuperclassName(this.internClassName(subclassName));
    }

    public Map<String, String> getSuperclassNames() {
        this.scanReferenceClasses();
        return this.i_superclassNameMap;
    }

    protected void i_setSuperclassName(String i_subclassName, String i_superclassName) {
        this.i_superclassNameMap.put(i_subclassName, i_superclassName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Subclass [ {1} ] has superclass [ {2} ]", this.getHashText(), i_subclassName, i_superclassName), (Object[])new Object[0]);
        }
    }

    protected String[] i_getInterfaceNames(String i_classOrInterfaceName) {
        return this.i_interfaceNameMap.get(i_classOrInterfaceName);
    }

    public String[] getInterfaceNames(String classOrInterfaceName) {
        this.scanReferenceClasses();
        return this.i_getInterfaceNames(this.internClassName(classOrInterfaceName));
    }

    public Map<String, String[]> getInterfaceNames() {
        this.scanReferenceClasses();
        return this.i_interfaceNameMap;
    }

    protected void i_setInterfaceNames(String i_classOrInterfaceName, String[] i_interfaceNames) {
        this.i_interfaceNameMap.put(i_classOrInterfaceName, i_interfaceNames);
        if (tc.isDebugEnabled()) {
            for (String i_interfaceName : i_interfaceNames) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Child [ {1} ] has interface [ {2} ]", this.getHashText(), i_classOrInterfaceName, i_interfaceName), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public Set<String> getAllImplementorsOf(String interfaceName) {
        Set<String> result;
        this.scanReferenceClasses();
        String i_interfaceName = this.getClassInternMap().intern(interfaceName, false);
        if (i_interfaceName == null) {
            return UtilImpl_EmptyStringSet.INSTANCE;
        }
        if (this.i_allImplementersMap == null) {
            this.createAllImplementersMap();
        }
        if ((result = this.i_allImplementersMap.get(i_interfaceName)) == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    protected void createAllImplementersMap() {
        UtilImpl_InternMap useClassNameMap = this.getClassInternMap();
        UtilImpl_Factory useUtilFactory = useClassNameMap.getFactory();
        this.i_allImplementersMap = new IdentityHashMap();
        Iterator<String> iterator = this.i_scannedClassNames.keySet().iterator();
        while (iterator.hasNext()) {
            String i_implementerName;
            String i_nextImplementsSource = i_implementerName = iterator.next();
            while (i_nextImplementsSource != null) {
                String[] i_immediateImplements = this.i_interfaceNameMap.get(i_nextImplementsSource);
                if (i_immediateImplements != null) {
                    for (String i_immediateImplement : i_immediateImplements) {
                        Set<String> implementers = this.i_allImplementersMap.get(i_immediateImplement);
                        if (implementers == null) {
                            implementers = useUtilFactory.createIdentityStringSet();
                            this.i_allImplementersMap.put(i_immediateImplement, implementers);
                        }
                        implementers.add(i_implementerName);
                    }
                }
                i_nextImplementsSource = this.i_superclassNameMap.get(i_nextImplementsSource);
            }
        }
    }

    @Override
    public Set<String> getSubclassNames(String superclassName) {
        Set<String> result;
        this.scanReferenceClasses();
        String i_superclassName = this.getClassInternMap().intern(superclassName, false);
        if (i_superclassName == null) {
            return UtilImpl_EmptyStringSet.INSTANCE;
        }
        if (this.i_descendantsMap == null) {
            this.createDescendantsMap();
        }
        if ((result = this.i_descendantsMap.get(i_superclassName)) == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    protected void createDescendantsMap() {
        UtilImpl_InternMap useClassNameMap = this.getClassInternMap();
        UtilImpl_Factory useUtilFactory = useClassNameMap.getFactory();
        this.i_descendantsMap = new IdentityHashMap();
        Iterator<String> iterator = this.i_superclassNameMap.keySet().iterator();
        while (iterator.hasNext()) {
            String i_subclassName;
            String i_superclassName = i_subclassName = iterator.next();
            while ((i_superclassName = this.i_superclassNameMap.get(i_superclassName)) != null) {
                Set<String> subclasses = this.i_descendantsMap.get(i_superclassName);
                if (subclasses == null) {
                    subclasses = useUtilFactory.createIdentityStringSet();
                    this.i_descendantsMap.put(i_superclassName, subclasses);
                }
                subclasses.add(i_subclassName);
            }
        }
    }

    public void logState() {
        TraceComponent stateLogger = AnnotationServiceImpl_Logging.stateLogger;
        if (stateLogger.isDebugEnabled()) {
            this.log(stateLogger);
        }
    }

    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("BEGIN STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Is Detail Enabled [ {0} ]", this.getIsDetailEnabled()), (Object[])new Object[0]);
        this.logScannedClasses(logger);
        this.logClassClassSources(logger);
        this.logSuperclassNames(logger);
        this.logInterfaceNames(logger);
        this.logUnresolvedPackages(logger);
        this.logUnresolvedClasses(logger);
        this.seedData.log(logger);
        this.partialData.log(logger);
        this.excludedData.log(logger);
        this.externalData.log(logger);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("END STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    public void logScannedClasses(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"Scanned classes: BEGIN", (Object[])new Object[0]);
        for (String className : this.getScannedClassNames()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  [ {0} ]", className), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Scanned classes: END", (Object[])new Object[0]);
    }

    public void logClassClassSources(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"Class Class Sources: BEGIN", (Object[])new Object[0]);
        for (String className : this.getScannedClassNames()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  [ {0} ]: [ {1} ]", className, this.getClassClassSourceName(className)), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Class Class Sources: END", (Object[])new Object[0]);
    }

    public void logSuperclassNames(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"Superclasses: BEGIN", (Object[])new Object[0]);
        Object[] logParms = new Object[]{null, null};
        Map<Object, Object> mapToIterate = this.i_superclassNameMap == null ? Collections.emptyMap() : this.i_superclassNameMap;
        for (Map.Entry<Object, Object> superclassNameEntry : mapToIterate.entrySet()) {
            String subclassName = (String)superclassNameEntry.getKey();
            String superclassName = (String)superclassNameEntry.getValue();
            logParms[0] = subclassName;
            logParms[1] = superclassName;
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Subclass [ {0} ] Superclass [ {1} ]", logParms), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Superclasses: END", (Object[])new Object[0]);
    }

    public void logInterfaceNames(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"Interfaces: BEGIN", (Object[])new Object[0]);
        Object[] logParms = new Object[]{null, null};
        Map<Object, Object> mapToIterate = this.i_interfaceNameMap == null ? Collections.emptyMap() : this.i_interfaceNameMap;
        for (Map.Entry<Object, Object> interfaceNamesEntry : mapToIterate.entrySet()) {
            String childName = (String)interfaceNamesEntry.getKey();
            String[] interfaceNames = (String[])interfaceNamesEntry.getValue();
            logParms[0] = childName;
            logParms[1] = interfaceNames;
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Child [ {0} ] Interfaces [ {1} ]", logParms), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Interfaces: END", (Object[])new Object[0]);
    }

    public void logUnresolvedPackages(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"Unresolved packages: BEGIN", (Object[])new Object[0]);
        for (String packageName : this.getUnresolvedPackageNames()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  [ {0} ]", packageName), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Unresolved packages: END", (Object[])new Object[0]);
    }

    public void logUnresolvedClasses(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"Unresolved classes: BEGIN", (Object[])new Object[0]);
        for (String className : this.getUnresolvedClassNames()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  [ {0} ]", className), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Unresolved classes: END", (Object[])new Object[0]);
    }

    protected Set<String> restrict(Set<String> candidates, Set<String> allowed) {
        if (candidates == null || allowed == null || candidates.isEmpty() || allowed.isEmpty()) {
            return UtilImpl_EmptyStringSet.INSTANCE;
        }
        HashSet<String> restrictedSet = new HashSet<String>();
        for (String candidate : candidates) {
            if (!allowed.contains(candidate)) continue;
            restrictedSet.add(candidate);
        }
        return restrictedSet;
    }

    @Override
    public boolean isInstanceOf(String className, Class<?> clazz) {
        this.scanReferenceClasses();
        String clazzName = this.internClassName(clazz.getName(), false);
        className = this.internClassName(className, false);
        if (clazzName == null || className == null) {
            return false;
        }
        if (className == clazzName) {
            return true;
        }
        String intfName = null;
        if (clazz.isInterface()) {
            intfName = clazzName;
            clazzName = null;
        }
        while (className != null) {
            if (intfName != null) {
                String[] interfaces = this.i_getInterfaceNames(className);
                if (interfaces != null) {
                    for (String intrface : interfaces) {
                        if (intfName != intrface) continue;
                        return true;
                    }
                }
            } else if (className == clazzName) {
                return true;
            }
            className = this.getSuperclassName(className);
        }
        return false;
    }

    protected void i_recordAnnotation(ClassSource_Aggregate.ScanPolicy policy, AnnotationTargets_Targets.AnnotationCategory category, String i_targetName, String i_annotationClassName) {
        UtilImpl_BidirectionalMap annoMap = this.doGetAnnotationsMap(policy, category);
        annoMap.record(i_targetName, i_annotationClassName);
        this.i_addReferencedClassName(i_annotationClassName);
    }

    @Override
    public boolean getIsDetailEnabled() {
        return this.isDetailEnabled;
    }

    protected AnnotationTargetsImpl_PolicyData getPolicyData(ClassSource_Aggregate.ScanPolicy policy) {
        if (policy == ClassSource_Aggregate.ScanPolicy.SEED) {
            this.scanDirectClasses();
            return this.seedData;
        }
        if (policy == ClassSource_Aggregate.ScanPolicy.PARTIAL) {
            this.scanDirectClasses();
            return this.partialData;
        }
        if (policy == ClassSource_Aggregate.ScanPolicy.EXCLUDED) {
            this.scanDirectClasses();
            return this.excludedData;
        }
        if (policy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
            this.scanReferenceClasses();
            return this.externalData;
        }
        throw new IllegalArgumentException("Policy [ " + (Object)((Object)policy) + " ]");
    }

    protected AnnotationTargetsImpl_PolicyData doGetPolicyData(ClassSource_Aggregate.ScanPolicy policy) {
        if (policy == ClassSource_Aggregate.ScanPolicy.SEED) {
            return this.seedData;
        }
        if (policy == ClassSource_Aggregate.ScanPolicy.PARTIAL) {
            return this.partialData;
        }
        if (policy == ClassSource_Aggregate.ScanPolicy.EXCLUDED) {
            return this.excludedData;
        }
        if (policy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
            return this.externalData;
        }
        throw new IllegalArgumentException("Policy [ " + (Object)((Object)policy) + " ]");
    }

    public UtilImpl_BidirectionalMap getPackageAnnotationData() {
        return this.getAnnotationsMap(ClassSource_Aggregate.ScanPolicy.SEED, AnnotationTargets_Targets.AnnotationCategory.PACKAGE);
    }

    public UtilImpl_BidirectionalMap getClassAnnotationData() {
        return this.getAnnotationsMap(ClassSource_Aggregate.ScanPolicy.SEED, AnnotationTargets_Targets.AnnotationCategory.CLASS);
    }

    public UtilImpl_BidirectionalMap getFieldAnnotationData() {
        return this.getAnnotationsMap(ClassSource_Aggregate.ScanPolicy.SEED, AnnotationTargets_Targets.AnnotationCategory.FIELD);
    }

    public UtilImpl_BidirectionalMap getMethodAnnotationData() {
        return this.getAnnotationsMap(ClassSource_Aggregate.ScanPolicy.SEED, AnnotationTargets_Targets.AnnotationCategory.METHOD);
    }

    protected UtilImpl_BidirectionalMap getAnnotationsMap(ClassSource_Aggregate.ScanPolicy policy, AnnotationTargets_Targets.AnnotationCategory category) {
        return this.getPolicyData(policy).getTargetData(category);
    }

    protected UtilImpl_BidirectionalMap doGetAnnotationsMap(ClassSource_Aggregate.ScanPolicy policy, AnnotationTargets_Targets.AnnotationCategory category) {
        return this.doGetPolicyData(policy).getTargetData(category);
    }

    protected Set<String> selectAnnotations(int scanPolicies, AnnotationTargets_Targets.AnnotationCategory category) {
        Set<String> selected_EXTERNAL;
        Set<String> selected_EXCLUDED;
        Set<String> selected_PARTIAL;
        Set<String> selected_SEED;
        int nonEmptyCount = 0;
        if (ClassSource_Aggregate.ScanPolicy.SEED.accept(scanPolicies)) {
            selected_SEED = this.seedData.getAnnotations(category);
            if (selected_SEED.isEmpty()) {
                selected_SEED = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_SEED = null;
        }
        if (ClassSource_Aggregate.ScanPolicy.PARTIAL.accept(scanPolicies)) {
            selected_PARTIAL = this.partialData.getAnnotations(category);
            if (selected_PARTIAL.isEmpty()) {
                selected_PARTIAL = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_PARTIAL = null;
        }
        if (ClassSource_Aggregate.ScanPolicy.EXCLUDED.accept(scanPolicies)) {
            selected_EXCLUDED = this.excludedData.getAnnotations(category);
            if (selected_EXCLUDED.isEmpty()) {
                selected_EXCLUDED = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_EXCLUDED = null;
        }
        if (ClassSource_Aggregate.ScanPolicy.EXTERNAL.accept(scanPolicies)) {
            selected_EXTERNAL = this.externalData.getAnnotations(category);
            if (selected_EXTERNAL.isEmpty()) {
                selected_EXTERNAL = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_EXTERNAL = null;
        }
        if (nonEmptyCount == 0) {
            return Collections.emptySet();
        }
        if (nonEmptyCount == 1) {
            if (selected_SEED != null) {
                return selected_SEED;
            }
            if (selected_PARTIAL != null) {
                return selected_PARTIAL;
            }
            if (selected_EXCLUDED != null) {
                return selected_EXCLUDED;
            }
            return selected_EXTERNAL;
        }
        HashSet<String> result = new HashSet<String>();
        if (selected_SEED != null) {
            result.addAll(selected_SEED);
        }
        if (selected_PARTIAL != null) {
            result.addAll(selected_PARTIAL);
        }
        if (selected_EXCLUDED != null) {
            result.addAll(selected_EXCLUDED);
        }
        if (selected_EXTERNAL != null) {
            result.addAll(selected_EXTERNAL);
        }
        return result;
    }

    protected Set<String> selectAnnotations(String targetName, int scanPolicies, AnnotationTargets_Targets.AnnotationCategory category) {
        Set<String> selected;
        if (ClassSource_Aggregate.ScanPolicy.SEED.accept(scanPolicies) && !(selected = this.seedData.getAnnotations(targetName, category)).isEmpty()) {
            return selected;
        }
        if (ClassSource_Aggregate.ScanPolicy.PARTIAL.accept(scanPolicies) && !(selected = this.partialData.getAnnotations(targetName, category)).isEmpty()) {
            return selected;
        }
        if (ClassSource_Aggregate.ScanPolicy.EXCLUDED.accept(scanPolicies) && !(selected = this.excludedData.getAnnotations(targetName, category)).isEmpty()) {
            return selected;
        }
        if (ClassSource_Aggregate.ScanPolicy.EXTERNAL.accept(scanPolicies) && !(selected = this.externalData.getAnnotations(targetName, category)).isEmpty()) {
            return selected;
        }
        return Collections.emptySet();
    }

    protected Set<String> selectAnnotatedTargets(int scanPolicies, AnnotationTargets_Targets.AnnotationCategory category) {
        Set<String> selected_EXTERNAL;
        Set<String> selected_EXCLUDED;
        Set<String> selected_PARTIAL;
        Set<String> selected_SEED;
        this.scanDirectClasses();
        int nonEmptyCount = 0;
        if (ClassSource_Aggregate.ScanPolicy.SEED.accept(scanPolicies)) {
            selected_SEED = this.seedData.getAnnotatedTargets(category);
            if (selected_SEED.isEmpty()) {
                selected_SEED = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_SEED = null;
        }
        if (ClassSource_Aggregate.ScanPolicy.PARTIAL.accept(scanPolicies)) {
            selected_PARTIAL = this.partialData.getAnnotatedTargets(category);
            if (selected_PARTIAL.isEmpty()) {
                selected_PARTIAL = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_PARTIAL = null;
        }
        if (ClassSource_Aggregate.ScanPolicy.EXCLUDED.accept(scanPolicies)) {
            selected_EXCLUDED = this.excludedData.getAnnotatedTargets(category);
            if (selected_EXCLUDED.isEmpty()) {
                selected_EXCLUDED = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_EXCLUDED = null;
        }
        if (ClassSource_Aggregate.ScanPolicy.EXTERNAL.accept(scanPolicies)) {
            selected_EXTERNAL = this.externalData.getAnnotatedTargets(category);
            if (selected_EXTERNAL.isEmpty()) {
                selected_EXTERNAL = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_EXTERNAL = null;
        }
        if (nonEmptyCount == 0) {
            return Collections.emptySet();
        }
        if (nonEmptyCount == 1) {
            if (selected_SEED != null) {
                return selected_SEED;
            }
            if (selected_PARTIAL != null) {
                return selected_PARTIAL;
            }
            if (selected_EXCLUDED != null) {
                return selected_EXCLUDED;
            }
            return selected_EXTERNAL;
        }
        HashSet<String> result = new HashSet<String>();
        if (selected_SEED != null) {
            result.addAll(selected_SEED);
        }
        if (selected_PARTIAL != null) {
            result.addAll(selected_PARTIAL);
        }
        if (selected_EXCLUDED != null) {
            result.addAll(selected_EXCLUDED);
        }
        if (selected_EXTERNAL != null) {
            result.addAll(selected_EXTERNAL);
        }
        return result;
    }

    protected Set<String> selectAnnotatedTargets(String annotationName, int scanPolicies, AnnotationTargets_Targets.AnnotationCategory category) {
        Set<String> selected_EXTERNAL;
        Set<String> selected_EXCLUDED;
        Set<String> selected_PARTIAL;
        Set<String> selected_SEED;
        if (ClassSource_Aggregate.ScanPolicy.EXTERNAL.accept(scanPolicies)) {
            this.scanReferenceClasses();
        } else if ((scanPolicies | AnnotationTargets_Targets.POLICY_ALL_EXCEPT_EXTERNAL) != 0) {
            this.scanDirectClasses();
        } else {
            return Collections.emptySet();
        }
        int nonEmptyCount = 0;
        if (ClassSource_Aggregate.ScanPolicy.SEED.accept(scanPolicies)) {
            selected_SEED = this.seedData.getAnnotatedTargets(annotationName, category);
            if (selected_SEED.isEmpty()) {
                selected_SEED = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_SEED = null;
        }
        if (ClassSource_Aggregate.ScanPolicy.PARTIAL.accept(scanPolicies)) {
            selected_PARTIAL = this.partialData.getAnnotatedTargets(annotationName, category);
            if (selected_PARTIAL.isEmpty()) {
                selected_PARTIAL = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_PARTIAL = null;
        }
        if (ClassSource_Aggregate.ScanPolicy.EXCLUDED.accept(scanPolicies)) {
            selected_EXCLUDED = this.excludedData.getAnnotatedTargets(annotationName, category);
            if (selected_EXCLUDED.isEmpty()) {
                selected_EXCLUDED = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_EXCLUDED = null;
        }
        if (ClassSource_Aggregate.ScanPolicy.EXTERNAL.accept(scanPolicies)) {
            selected_EXTERNAL = this.externalData.getAnnotatedTargets(annotationName, category);
            if (selected_EXTERNAL.isEmpty()) {
                selected_EXTERNAL = null;
            } else {
                ++nonEmptyCount;
            }
        } else {
            selected_EXTERNAL = null;
        }
        if (nonEmptyCount == 0) {
            return Collections.emptySet();
        }
        if (nonEmptyCount == 1) {
            if (selected_SEED != null) {
                return selected_SEED;
            }
            if (selected_PARTIAL != null) {
                return selected_PARTIAL;
            }
            if (selected_EXCLUDED != null) {
                return selected_EXCLUDED;
            }
            return selected_EXTERNAL;
        }
        HashSet<String> result = new HashSet<String>();
        if (selected_SEED != null) {
            result.addAll(selected_SEED);
        }
        if (selected_PARTIAL != null) {
            result.addAll(selected_PARTIAL);
        }
        if (selected_EXCLUDED != null) {
            result.addAll(selected_EXCLUDED);
        }
        if (selected_EXTERNAL != null) {
            result.addAll(selected_EXTERNAL);
        }
        return result;
    }

    protected Set<String> selectClassNames(int scanPolicies) {
        Set<String> external;
        Set<String> excluded;
        Set<String> partial;
        Set<String> seed;
        int nonEmptyCount = 0;
        if (!ClassSource_Aggregate.ScanPolicy.SEED.accept(scanPolicies)) {
            seed = null;
        } else {
            seed = this.seedData.getClassNames();
            if (seed.isEmpty()) {
                seed = null;
            } else {
                ++nonEmptyCount;
            }
        }
        if (!ClassSource_Aggregate.ScanPolicy.PARTIAL.accept(scanPolicies)) {
            partial = null;
        } else {
            partial = this.partialData.getClassNames();
            if (partial.isEmpty()) {
                partial = null;
            } else {
                ++nonEmptyCount;
            }
        }
        if (!ClassSource_Aggregate.ScanPolicy.PARTIAL.accept(scanPolicies)) {
            excluded = null;
        } else {
            excluded = this.excludedData.getClassNames();
            if (excluded.isEmpty()) {
                excluded = null;
            } else {
                ++nonEmptyCount;
            }
        }
        if (!ClassSource_Aggregate.ScanPolicy.PARTIAL.accept(scanPolicies)) {
            external = null;
        } else {
            external = this.externalData.getClassNames();
            if (external.isEmpty()) {
                external = null;
            } else {
                ++nonEmptyCount;
            }
        }
        if (nonEmptyCount == 0) {
            return Collections.emptySet();
        }
        if (nonEmptyCount == 1) {
            if (seed != null) {
                return seed;
            }
            if (partial != null) {
                return partial;
            }
            if (excluded != null) {
                return excluded;
            }
            return external;
        }
        HashSet<String> result = new HashSet<String>();
        if (seed != null) {
            result.addAll(seed);
        }
        if (partial != null) {
            result.addAll(partial);
        }
        if (excluded != null) {
            result.addAll(excluded);
        }
        if (external != null) {
            result.addAll(external);
        }
        return result;
    }
}

