/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.equinox.module;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ModuleLocationUtils {
    private static final String BUNDLE_PROPERTY_ENTRY_NAME = "LooseBundleProps.properties";
    private static final String BUNDLE_LOCATION = "bundleLocation";
    static final long serialVersionUID = 2046061198729021209L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={IOException.class})
    public static String getLocationFromBundleFile(BundleFile bundleFile) {
        BundleEntry be = bundleFile.getEntry(BUNDLE_PROPERTY_ENTRY_NAME);
        if (be != null) {
            Properties p = new Properties();
            try {
                p.load(be.getInputStream());
                return p.getProperty(BUNDLE_LOCATION);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static InputStream getInputStreamForLooseModule(String location) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jos = new JarOutputStream(baos);
        ZipEntry looseBundlePropsEntry = new ZipEntry(BUNDLE_PROPERTY_ENTRY_NAME);
        jos.putNextEntry(looseBundlePropsEntry);
        Properties looseProps = new Properties();
        looseProps.setProperty(BUNDLE_LOCATION, location);
        looseProps.store(jos, "LooseBundle");
        jos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ModuleLocationUtils.class);
    }
}

