/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchIllegalJobStatusTransitionException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.persistence.jpa.RemotableSplitFlowEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotableSplitFlowKey;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepExecutionEntity;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractPersistenceManager
implements IPersistenceManagerService {
    public static List<BatchStatus> RUNNING_STATUSES;
    public static List<BatchStatus> FINAL_STATUSES;
    public static Set<BatchStatus> FINAL_STATUS_SET;
    static final long serialVersionUID = 4702669060504424236L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public String getDisplayId() {
        return null;
    }

    @Override
    public long getJobInstanceIdFromExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        return this.getJobInstanceFromExecutionId(jobExecutionId).getInstanceId();
    }

    @Override
    public String getJobInstanceAppName(long jobInstanceId) throws NoSuchJobInstanceException {
        return this.getJobInstance(jobInstanceId).getAmcName();
    }

    @Override
    public String getJobInstanceAppNameFromExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        return this.getJobInstanceFromExecutionId(jobExecutionId).getAmcName();
    }

    @Override
    public String getJobInstanceSubmitter(long jobInstanceId) throws NoSuchJobInstanceException {
        return this.getJobInstance(jobInstanceId).getSubmitter();
    }

    @Override
    public boolean isJobInstancePurgeable(long jobInstanceId) {
        InstanceState instanceState = this.getJobInstance(jobInstanceId).getInstanceState();
        return !instanceState.equals((Object)InstanceState.SUBMITTED) && !instanceState.equals((Object)InstanceState.JMS_QUEUED) && !instanceState.equals((Object)InstanceState.JMS_CONSUMED) && !instanceState.equals((Object)InstanceState.DISPATCHED);
    }

    @Override
    public JobExecutionEntity getJobExecutionMostRecent(long jobInstanceId) throws IllegalStateException, NoSuchJobInstanceException {
        List<JobExecutionEntity> executions = this.getJobExecutionsFromJobInstanceId(jobInstanceId);
        if (executions == null || executions.size() == 0) {
            throw new IllegalStateException("Did not find any executions associated with instance id: " + jobInstanceId);
        }
        return executions.get(0);
    }

    @Override
    public long getJobExecutionIdMostRecent(long jobInstanceId) {
        return this.getJobExecutionMostRecent(jobInstanceId).getExecutionId();
    }

    @Override
    public Properties getJobExecutionParameters(long jobExecutionId) throws NoSuchJobExecutionException {
        return this.getJobExecution(jobExecutionId).getJobParameters();
    }

    @Override
    public TopLevelStepExecutionEntity getStepExecutionTopLevel(long stepExecutionId) throws IllegalArgumentException {
        StepThreadExecutionEntity stepExec = this.getStepThreadExecution(stepExecutionId);
        if (stepExec == null) {
            throw new IllegalArgumentException("No top-level step thread execution found for key = " + stepExecutionId);
        }
        try {
            TopLevelStepExecutionEntity topLevelStepExec = (TopLevelStepExecutionEntity)stepExec;
            return topLevelStepExec;
        }
        catch (ClassCastException topLevelStepExec) {
            FFDCFilter.processException((Throwable)topLevelStepExec, (String)"com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", (String)"175", (Object)this, (Object[])new Object[]{stepExecutionId});
            throw new IllegalArgumentException("Found step thread execution found for key = " + stepExecutionId + ", but it was a partition-level step thread, not a top-level execution");
        }
    }

    protected abstract StepThreadExecutionEntity getStepThreadExecution(long var1);

    @Override
    public List<WSStepThreadExecutionAggregate> getStepExecutionAggregatesFromJobExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        ArrayList<WSStepThreadExecutionAggregate> retVal = new ArrayList<WSStepThreadExecutionAggregate>();
        List<StepExecution> topLevelStepExecutions = this.getStepExecutionsTopLevelFromJobExecutionId(jobExecutionId);
        for (StepExecution stepExec : topLevelStepExecutions) {
            retVal.add(this.getStepExecutionAggregate(stepExec.getStepExecutionId()));
        }
        return retVal;
    }

    protected byte[] serializeObject(Serializable theObject) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(theObject);
        byte[] data = baos.toByteArray();
        baos.close();
        oout.close();
        return data;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateStepExecutionStatusTimeStampsUserDataAndMetrics(StepThreadExecutionEntity stepExec, RuntimeStepExecution runtimeStepExecution) {
        stepExec.setBatchStatus(runtimeStepExecution.getBatchStatus());
        stepExec.setExitStatus(runtimeStepExecution.getExitStatus());
        stepExec.setStepName(runtimeStepExecution.getStepName());
        stepExec.setStartTime(runtimeStepExecution.getStartTime());
        stepExec.setEndTime(runtimeStepExecution.getEndTime());
        try {
            stepExec.setPersistentUserDataBytes(this.serializeObject(runtimeStepExecution.getPersistentUserDataObject()));
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", (String)"231", (Object)this, (Object[])new Object[]{stepExec, runtimeStepExecution});
            throw new PersistenceException((Throwable)e);
        }
        this.updateStepExecutionMetrics(stepExec, runtimeStepExecution.getMetrics());
        stepExec.getJobExecution().setLastUpdatedTime(runtimeStepExecution.getLastUpdatedTime());
    }

    private void updateStepExecutionMetrics(StepThreadExecutionEntity stepData, List<Metric> metrics) {
        for (int i = 0; i < metrics.size(); ++i) {
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                stepData.setReadCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                stepData.setWriteCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                stepData.setProcessSkipCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                stepData.setCommitCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                stepData.setRollbackCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                stepData.setReadSkipCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                stepData.setFilterCount(metrics.get(i).getValue());
                continue;
            }
            if (!metrics.get(i).getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            stepData.setWriteSkipCount(metrics.get(i).getValue());
        }
    }

    @Override
    public RemotableSplitFlowEntity createSplitFlowExecution(RemotableSplitFlowKey splitFlowKey, Date createTime) {
        return null;
    }

    @Override
    public RemotableSplitFlowEntity updateSplitFlowExecution(RuntimeSplitFlowExecution runtimeSplitFlowExecution, BatchStatus newBatchStatus, Date date) {
        return null;
    }

    @Override
    public RemotableSplitFlowEntity updateSplitFlowExecutionLogDir(RemotableSplitFlowKey key, String logDirPath) {
        return null;
    }

    @Override
    public RemotablePartitionEntity createPartitionExecution(RemotablePartitionKey partitionKey, Date createTime) {
        return null;
    }

    @Override
    public RemotablePartitionEntity updatePartitionExecution(RuntimePartitionExecution runtimePartitionExecution, BatchStatus newBatchStatus, Date date) {
        return null;
    }

    @Override
    public RemotablePartitionEntity updatePartitionExecutionLogDir(RemotablePartitionKey key, String logDirPath) {
        return null;
    }

    protected void verifyStatusTransitionIsValid(JobExecutionEntity exec, BatchStatus toStatus) throws BatchIllegalJobStatusTransitionException {
        switch (exec.getBatchStatus()) {
            case COMPLETED: {
                if (toStatus == BatchStatus.ABANDONED) break;
            }
            case ABANDONED: {
                throw new BatchIllegalJobStatusTransitionException("Job execution: " + exec.getExecutionId() + " cannot be transitioned from Batch Status: " + exec.getBatchStatus().name() + " to " + toStatus.name());
            }
        }
    }

    protected void verifyStatusTransitionIsValid(JobInstanceEntity instance, BatchStatus toStatus) throws BatchIllegalJobStatusTransitionException {
        switch (instance.getBatchStatus()) {
            case COMPLETED: {
                if (toStatus == BatchStatus.ABANDONED) break;
            }
            case ABANDONED: {
                throw new BatchIllegalJobStatusTransitionException("Job instance: " + instance.getInstanceId() + " cannot be transitioned from Batch Status: " + instance.getBatchStatus().name() + " to " + toStatus.name());
            }
        }
    }

    protected void verifyThreadStatusTransitionIsValid(StepThreadExecutionEntity stepExec, BatchStatus toStatus) throws BatchIllegalJobStatusTransitionException {
        switch (stepExec.getBatchStatus()) {
            case COMPLETED: {
                if (toStatus == BatchStatus.ABANDONED) break;
            }
            case ABANDONED: {
                throw new BatchIllegalJobStatusTransitionException("Job Step Thread execution: " + stepExec.getStepExecutionId() + " cannot be transitioned from Batch Status: " + stepExec.getBatchStatus().name() + " to " + toStatus.name());
            }
        }
    }

    protected void verifyStateTransitionIsValid(JobInstanceEntity jobInstance, InstanceState toState) throws BatchIllegalJobStatusTransitionException {
        switch (jobInstance.getInstanceState()) {
            case COMPLETED: {
                if (toState == InstanceState.ABANDONED) break;
            }
            case ABANDONED: {
                throw new BatchIllegalJobStatusTransitionException("Job Instance: " + jobInstance.getInstanceId() + " cannot be transitioned from Instance State: " + jobInstance.getInstanceState().name() + " to " + toState.name());
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AbstractPersistenceManager.class);
        RUNNING_STATUSES = Collections.unmodifiableList(Arrays.asList(BatchStatus.STARTED, BatchStatus.STARTING, BatchStatus.STOPPING));
        FINAL_STATUSES = Arrays.asList(BatchStatus.STOPPED, BatchStatus.ABANDONED, BatchStatus.FAILED, BatchStatus.COMPLETED);
        FINAL_STATUS_SET = Collections.unmodifiableSet(new HashSet<BatchStatus>(FINAL_STATUSES));
    }
}

