/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IBatchThreadPoolService;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class AbstractThreadPoolServiceImpl
implements IBatchThreadPoolService {
    private static final String sourceClass = AbstractThreadPoolServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    protected ExecutorService executorService;
    static final long serialVersionUID = 5485739236516234326L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractThreadPoolServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractThreadPoolServiceImpl", "<init>", new Object[0]);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Instantiating instance of thread pool impl: " + this.getClass().getCanonicalName());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractThreadPoolServiceImpl", "<init>", this);
        }
    }

    @Override
    public abstract void init(IBatchConfig var1) throws BatchContainerServiceException;

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() throws BatchContainerServiceException {
        String method = "shutdown";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        this.executorService = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Future<?> executeTask(Runnable work, Object config) {
        String method = "executeTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        Future<?> retVal = this.executorService.submit(work);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return retVal;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Future<?> executeParallelTask(Runnable work, Object config) {
        String method = "executeParallelTask";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        Future<?> retVal = this.executorService.submit(work);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return retVal;
    }
}

