/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal;

import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.monitor.internal.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public final class ProbeFilter {
    private static final int CACHE_SIZE = 100;
    static final String ASSIGNABLE_TO_INDICATOR = "+";
    static final String ANNOTATION_INDICATOR = "@";
    static final String REGEX_INDICATOR = "~";
    static final String MATCH_ALL_REGEX = "^.*$";
    static final Pattern MATCH_ALL_PATTERN;
    static final Map<String, Pattern> patternCache;
    static final Map<String, String> globCache;
    Pattern classNamePattern;
    Pattern classAssignableToPattern;
    Pattern classAnnotationPattern;
    Pattern memberNamePattern;
    Pattern memberAnnotationPattern;
    Pattern methodArgsPattern;
    boolean advancedFilter = false;
    static final long serialVersionUID = -8097594455952151731L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ProbeFilter(ProbeSite probeSite) {
        this(probeSite.clazz(), probeSite.method(), probeSite.args(), probeSite.bundleName(), probeSite.bundleVersion());
    }

    public ProbeFilter(String clazz, String memberNames, String methodArgs, String bundleName, String bundleVersion) {
        if (clazz.startsWith(ASSIGNABLE_TO_INDICATOR)) {
            this.classAssignableToPattern = ProbeFilter.getPatternFromFilter(clazz.substring(1));
        } else if (clazz.startsWith(ANNOTATION_INDICATOR)) {
            this.classAnnotationPattern = ProbeFilter.getPatternFromFilter(clazz.substring(1));
        } else {
            this.classNamePattern = ProbeFilter.getPatternFromFilter(clazz);
        }
        if (memberNames == null) {
            this.memberNamePattern = ProbeFilter.getPatternFromFilter("*");
        } else if (memberNames.startsWith(ANNOTATION_INDICATOR)) {
            this.memberAnnotationPattern = ProbeFilter.getPatternFromFilter(memberNames.substring(1));
        } else {
            this.memberNamePattern = ProbeFilter.getPatternFromFilter(memberNames);
        }
        this.methodArgsPattern = ProbeFilter.getPatternFromFilter(methodArgs == null ? "*" : methodArgs);
        if (this.classAssignableToPattern != null || this.classAnnotationPattern != null || this.memberAnnotationPattern != null) {
            this.advancedFilter = true;
        }
    }

    static Pattern getPatternFromFilter(String filter) {
        String regex = null;
        regex = filter.startsWith(REGEX_INDICATOR) ? filter.substring(1) : ProbeFilter.getRegexFromGlob(filter);
        return ProbeFilter.getCompiledPattern(regex);
    }

    static String getRegexFromGlob(String glob) {
        String regex = globCache.get(glob);
        if (regex == null) {
            StringBuilder sb = new StringBuilder(glob.length() * 2);
            StringTokenizer tokenizer = new StringTokenizer(glob, "*?", true);
            sb.append("^");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("*")) {
                    sb.append(".*");
                    continue;
                }
                if (token.equals("?")) {
                    sb.append(".");
                    continue;
                }
                if (token.isEmpty()) continue;
                sb.append(Pattern.quote(token));
            }
            sb.append("$");
            regex = sb.toString();
            globCache.put(glob, regex);
        }
        return regex;
    }

    static Pattern getCompiledPattern(String regex) {
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            try {
                pattern = MATCH_ALL_REGEX.equals(regex) ? MATCH_ALL_PATTERN : Pattern.compile(regex);
            }
            catch (PatternSyntaxException pse) {
                pattern = Pattern.compile(Pattern.quote(regex));
            }
            patternCache.put(regex, pattern);
        }
        return pattern;
    }

    static String getArgsDescriptor(Method method) {
        Type[] argTypes = Type.getArgumentTypes((Method)method);
        return ProbeFilter.buildArgsDescriptor(argTypes);
    }

    static String getArgsDescriptor(Constructor<?> ctor) {
        String desc = Type.getConstructorDescriptor(ctor);
        Type[] argTypes = Type.getArgumentTypes((String)desc);
        return ProbeFilter.buildArgsDescriptor(argTypes);
    }

    public static String buildArgsDescriptor(Type[] argTypes) {
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < argTypes.length; ++i) {
            sb.append(argTypes[i].getClassName());
            if (i >= argTypes.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public boolean matches(Class<?> clazz) {
        if (this.classNamePattern != null) {
            return ProbeFilter.patternMatches(this.classNamePattern, clazz.getName());
        }
        if (this.classAssignableToPattern != null) {
            Class<?> cls = clazz;
            while (cls != null) {
                Class<?>[] interfaces;
                if (ProbeFilter.patternMatches(this.classAssignableToPattern, cls.getName())) {
                    return true;
                }
                for (Class<?> c : interfaces = ReflectionHelper.getInterfaces(clazz)) {
                    if (!ProbeFilter.patternMatches(this.classAssignableToPattern, c.getName())) continue;
                    return true;
                }
                cls = ReflectionHelper.getSuperclass(cls);
            }
        } else if (this.classAnnotationPattern != null) {
            return this.annotationMatches(this.classAnnotationPattern, clazz);
        }
        return false;
    }

    public boolean matches(Method method) {
        return this.matches(method, false);
    }

    public boolean matches(Method method, boolean skipDeclaring) {
        if (!skipDeclaring && !this.matches(method.getDeclaringClass())) {
            return false;
        }
        if (this.memberNamePattern != null) {
            String methodName = method.getName();
            if (ProbeFilter.patternMatches(this.memberNamePattern, methodName)) {
                if (this.methodArgsPattern == MATCH_ALL_PATTERN) {
                    return true;
                }
                return ProbeFilter.patternMatches(this.methodArgsPattern, ProbeFilter.getArgsDescriptor(method));
            }
        } else if (this.memberAnnotationPattern != null && this.annotationMatches(this.memberAnnotationPattern, method)) {
            if (this.methodArgsPattern == MATCH_ALL_PATTERN) {
                return true;
            }
            return ProbeFilter.patternMatches(this.methodArgsPattern, ProbeFilter.getArgsDescriptor(method));
        }
        return false;
    }

    public boolean matches(Constructor<?> ctor) {
        return this.matches(ctor, false);
    }

    public boolean matches(Constructor<?> ctor, boolean skipDeclaring) {
        if (!skipDeclaring && !this.matches(ctor.getDeclaringClass())) {
            return false;
        }
        if (this.memberNamePattern != null) {
            String methodName = "<init>";
            if (ProbeFilter.patternMatches(this.memberNamePattern, "<init>")) {
                if (this.methodArgsPattern == MATCH_ALL_PATTERN) {
                    return true;
                }
                return ProbeFilter.patternMatches(this.methodArgsPattern, ProbeFilter.getArgsDescriptor(ctor));
            }
        } else if (this.memberAnnotationPattern != null && this.annotationMatches(this.memberAnnotationPattern, ctor)) {
            if (this.methodArgsPattern == MATCH_ALL_PATTERN) {
                return true;
            }
            return ProbeFilter.patternMatches(this.methodArgsPattern, ProbeFilter.getArgsDescriptor(ctor));
        }
        return false;
    }

    public boolean matches(Field field) {
        return this.matches(field, false);
    }

    public boolean matches(Field field, boolean skipDeclaring) {
        String fieldName;
        if (!skipDeclaring && !this.matches(field.getDeclaringClass())) {
            return false;
        }
        return this.memberNamePattern != null ? ProbeFilter.patternMatches(this.memberNamePattern, fieldName = field.getName()) : this.memberAnnotationPattern != null && this.annotationMatches(this.memberAnnotationPattern, field);
    }

    boolean annotationMatches(Pattern pattern, AnnotatedElement annotated) {
        Annotation[] annotations;
        for (Annotation a : annotations = ReflectionHelper.getAnnotations(annotated)) {
            if (!ProbeFilter.patternMatches(this.classAnnotationPattern, a.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    public boolean basicClassNameMatches(String className) {
        if (this.classNamePattern != null) {
            return ProbeFilter.patternMatches(this.classNamePattern, className);
        }
        if (this.classAssignableToPattern != null) {
            return ProbeFilter.patternMatches(this.classAssignableToPattern, className);
        }
        return true;
    }

    public boolean basicMemberNameMatches(String memberName) {
        if (this.memberNamePattern != null) {
            return ProbeFilter.patternMatches(this.memberNamePattern, memberName);
        }
        return true;
    }

    public boolean basicArgsDescriptorMatches(String argsDescriptor) {
        if (this.methodArgsPattern != null) {
            return ProbeFilter.patternMatches(this.methodArgsPattern, argsDescriptor);
        }
        return true;
    }

    private static boolean patternMatches(Pattern pattern, String name) {
        if (pattern == MATCH_ALL_PATTERN) {
            return true;
        }
        boolean useLookingAt = false;
        String regex = pattern.pattern();
        if (regex.endsWith(".*$")) {
            pattern = ProbeFilter.getCompiledPattern(regex.substring(0, regex.length() - 3));
            useLookingAt = true;
        } else if (regex.endsWith(".*")) {
            pattern = ProbeFilter.getCompiledPattern(regex.substring(0, regex.length() - 2));
            useLookingAt = true;
        }
        Matcher matcher = pattern.matcher(name);
        if (useLookingAt) {
            return matcher.lookingAt();
        }
        return matcher.matches();
    }

    public boolean isBasicFilter() {
        return !this.isAdvancedFilter();
    }

    public boolean isAdvancedFilter() {
        return this.advancedFilter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";");
        sb.append("filter=");
        if (this.classNamePattern != null) {
            sb.append(this.classNamePattern);
        } else if (this.classAssignableToPattern != null) {
            sb.append(ASSIGNABLE_TO_INDICATOR).append(this.classAssignableToPattern);
        } else if (this.classAnnotationPattern != null) {
            sb.append(ANNOTATION_INDICATOR).append(this.classAnnotationPattern);
        }
        sb.append(" :: ").append(this.memberNamePattern);
        sb.append(" :: ").append(this.methodArgsPattern);
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProbeFilter.class);
        MATCH_ALL_PATTERN = Pattern.compile(MATCH_ALL_REGEX);
        patternCache = Collections.synchronizedMap(new LinkedHashMap<String, Pattern>(32, 0.75f, true){
            private static final long serialVersionUID = 4240783859644144196L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
                return this.size() > 100;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        globCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(32, 0.75f, true){
            private static final long serialVersionUID = 4240783859644144196L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > 100;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
    }
}

