/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPrivateKey;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPublicKey;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.ltpa.internal.LTPAConfiguration;
import com.ibm.ws.security.token.ltpa.internal.LTPAConfigurationImpl;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeyInfoManager;
import com.ibm.ws.security.token.ltpa.internal.LTPAToken2Factory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class LTPAKeyCreateTask
implements Runnable {
    private static final TraceComponent tc = Tr.register(LTPAKeyCreateTask.class);
    private final WsLocationAdmin locService;
    private final LTPAConfigurationImpl config;
    private ServiceRegistration<LTPAConfiguration> reg = null;
    static final long serialVersionUID = -1791475556038457458L;

    LTPAKeyCreateTask(WsLocationAdmin locService, LTPAConfigurationImpl config) {
        this.locService = locService;
        this.config = config;
    }

    @Sensitive
    byte[] getKeyPasswordBytes() {
        return PasswordUtil.passwordDecode((String)this.config.getKeyPassword()).getBytes();
    }

    private LTPAKeyInfoManager getPreparedLtpaKeyInfoManager() throws Exception {
        LTPAKeyInfoManager keyInfoManager = new LTPAKeyInfoManager();
        keyInfoManager.prepareLTPAKeyInfo(this.locService, this.config.getKeyFile(), this.getKeyPasswordBytes());
        return keyInfoManager;
    }

    @Sensitive
    private Map<String, Object> createTokenFactoryMap() {
        LTPAKeyInfoManager keyInfoManager = this.config.getLTPAKeyInfoManager();
        LTPAPrivateKey ltpaPrivateKey = new LTPAPrivateKey(keyInfoManager.getPrivateKey(this.config.getKeyFile()));
        LTPAPublicKey ltpaPublicKey = new LTPAPublicKey(keyInfoManager.getPublicKey(this.config.getKeyFile()));
        byte[] sharedKey = keyInfoManager.getSecretKey(this.config.getKeyFile());
        HashMap<String, Object> tokenFactoryMap = new HashMap<String, Object>();
        tokenFactoryMap.put("expiration", this.config.getTokenExpiration());
        tokenFactoryMap.put("ltpa_shared_key", sharedKey);
        tokenFactoryMap.put("ltpa_public_key", ltpaPublicKey);
        tokenFactoryMap.put("ltpa_private_key", ltpaPrivateKey);
        return tokenFactoryMap;
    }

    private TokenFactory getTokenFactory() {
        Map<String, Object> tokenFactoryMap = this.createTokenFactoryMap();
        LTPAToken2Factory tokenFactory = new LTPAToken2Factory();
        tokenFactory.initialize(tokenFactoryMap);
        return tokenFactory;
    }

    void createRequiredCollaborators() throws Exception {
        this.config.setLTPAKeyInfoManager(this.getPreparedLtpaKeyInfoManager());
        this.config.setTokenFactory(this.getTokenFactory());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void run() {
        try {
            long start = System.nanoTime();
            this.createRequiredCollaborators();
            if (this.reg == null) {
                BundleContext context = this.config.getBundleContext();
                if (context != null) {
                    this.reg = context.registerService(LTPAConfiguration.class, (Object)this.config, new Hashtable());
                    this.config.setRegistration(this.reg);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The bundle context was null, we must have been deactivated while we were creating the keys", (Object[])new Object[0]);
                    }
                    return;
                }
            }
            Tr.info((TraceComponent)tc, (String)"LTPA_CONFIG_READY", (Object[])new Object[]{TimestampUtils.getElapsedTimeNanos((long)start), this.config.getKeyFile()});
            this.config.configReady();
        }
        catch (Exception start) {
            FFDCFilter.processException((Throwable)start, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAKeyCreateTask", (String)"113", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"LTPA_CONFIG_ERROR", (Object[])new Object[]{this.config.getKeyFile()});
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAKeyCreateTask", (String)"115", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void t;
                Tr.debug((TraceComponent)tc, (String)"Exception creating the LTPA key.", (Object[])new Object[]{t});
            }
            Tr.error((TraceComponent)tc, (String)"LTPA_KEY_CREATE_ERROR", (Object[])new Object[0]);
        }
    }
}

