/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata.builder;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.common.wsclient.Addressing;
import com.ibm.ws.javaee.dd.common.wsclient.PortComponentRef;
import com.ibm.ws.javaee.dd.common.wsclient.ServiceRef;
import com.ibm.ws.jaxws.client.injection.WebServiceRefSimulator;
import com.ibm.ws.jaxws.metadata.AddressingFeatureInfo;
import com.ibm.ws.jaxws.metadata.MTOMFeatureInfo;
import com.ibm.ws.jaxws.metadata.PortComponentRefInfo;
import com.ibm.ws.jaxws.metadata.RespectBindingFeatureInfo;
import com.ibm.ws.jaxws.metadata.WebServiceFeatureInfo;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.metadata.WebServiceRefPartialInfo;
import com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder;
import com.ibm.ws.jaxws.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import javax.jws.HandlerChain;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.soap.AddressingFeature;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebServiceRefInfoBuilder {
    private static final TraceComponent tc = Tr.register(WebServiceRefInfoBuilder.class);
    static final long serialVersionUID = -1592731172494022317L;

    public static WebServiceRefInfo buildWebServiceRefInfo(WebServiceRef anno, ClassLoader classLoader) {
        WebServiceRefInfo webServiceRefInfo = new WebServiceRefInfo(anno);
        return webServiceRefInfo;
    }

    public static WebServiceRefInfo buildWebServiceRefInfo(ServiceRef serviceRef, ClassLoader classloader) throws ClassNotFoundException {
        List pcRefs;
        WebServiceRefSimulator wsrSimuAnnot;
        WebServiceRefInfo wsrInfo;
        if (serviceRef == null) {
            return null;
        }
        Class srvInterfaceClass = Service.class;
        Class srvRefTypeClass = Object.class;
        if (serviceRef.getServiceInterfaceName() != null) {
            srvInterfaceClass = Class.forName(serviceRef.getServiceInterfaceName(), false, classloader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Loaded service-interface class from DD: " + srvInterfaceClass.getName()), (Object[])new Object[0]);
            }
        }
        if (serviceRef.getServiceRefTypeName() != null) {
            srvRefTypeClass = Class.forName(serviceRef.getServiceRefTypeName(), false, classloader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Loaded service-ref-type class from DD: " + srvRefTypeClass.getName()), (Object[])new Object[0]);
            }
        }
        String serviceRefName = serviceRef.getName();
        String wsdlLocation = serviceRef.getWsdlFile();
        String lookupName = serviceRef.getLookupName();
        if (lookupName != null) {
            lookupName = lookupName.trim();
        }
        if ((wsrInfo = new WebServiceRefInfo(wsrSimuAnnot = new WebServiceRefSimulator("", serviceRefName, srvRefTypeClass, srvInterfaceClass, wsdlLocation, lookupName))).getLookupName() != null && !wsrInfo.getLookupName().isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Service-ref's lookup name was specified... bypassing the rest of metadata processing...", (Object[])new Object[0]);
            }
            return wsrInfo;
        }
        if (serviceRef.getServiceQname() != null) {
            QName serviceQName = new QName(serviceRef.getServiceQname().getNamespaceURI(), serviceRef.getServiceQname().getLocalPart());
            wsrInfo.setServiceQName(serviceQName);
        }
        if (!serviceRef.getHandlerChainList().isEmpty()) {
            wsrInfo.setHandlersFromXML(true);
            for (com.ibm.ws.javaee.dd.common.wsclient.HandlerChain handerChain : serviceRef.getHandlerChainList()) {
                wsrInfo.addHandlerChain(HandlerChainInfoBuilder.buildHandlerChainInfoFromXML(handerChain));
            }
        }
        if ((pcRefs = serviceRef.getPortComponentRefs()) != null && !pcRefs.isEmpty()) {
            for (PortComponentRef pcRef : pcRefs) {
                Addressing addr;
                WebServiceFeatureInfo feature;
                String seiName = pcRef.getServiceEndpointInterfaceName();
                if (StringUtils.isEmpty(seiName)) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"service-endpoint-interface is not configured in the current port-component-ref from the service-ref {0}", (Object[])new Object[]{serviceRef.getName()});
                    continue;
                }
                PortComponentRefInfo portComponentRefInfo = new PortComponentRefInfo(seiName.trim());
                wsrInfo.addPortComponentRefInfo(portComponentRefInfo);
                if (!StringUtils.isEmpty(pcRef.getPortComponentLink())) {
                    portComponentRefInfo.setPortComponentLink(pcRef.getPortComponentLink());
                }
                if (pcRef.isSetEnableMtom() || pcRef.isSetMtomThreshold()) {
                    feature = new MTOMFeatureInfo();
                    if (pcRef.isSetEnableMtom()) {
                        ((MTOMFeatureInfo)feature).setEnabled(pcRef.isEnableMtom());
                    }
                    if (pcRef.isSetMtomThreshold()) {
                        ((MTOMFeatureInfo)feature).setThreshold(pcRef.getMtomThreshold());
                    }
                    portComponentRefInfo.addWebServiceFeatureInfo(feature);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recording MTOMFeatureInfo for SEI " + seiName + ": " + ((MTOMFeatureInfo)feature).toString()), (Object[])new Object[0]);
                    }
                }
                if (pcRef.getRespectBinding() != null) {
                    feature = new RespectBindingFeatureInfo();
                    if (pcRef.getRespectBinding().isSetEnabled()) {
                        ((RespectBindingFeatureInfo)feature).setEnabled(pcRef.getRespectBinding().isEnabled());
                    }
                    portComponentRefInfo.addWebServiceFeatureInfo(feature);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recording RespectBindingFeatureInfo for SEI " + seiName + ": " + ((RespectBindingFeatureInfo)feature).toString()), (Object[])new Object[0]);
                    }
                }
                if ((addr = pcRef.getAddressing()) == null) continue;
                AddressingFeatureInfo feature2 = new AddressingFeatureInfo();
                if (addr.isSetEnabled()) {
                    feature2.setEnabled(addr.isEnabled());
                }
                if (addr.isSetRequired()) {
                    feature2.setRequired(addr.isRequired());
                }
                switch (addr.getAddressingResponsesTypeValue()) {
                    case 1: {
                        feature2.setResponses(AddressingFeature.Responses.ANONYMOUS);
                        break;
                    }
                    case 2: {
                        feature2.setResponses(AddressingFeature.Responses.NON_ANONYMOUS);
                        break;
                    }
                    default: {
                        feature2.setResponses(AddressingFeature.Responses.ALL);
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Recording AddressingFeatureInfo for SEI " + seiName + ": " + feature2.toString()), (Object[])new Object[0]);
                }
                portComponentRefInfo.addWebServiceFeatureInfo(feature2);
            }
        }
        return wsrInfo;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public static void configureWebServiceRefPartialInfo(WebServiceRefInfo webServiceRefInfo, ClassLoader classLoader) {
        block4: {
            String serviceInterfaceClassName = webServiceRefInfo.getServiceInterfaceClassName();
            if (StringUtils.isEmpty(serviceInterfaceClassName) || serviceInterfaceClassName.equals(Service.class.getName())) {
                return;
            }
            try {
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                Class<?> serviceInterfaceClass = classLoader.loadClass(webServiceRefInfo.getServiceInterfaceClassName());
                WebServiceRefPartialInfo partialInfo = WebServiceRefInfoBuilder.buildPartialInfoFromWebServiceClient(serviceInterfaceClass);
                webServiceRefInfo.setPartialInfo(partialInfo);
            }
            catch (ClassNotFoundException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Unable to locate classinfo for class " + webServiceRefInfo.getServiceInterfaceClassName() + " for " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    private static WebServiceRefPartialInfo buildPartialInfoFromWebServiceClient(Class<?> serviceInterfaceClass) {
        WebServiceClient webServiceClient = serviceInterfaceClass.getAnnotation(WebServiceClient.class);
        if (webServiceClient == null) {
            return null;
        }
        String className = serviceInterfaceClass.getName();
        String wsdlLocation = webServiceClient.wsdlLocation();
        QName serviceQName = null;
        String localPart = webServiceClient.name();
        if (localPart != null) {
            serviceQName = new QName(webServiceClient.targetNamespace(), localPart);
        }
        String handlerChainDeclaringClassName = null;
        HandlerChain handlerChainAnnotation = serviceInterfaceClass.getAnnotation(HandlerChain.class);
        if (handlerChainAnnotation != null) {
            handlerChainDeclaringClassName = serviceInterfaceClass.getName();
        }
        WebServiceRefPartialInfo partialInfo = new WebServiceRefPartialInfo(className, wsdlLocation, serviceQName, null, handlerChainDeclaringClassName, handlerChainAnnotation);
        return partialInfo;
    }
}

