/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.logging.internal.impl.BaseTraceFormatter;
import com.ibm.ws.logging.internal.impl.DateFormatProvider;
import com.ibm.ws.logging.internal.impl.FileLogSet;
import com.ibm.ws.logging.internal.impl.IncidentLogger;
import com.ibm.ws.logging.internal.impl.IncidentStreamImpl;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import com.ibm.ws.logging.internal.impl.LoggingFileUtils;
import com.ibm.wsspi.logging.Incident;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class IncidentImpl
implements Incident {
    private static final TraceComponent tc = Tr.register(IncidentImpl.class, "logging", "com.ibm.ws.logging.internal.resources.FFDCMessages");
    final FileLogSet fileLogSet;
    final Key key;
    private final Date firstOccurrence;
    private String label;
    private volatile long timeStamp;
    private final AtomicInteger count = new AtomicInteger(0);
    private int dailyWaterMark = 0;
    private final List<IncidentFile> incidentFiles;

    public IncidentImpl(FileLogSet fileLogSet, Key key) {
        this.fileLogSet = fileLogSet;
        this.key = key;
        this.timeStamp = System.currentTimeMillis();
        this.firstOccurrence = new Date(this.timeStamp);
        this.incidentFiles = new ArrayList<IncidentFile>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Throwable th, Object callerThis, Object[] objectArray) {
        boolean logThis = true;
        File newFile = null;
        File oldFile = null;
        IncidentFile incident = null;
        int exMsgHash = th == null ? 0 : th.toString().hashCode();
        IncidentImpl incidentImpl = this;
        synchronized (incidentImpl) {
            this.timeStamp = System.currentTimeMillis();
            this.count.incrementAndGet();
            ++this.dailyWaterMark;
            if (this.dailyWaterMark > 10) {
                logThis = false;
            } else {
                Iterator<IncidentFile> i = this.incidentFiles.iterator();
                while (i.hasNext()) {
                    IncidentFile oldIncident = i.next();
                    if (oldIncident.exceptionMsgHash != exMsgHash) continue;
                    incident = oldIncident;
                    i.remove();
                    this.incidentFiles.add(incident);
                    logThis = oldIncident.refreshLog;
                    break;
                }
                if (incident == null) {
                    logThis = true;
                    incident = new IncidentFile(exMsgHash);
                    this.incidentFiles.add(incident);
                }
                if (this.incidentFiles.size() > 10) {
                    IncidentFile oldIncident = this.incidentFiles.remove(0);
                    oldFile = oldIncident.setFile(null);
                }
            }
        }
        if (oldFile != null) {
            oldFile.delete();
        }
        if (logThis && incident != null) {
            IncidentStreamImpl iStream = null;
            try {
                iStream = new IncidentStreamImpl(this.fileLogSet);
            }
            catch (Exception oldIncident) {
                // empty catch block
            }
            if (iStream != null) {
                try {
                    newFile = iStream.getFile();
                    new IncidentLogger().logIncident(iStream, this, th, callerThis, objectArray);
                }
                catch (Throwable e) {
                    iStream.printStackTrace(e);
                }
                finally {
                    LoggingFileUtils.tryToClose(iStream);
                    oldFile = incident.setFile(newFile);
                    if (oldFile != null) {
                        oldFile.delete();
                    }
                }
            }
            if (tc.isInfoEnabled() && newFile != null) {
                String txt = th + " " + this.key.sourceId + " " + this.key.probeId;
                Tr.info(tc, "lwas.FFDCIncidentEmitted", txt, newFile.getName());
            }
        }
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getCount() {
        return this.count.get();
    }

    @Override
    public Date getDateOfFirstOccurrence() {
        return this.firstOccurrence;
    }

    @Override
    public String getExceptionName() {
        return this.key.exceptionName;
    }

    @Override
    public String getSourceId() {
        return this.key.sourceId;
    }

    @Override
    public String getProbeId() {
        return this.key.probeId;
    }

    @Override
    public long getThreadId() {
        return this.key.threadId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIntrospectedCallerDump() {
        String dump = null;
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        IncidentStreamImpl iStream = null;
        try {
            iStream = new IncidentStreamImpl(oStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iStream != null) {
            try {
                new IncidentLogger().logIncident(iStream, this, this.key.th, this.key.callerThis, this.key.objectArray, true);
            }
            catch (Throwable e) {
                iStream.printStackTrace(e);
            }
            finally {
                LoggingFileUtils.tryToClose(iStream);
                try {
                    dump = oStream.toString("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return dump;
    }

    public synchronized void roll() {
        this.dailyWaterMark = 0;
        for (IncidentFile inF : this.incidentFiles) {
            inF.enableReplace();
        }
    }

    public synchronized List<IncidentFile> getFiles() {
        return new ArrayList<IncidentFile>(this.incidentFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        List<IncidentFile> files = this.getFiles();
        Object token = ThreadIdentityManager.runAsServer();
        try {
            for (IncidentFile ifile : files) {
                File f = ifile.getFile();
                if (f == null) continue;
                LoggingFileUtils.deleteFile(ifile.getFile());
            }
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public String formatSummaryEntry(int index) {
        DateFormat dateFormatter = BaseTraceFormatter.useIsoDateFormat ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ") : this.getDateFormatter();
        String dateString = "";
        String firstDateString = "";
        Date date = new Date(this.timeStamp);
        try {
            dateString = dateFormatter.format(date);
            firstDateString = dateFormatter.format(this.firstOccurrence);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%6d %6d %27s %27s", index, this.count.get(), firstDateString, dateString);
        sb.append(' ');
        sb.append(this.key.exceptionName);
        sb.append(' ');
        sb.append(this.key.sourceId);
        sb.append(' ');
        sb.append(this.key.probeId);
        Iterator<IncidentFile> i = this.getFiles().iterator();
        while (i.hasNext()) {
            sb.append(LoggingConstants.nl);
            File f = i.next().getFile();
            if (f == null) continue;
            formatter.format("%6s %70s %s", " ", "-", f.getAbsolutePath());
        }
        return sb.toString();
    }

    protected DateFormat getDateFormatter() {
        return DateFormatProvider.getDateFormat();
    }

    static class IncidentFile {
        private final int exceptionMsgHash;
        private volatile boolean refreshLog = false;
        private File incidentFile = null;

        public IncidentFile(int hashCode) {
            this.exceptionMsgHash = hashCode;
        }

        public synchronized File getFile() {
            return this.incidentFile;
        }

        public synchronized File setFile(File file) {
            File oldFile = this.incidentFile;
            this.incidentFile = file;
            this.refreshLog = false;
            return oldFile;
        }

        public void enableReplace() {
            this.refreshLog = true;
        }
    }

    static class Key
    implements Comparable<Key> {
        final String sourceId;
        final String probeId;
        final String exceptionName;
        final long threadId;
        final Throwable th;
        final Object callerThis;
        final Object[] objectArray;

        public Key(String sourceId, String probeId, Throwable th, Object callerThis, Object[] objectArray) {
            this.sourceId = sourceId;
            this.probeId = probeId;
            this.exceptionName = th == null ? String.valueOf((Object)null) : th.getClass().getName();
            this.threadId = Thread.currentThread().getId();
            this.th = th;
            this.callerThis = callerThis;
            this.objectArray = objectArray;
        }

        @Override
        public int compareTo(Key other) {
            int cSourceId = this.sourceId.compareTo(other.sourceId);
            if (cSourceId != 0) {
                return cSourceId;
            }
            int cProbeId = this.probeId.compareTo(other.probeId);
            if (cProbeId != 0) {
                return cProbeId;
            }
            int cExpName = this.exceptionName.compareTo(other.exceptionName);
            if (cExpName != 0) {
                return cExpName;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exceptionName == null ? 0 : this.exceptionName.hashCode());
            result = 31 * result + (this.probeId == null ? 0 : this.probeId.hashCode());
            result = 31 * result + (this.sourceId == null ? 0 : this.sourceId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((Key)obj) == 0;
        }

        public String toString() {
            return this.exceptionName + ' ' + this.sourceId + ' ' + this.probeId;
        }
    }
}

