/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.ws.logging.internal.TraceSpecification;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.FileLogSet;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoggingFileUtils {
    public static final SimpleDateFormat FILE_DATE = new SimpleDateFormat("_yy.MM.dd_HH.mm.ss");

    static String[] safelyFindFiles(final File directory, final Pattern p) {
        String[] rc = null;
        try {
            rc = AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){

                @Override
                public String[] run() throws Exception {
                    return directory.list(new RegexFilenameFilter(p));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    static File validateDirectory(final File directory) {
        File newDirectory = null;
        try {
            newDirectory = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    boolean ok = true;
                    if (!directory.exists()) {
                        boolean bl = ok = directory.mkdirs() || directory.exists();
                    }
                    if (!ok) {
                        String msg = Tr.formatMessage(TraceSpecification.getTc(), "UNABLE_TO_CREATE_RESOURCE_NOEX", directory.getAbsolutePath());
                        BaseTraceService.rawSystemErr.println(msg);
                        return null;
                    }
                    return directory;
                }
            });
        }
        catch (PrivilegedActionException e) {
            String msg = Tr.formatMessage(TraceSpecification.getTc(), "UNABLE_TO_CREATE_RESOURCE", directory.getAbsolutePath(), e);
            BaseTraceService.rawSystemErr.println(msg);
        }
        return newDirectory;
    }

    static File createNewFile(final FileLogSet fileLogSet) {
        File directory = fileLogSet.getDirectory();
        String fileName = fileLogSet.getFileName();
        String fileExtension = fileLogSet.getFileExtension();
        File f = null;
        try {
            f = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    return fileLogSet.createNewFile();
                }
            });
        }
        catch (PrivilegedActionException e) {
            File exf = new File(directory, fileName + fileExtension);
            String msg = Tr.formatMessage(TraceSpecification.getTc(), "UNABLE_TO_CREATE_RESOURCE", exf.getAbsolutePath(), e);
            BaseTraceService.rawSystemErr.println(msg);
        }
        return f;
    }

    static Pattern compileLogFileRegex(String baseName, String extension) {
        StringBuilder builder = new StringBuilder();
        builder.append(Pattern.quote(baseName));
        builder.append("(_\\d\\d\\.\\d\\d\\.\\d\\d_\\d\\d\\.\\d\\d\\.\\d\\d)");
        builder.append("(?:\\.(\\d+))");
        builder.append(Pattern.quote(extension));
        return Pattern.compile(builder.toString());
    }

    static final void deleteFile(File directory, String name) {
        LoggingFileUtils.deleteFile(new File(directory, name));
    }

    public static boolean deleteFile(final File f) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (!f.delete()) {
                        String msg = Tr.formatMessage(TraceSpecification.getTc(), "UNABLE_TO_DELETE_RESOURCE_NOEX", f);
                        BaseTraceService.rawSystemErr.println(msg);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (PrivilegedActionException e) {
            String msg = Tr.formatMessage(TraceSpecification.getTc(), "UNABLE_TO_DELETE_RESOURCE", f, e);
            BaseTraceService.rawSystemErr.println(msg);
            return false;
        }
    }

    public static boolean tryToClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static class RegexFilenameFilter
    implements FilenameFilter {
        final Pattern p;

        RegexFilenameFilter(Pattern p) {
            this.p = p;
        }

        @Override
        public boolean accept(File dir, String name) {
            Matcher m = this.p.matcher(name);
            return m.matches();
        }
    }
}

