/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.common.jwk.impl.Jose4jEllipticCurveJWK;
import com.ibm.ws.security.common.jwk.impl.Jose4jRsaJWK;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.PrivilegedActionException;
import java.security.PublicKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwKRetriever {
    private static final TraceComponent tc = Tr.register(JwKRetriever.class);
    String configId = null;
    String sslConfigurationName = null;
    String jwkEndpointUrl = null;
    String sigAlg = "RS256";
    JWKSet jwkSet = null;
    SSLSupport sslSupport = JwtUtils.getSSLSupportService();
    boolean hostNameVerificationEnabled = true;
    static final long serialVersionUID = 3323208643340212018L;

    public JwKRetriever(String configId, String sslConfigurationName, String jwkEndpointUrl, JWKSet jwkSet) {
        this.configId = configId;
        this.sslConfigurationName = sslConfigurationName;
        this.jwkEndpointUrl = jwkEndpointUrl;
        this.jwkSet = jwkSet;
    }

    public JwKRetriever(JwtConsumerConfig config) {
        this.configId = config.getId();
        this.sslConfigurationName = config.getSslRef();
        this.jwkEndpointUrl = config.getJwkEndpointUrl();
        this.jwkSet = config.getJwkSet();
        this.hostNameVerificationEnabled = config.isHostNameVerificationEnabled();
    }

    @FFDCIgnore(value={KeyStoreException.class})
    public PublicKey getPublicKeyFromJwk(String kid, String x5t) throws PrivilegedActionException, IOException, KeyStoreException, InterruptedException {
        PublicKey key = this.getJwkCache(kid, x5t);
        KeyStoreException errKeyStoreException = null;
        InterruptedException errInterruptedException = null;
        if (key == null) {
            try {
                key = this.getJwkRemote(kid, x5t);
            }
            catch (KeyStoreException e) {
                errKeyStoreException = e;
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jwt.internal.JwKRetriever", (String)"113", (Object)this, (Object[])new Object[]{kid, x5t});
                errInterruptedException = e;
            }
        }
        if (key == null) {
            if (errKeyStoreException != null) {
                throw errKeyStoreException;
            }
            if (errInterruptedException != null) {
                throw errInterruptedException;
            }
        }
        return key;
    }

    protected PublicKey getJwkCache(String kid, String x5t) {
        if (kid != null) {
            return this.jwkSet.getPublicKeyByKid(kid);
        }
        if (x5t != null) {
            return this.jwkSet.getPublicKeyByx5t(x5t);
        }
        return this.jwkSet.getPublicKeyByKid(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={KeyStoreException.class})
    protected PublicKey getJwkRemote(String kid, String x5t) throws KeyStoreException, InterruptedException {
        String jwkUrl = this.jwkEndpointUrl;
        if (jwkUrl == null || !jwkUrl.startsWith("http")) {
            return null;
        }
        PublicKey key = null;
        JWKSet jWKSet = this.jwkSet;
        synchronized (jWKSet) {
            key = this.getJwkCache(kid, x5t);
            if (key == null) {
                key = this.doJwkRemote(kid, x5t);
            }
        }
        return key;
    }

    @FFDCIgnore(value={Exception.class, KeyStoreException.class})
    protected PublicKey doJwkRemote(String kid, String x5t) throws KeyStoreException {
        block5: {
            String jsonString = null;
            String jwkUrl = this.jwkEndpointUrl;
            try {
                SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory(jwkUrl, this.sslConfigurationName, this.sslSupport);
                HttpClient client = this.createHTTPClient(sslSocketFactory, jwkUrl, this.hostNameVerificationEnabled);
                jsonString = this.getHTTPRequestAsString(client, jwkUrl);
                boolean bJwk = this.parseJwk(jsonString, this.jwkSet, this.sigAlg);
                if (!bJwk && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No JWK can be found through '" + jwkUrl + "'"), (Object[])new Object[0]);
                }
            }
            catch (KeyStoreException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Fail to retrieve remote key: ", (Object[])new Object[]{e.getCause()});
                }
                throw e;
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Fail to retrieve remote key: ", (Object[])new Object[]{e.getCause()});
            }
        }
        PublicKey key = null;
        key = kid != null ? this.jwkSet.getPublicKeyByKid(kid) : (x5t != null ? this.jwkSet.getPublicKeyByx5t(x5t) : this.jwkSet.getPublicKeyByKid(null));
        return key;
    }

    public boolean parseJwk(String jsonString, JWKSet jwkset, String signatureAlgorithm) {
        Object keysEntry;
        boolean bJwk = false;
        JSONObject jsonObject = this.parseJsonObject(jsonString);
        if (jsonObject == null) {
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsed JSON object: " + jsonObject.toString()), (Object[])new Object[0]);
        }
        if ((keysEntry = jsonObject.get((Object)"keys")) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to find keys array in provided JSON object", (Object[])new Object[0]);
            }
            return false;
        }
        JSONArray keyArray = this.parseJsonArray(keysEntry.toString());
        if (keyArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to parse keys array in provided JSON object", (Object[])new Object[0]);
            }
            return false;
        }
        for (Object element : keyArray) {
            JSONObject jElement = this.parseJsonObject(element.toString());
            if (jElement == null || !this.jsonObjectContainsKtyForValidJwk(jElement, jwkset, signatureAlgorithm)) continue;
            bJwk = true;
        }
        return bJwk;
    }

    @FFDCIgnore(value={Exception.class})
    JSONObject parseJsonObject(String jsonString) {
        JSONObject jsonObject;
        block2: {
            jsonObject = null;
            try {
                jsonObject = JSONObject.parse((String)jsonString);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing JSON string [" + jsonString + "]: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return jsonObject;
    }

    @FFDCIgnore(value={Exception.class})
    JSONArray parseJsonArray(String jsonString) {
        JSONArray jsonArray;
        block2: {
            jsonArray = null;
            try {
                jsonArray = JSONArray.parse((String)jsonString);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing JSON string [" + jsonString + "]: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return jsonArray;
    }

    boolean jsonObjectContainsKtyForValidJwk(JSONObject entry, JWKSet jwkset, String signatureAlgorithm) {
        if (entry == null) {
            return false;
        }
        JWK jwk = null;
        String kty = (String)entry.get((Object)"kty");
        if (kty == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JSON object is missing 'kty' entry", (Object[])new Object[0]);
            }
            return false;
        }
        jwk = this.createJwkBasedOnKty(kty, entry, signatureAlgorithm);
        if (jwk == null) {
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Parsing JWK and adding it to JWK set", (Object[])new Object[0]);
        }
        jwk.parse();
        jwkset.addJWK(jwk);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"add remote key for keyid: ", (Object[])new Object[]{jwk.getKeyID()});
        }
        return true;
    }

    JWK createJwkBasedOnKty(String kty, JSONObject keyEntry, String signatureAlgorithm) {
        JWK jwk = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("kty of JWK is '" + kty + "'"), (Object[])new Object[0]);
        }
        if ("RSA".equalsIgnoreCase(kty)) {
            jwk = this.getRsaJwk(keyEntry);
        } else if ("EC".equalsIgnoreCase(kty)) {
            jwk = this.getEllipticCurveJwk(keyEntry, signatureAlgorithm);
        }
        return jwk;
    }

    JWK getRsaJwk(JSONObject thing) {
        return Jose4jRsaJWK.getInstance((JSONObject)thing);
    }

    JWK getEllipticCurveJwk(JSONObject thing, String signatureAlgorithm) {
        if (signatureAlgorithm.startsWith("ES")) {
            return Jose4jEllipticCurveJWK.getInstance((JSONObject)thing);
        }
        return null;
    }

    protected JSSEHelper getJSSEHelper(SSLSupport sslSupport) throws com.ibm.websphere.ssl.SSLException {
        if (sslSupport != null) {
            return sslSupport.getJSSEHelper();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected SSLSocketFactory getSSLSocketFactory(String requestUrl, String sslConfigurationName, SSLSupport sslSupport) throws com.ibm.websphere.ssl.SSLException {
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslSocketFactory = sslSupport.getSSLSocketFactory(sslConfigurationName);
        }
        catch (SSLException sSLException) {
            void e;
            FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.security.jwt.internal.JwKRetriever", (String)"337", (Object)this, (Object[])new Object[]{requestUrl, sslConfigurationName, sslSupport});
            throw new com.ibm.websphere.ssl.SSLException(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sslSocketFactory () get: " + sslSocketFactory), (Object[])new Object[0]);
        }
        if (sslSocketFactory == null && requestUrl != null && requestUrl.startsWith("https")) {
            throw new com.ibm.websphere.ssl.SSLException(Tr.formatMessage((TraceComponent)tc, (String)"JWT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl socket factory", this.configId}));
        }
        return sslSocketFactory;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={KeyStoreException.class})
    protected String getHTTPRequestAsString(HttpClient httpClient, String url) throws Exception {
        String json;
        block8: {
            json = null;
            HttpGet request = new HttpGet(url);
            request.addHeader("content-type", "application/json");
            HttpResponse result = null;
            try {
                result = httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException iOException) {
                void ioex;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.jwt.internal.JwKRetriever", (String)"363", (Object)this, (Object[])new Object[]{httpClient, url});
                this.logCWWKS6049E(url, 0, "IOException: " + ioex.getMessage() + " " + ioex.getCause());
                throw ioex;
            }
            StatusLine statusLine = result.getStatusLine();
            int iStatusCode = statusLine.getStatusCode();
            if (iStatusCode == 200) {
                json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Response: ", (Object[])new Object[]{json});
                }
                if (json == null || json.isEmpty()) {
                    throw new Exception(this.logCWWKS6049E(url, iStatusCode, json));
                }
                break block8;
            }
            String errMsg = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("status:" + iStatusCode + " errorMsg:" + errMsg), (Object[])new Object[0]);
            }
            throw new Exception(this.logCWWKS6049E(url, iStatusCode, errMsg));
        }
        return json;
    }

    private String logCWWKS6049E(String url, int iStatusCode, String errMsg) {
        String defaultMessage = "CWWKS6049E: A JSON Web Key (JWK) was not returned from the URL [" + url + "]. The response status was [" + iStatusCode + "] and the content returned was [" + errMsg + "].";
        String message = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages", (String)"JWT_JWK_RETRIEVE_FAILED", (Object[])new Object[]{url, iStatusCode, errMsg}, (String)defaultMessage);
        Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        return message;
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification) {
        CloseableHttpClient client = null;
        if (url.startsWith("http:")) {
            client = HttpClientBuilder.create().build();
        } else {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        return client;
    }
}

