/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.web.JwtRequest;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtRequestFilter
implements Filter {
    private static TraceComponent tc = Tr.register(JwtRequestFilter.class);
    public static final String REGEX_COMPONENT_ID = "/([\\w-]+)/";
    private static final Pattern PATH_REGEX = Pattern.compile("^/([\\w-]+)/(jwk)$");
    static final long serialVersionUID = 4883031982329976232L;

    public void init(FilterConfig fConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (response.isCommitted()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response has already been committed; will do nothing", (Object[])new Object[0]);
            }
            return;
        }
        Matcher matcher = this.matchEndpointRequest(request);
        if (matcher != null) {
            this.invokeEndpointRequest(request, response, chain, matcher);
        } else {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"JWT_ENDPOINT_FILTER_MATCH_NOT_FOUND", (Object[])new Object[]{request.getPathInfo()});
            Tr.warning((TraceComponent)tc, (String)message, (Object[])new Object[0]);
            response.sendError(404, message);
        }
    }

    public void invokeEndpointRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Matcher matcher) throws IOException, ServletException {
        JwtRequest jwtRequest = new JwtRequest(this.getJwtConfigIdFromUrl(matcher), this.getEndpointTypeFromUrl(matcher), request);
        request.setAttribute("JwtRequest", (Object)jwtRequest);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String getJwtConfigIdFromUrl(Matcher m) {
        String componentId = m.group(1);
        return componentId;
    }

    protected JwtRequest.EndpointType getEndpointTypeFromUrl(Matcher m) {
        JwtRequest.EndpointType type = this.getType(m.group(2));
        return type;
    }

    private Matcher matchEndpointRequest(HttpServletRequest request) {
        Matcher m;
        String path = request.getPathInfo();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Path info: [" + path + "]"), (Object[])new Object[0]);
        }
        if ((m = PATH_REGEX.matcher(path)).matches()) {
            return m;
        }
        return null;
    }

    protected JwtRequest.EndpointType getType(String pathType) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Path type is " + pathType), (Object[])new Object[0]);
        }
        return JwtRequest.EndpointType.valueOf(pathType);
    }
}

