/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.credentials.wscred;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.credentials.CredentialProvider;
import com.ibm.ws.security.credentials.wscred.WSCredentialImpl;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={CredentialProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "type=BasicAuthCredential"})
public class BasicAuthCredentialProvider
implements CredentialProvider {
    protected static final String KEY_BASIC_AUTH_REALM = "com.ibm.ws.security.cred.realm";
    protected static final String KEY_BASIC_AUTH_USER = "com.ibm.ws.security.cred.user";
    protected static final String KEY_BASIC_AUTH_PASSWORD = "com.ibm.ws.security.cred.password";
    static final long serialVersionUID = -2963529245432279019L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate() {
    }

    @Deactivate
    protected void deactivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCredential(Subject subject) throws CredentialException {
        Hashtable<String, ?> customProperties = this.getBasicAuthHashtableFromSubject(subject);
        try {
            if (customProperties != null && !customProperties.isEmpty() && customProperties.size() == 3) {
                String realm = this.getRealm(customProperties);
                String securityName = this.getSecurityName(customProperties);
                SerializableProtectedString password = this.getPassword(customProperties);
                this.setBasicAuthCredential(subject, realm, securityName, password);
            }
        }
        finally {
            this.removeBasicAuthHashtable(subject, customProperties);
        }
    }

    @Sensitive
    private Hashtable<String, ?> getBasicAuthHashtableFromSubject(@Sensitive Subject subject) {
        String[] properties = new String[]{KEY_BASIC_AUTH_REALM, KEY_BASIC_AUTH_USER, KEY_BASIC_AUTH_PASSWORD};
        SubjectHelper subjectHelper = new SubjectHelper();
        return subjectHelper.getSensitiveHashtableFromSubject(subject, properties);
    }

    private String getRealm(@Sensitive Hashtable<String, ?> customProperties) {
        return (String)customProperties.get(KEY_BASIC_AUTH_REALM);
    }

    private String getSecurityName(@Sensitive Hashtable<String, ?> customProperties) {
        return (String)customProperties.get(KEY_BASIC_AUTH_USER);
    }

    @Sensitive
    private SerializableProtectedString getPassword(@Sensitive Hashtable<String, ?> customProperties) {
        return (SerializableProtectedString)customProperties.get(KEY_BASIC_AUTH_PASSWORD);
    }

    private void setBasicAuthCredential(@Sensitive Subject subject, String realm, String securityName, SerializableProtectedString password) throws CredentialException {
        WSCredentialImpl cred = new WSCredentialImpl(realm, securityName, new String(password.getChars()));
        subject.getPublicCredentials().add(cred);
    }

    private void removeBasicAuthHashtable(@Sensitive Subject subject, @Sensitive Hashtable<String, ?> customProperties) {
        if (customProperties != null) {
            subject.getPrivateCredentials().remove(customProperties);
        }
    }

    @Override
    public boolean isSubjectValid(Subject subject) {
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BasicAuthCredentialProvider.class);
    }
}

