/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.internal.FeatureManager;
import com.ibm.ws.kernel.feature.internal.HashUtils;
import com.ibm.ws.kernel.feature.internal.subsystem.KernelFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.launch.service.ServerContent;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServerContentHelper {
    private static final TraceComponent tc = Tr.register(ServerContentHelper.class);
    private final BundleContext bundleContext;
    private final FeatureManager featureResolver;
    private final WsLocationAdmin locationService;
    static final long serialVersionUID = -7265686466054506196L;

    static boolean isServerContentRequest(BundleContext bc) {
        String contentRequest = bc.getProperty("com.ibm.ws.liberty.content.request");
        return contentRequest != null && contentRequest.equals("1.0.0");
    }

    ServerContentHelper(BundleContext bundleContext, FeatureManager featureResolver, WsLocationAdmin locationAdmin) {
        this.bundleContext = bundleContext;
        this.featureResolver = featureResolver;
        this.locationService = locationAdmin;
    }

    void processServerContentRequest() {
        File installRoot = new File(this.locationService.resolveString("${wlp.install.dir}"));
        final HashSet<String> absPathsForLibertyContent = new HashSet<String>();
        final HashMap<String, ArrayList<String>> specificPlatformPathsByPlatform = new HashMap<String, ArrayList<String>>();
        HashSet<String> discoveredFeatures = new HashSet<String>();
        ArrayList<FeatureResource> fixes = new ArrayList<FeatureResource>();
        ArrayList<ProvisioningFeatureDefinition> allFeatureDefs = new ArrayList<ProvisioningFeatureDefinition>();
        allFeatureDefs.addAll(KernelFeatureDefinitionImpl.getAllKernelFeatures(this.bundleContext, this.locationService));
        allFeatureDefs.addAll(this.featureResolver.getInstalledFeatureDefinitions());
        ArrayList<String> extensionRepos = new ArrayList<String>();
        for (ProvisioningFeatureDefinition fd : allFeatureDefs) {
            File featureDefinitionFile;
            String repoType;
            File checksumFile;
            BundleRepositoryRegistry.BundleRepositoryHolder brh = BundleRepositoryRegistry.getRepositoryHolder((String)fd.getBundleRepositoryType());
            ContentBasedLocalBundleRepository br = brh.getBundleRepository();
            Collection<FeatureResource> frs = fd.getConstituents(null);
            File libFixes = new File(installRoot, "lib/fixes");
            block7: for (FeatureResource fr : frs) {
                switch (fr.getType()) {
                    case FEATURE_TYPE: {
                        discoveredFeatures.add(fr.getSymbolicName());
                        break;
                    }
                    case BUNDLE_TYPE: 
                    case JAR_TYPE: 
                    case BOOT_JAR_TYPE: {
                        Object osList3;
                        File b = br.selectBundle(fr.getLocation(), fr.getSymbolicName(), fr.getVersionRange());
                        File bb = br.selectBaseBundle(fr.getLocation(), fr.getSymbolicName(), fr.getVersionRange());
                        if (b != null && bb != null) {
                            boolean pathsSame = b.getAbsolutePath().equals(bb.getAbsolutePath());
                            absPathsForLibertyContent.add(b.getAbsolutePath());
                            if (!pathsSame) {
                                absPathsForLibertyContent.add(bb.getAbsolutePath());
                            }
                            if ((osList3 = fr.getOsList()) == null) continue block7;
                            Iterator<String> iterator = osList3.iterator();
                            while (iterator.hasNext()) {
                                String os = iterator.next();
                                ArrayList<String> pathsForOs = (ArrayList<String>)specificPlatformPathsByPlatform.get(os);
                                if (pathsForOs == null) {
                                    pathsForOs = new ArrayList<String>();
                                    specificPlatformPathsByPlatform.put(os, pathsForOs);
                                }
                                pathsForOs.add(b.getAbsolutePath());
                                if (pathsSame) continue;
                                pathsForOs.add(bb.getAbsolutePath());
                            }
                            continue block7;
                        }
                        List<String> osList2 = fr.getOsList();
                        if (osList2 != null) break;
                        Tr.warning((TraceComponent)tc, (String)"ERROR_MISSING_FEATURE_RESOURCE", (Object[])new Object[]{fd.getFeatureName(), fr.getMatchString()});
                        break;
                    }
                    case FILE_TYPE: {
                        String locString = fr.getLocation();
                        if (locString != null) {
                            String[] locs = locString.contains(",") ? locString.split(",") : new String[]{locString};
                            for (String loc : locs) {
                                File test = new File(loc);
                                if (!test.isAbsolute()) {
                                    test = new File(brh.getInstallDir(), loc);
                                }
                                if ((loc = test.getAbsolutePath()).startsWith(libFixes.getAbsolutePath() + File.separator)) {
                                    fixes.add(fr);
                                } else {
                                    absPathsForLibertyContent.add(loc);
                                }
                                List<String> osList = fr.getOsList();
                                if (osList == null) continue;
                                for (String os : osList) {
                                    ArrayList<String> pathsForOs = (ArrayList<String>)specificPlatformPathsByPlatform.get(os);
                                    if (pathsForOs == null) {
                                        pathsForOs = new ArrayList<String>();
                                        specificPlatformPathsByPlatform.put(os, pathsForOs);
                                    }
                                    pathsForOs.add(loc);
                                }
                            }
                            continue block7;
                        }
                        Tr.warning((TraceComponent)tc, (String)"ERROR_UNKNOWN_FEATURE_RESOURCE_TYPE", (Object[])new Object[]{fd.getFeatureName(), fr.getSymbolicName(), "file"});
                        break;
                    }
                    case UNKNOWN: {
                        Tr.warning((TraceComponent)tc, (String)"ERROR_UNKNOWN_FEATURE_RESOURCE_TYPE", (Object[])new Object[]{fd.getFeatureName(), fr.getSymbolicName(), fr.getRawType()});
                        String loc = fr.getLocation();
                        if (loc == null) break;
                        File test = new File(loc);
                        if (!test.isAbsolute()) {
                            test = new File(installRoot, loc);
                        }
                        absPathsForLibertyContent.add(test.getAbsolutePath());
                        List<String> osList = fr.getOsList();
                        if (osList == null) continue block7;
                        Object osList3 = osList.iterator();
                        while (osList3.hasNext()) {
                            String os = (String)osList3.next();
                            ArrayList<String> pathsForOs = (ArrayList<String>)specificPlatformPathsByPlatform.get(os);
                            if (pathsForOs == null) {
                                pathsForOs = new ArrayList<String>();
                                specificPlatformPathsByPlatform.put(os, pathsForOs);
                            }
                            pathsForOs.add(test.getAbsolutePath());
                        }
                        continue block7;
                    }
                }
            }
            for (File nls : fd.getLocalizationFiles()) {
                if (!nls.exists()) continue;
                absPathsForLibertyContent.add(nls.getAbsolutePath());
            }
            File featureFile = fd.getFeatureDefinitionFile();
            if (featureFile != null) {
                absPathsForLibertyContent.add(featureFile.getAbsolutePath());
            }
            if ((checksumFile = fd.getFeatureChecksumFile()) != null) {
                absPathsForLibertyContent.add(checksumFile.getAbsolutePath());
            }
            if ((repoType = fd.getBundleRepositoryType()) != null && !"".equals(repoType) && !"usr".equals(repoType)) {
                extensionRepos.add(repoType);
            }
            if ((featureDefinitionFile = fd.getFeatureDefinitionFile()) == null) continue;
            File featureDefinitionParent = featureDefinitionFile.getParentFile();
            Collection<String> expectedIcons = fd.getIcons();
            if (featureDefinitionParent == null || expectedIcons == null) continue;
            File iconsFolder = new File(featureDefinitionParent, "icons/" + fd.getSymbolicName());
            this.scanFolderForIcons(absPathsForLibertyContent, iconsFolder.getAbsolutePath(), iconsFolder, expectedIcons);
        }
        for (String extensionRepo : extensionRepos) {
            WsResource extensionProperties = this.locationService.getRuntimeResource("etc/extensions/" + extensionRepo + ".properties");
            absPathsForLibertyContent.add(this.locationService.resolveResource(extensionProperties.toRepositoryPath()).asFile().getAbsolutePath());
        }
        HashSet<String> manifestJars = new HashSet<String>();
        manifestJars.addAll(absPathsForLibertyContent);
        this.gatherManifestClasspathJars(absPathsForLibertyContent, manifestJars);
        manifestJars.removeAll(absPathsForLibertyContent);
        absPathsForLibertyContent.addAll(manifestJars);
        this.addRequiredFixFiles(installRoot, absPathsForLibertyContent, fixes);
        String OS_REMOVE_CHAR = "-";
        Hashtable d = new Hashtable();
        final String[] pathArray = absPathsForLibertyContent.toArray(new String[0]);
        this.bundleContext.registerService(ServerContent.class, (Object)new ServerContent(){
            static final long serialVersionUID = -6222113764539907952L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public String[] getServerContentPaths(String osRequest) throws IOException {
                if (osRequest == null || osRequest.isEmpty() || "all".equals(osRequest)) {
                    return pathArray;
                }
                String[] osNames = osRequest.split(",");
                boolean add = true;
                for (String string : osNames) {
                    if (!string.startsWith("-")) continue;
                    add = false;
                }
                if (add) {
                    for (Map.Entry entry : specificPlatformPathsByPlatform.entrySet()) {
                        absPathsForLibertyContent.removeAll((Collection)entry.getValue());
                    }
                    for (String string : osNames) {
                        List osPaths;
                        if (string.startsWith("-") || (osPaths = (List)specificPlatformPathsByPlatform.get(string)) == null || osPaths.isEmpty()) continue;
                        absPathsForLibertyContent.addAll(osPaths);
                        for (String osPath : osPaths) {
                            if (FileUtils.fileExists((File)new File(osPath))) continue;
                            throw new FileNotFoundException(osPath);
                        }
                    }
                } else {
                    for (String string : osNames) {
                        List osPaths;
                        if (string.startsWith("-")) {
                            String string2 = string.substring(1);
                            osPaths = (List)specificPlatformPathsByPlatform.get(string2);
                            if (osPaths == null || osPaths.isEmpty()) continue;
                            absPathsForLibertyContent.removeAll(osPaths);
                            continue;
                        }
                        osPaths = (List)specificPlatformPathsByPlatform.get(string);
                        if (osPaths == null || osPaths.isEmpty()) continue;
                        for (String osPath : osPaths) {
                            if (FileUtils.fileExists((File)new File(osPath))) continue;
                            throw new FileNotFoundException(osPath);
                        }
                    }
                }
                return absPathsForLibertyContent.toArray(new String[0]);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        }, d);
    }

    private void scanFolderForIcons(Collection<String> iconPaths, String baseFolder, File iconsFolder, Collection<String> icons) {
        if (iconsFolder != null && iconsFolder.exists() && baseFolder != null) {
            block0: for (File fileInIconFolder : iconsFolder.listFiles()) {
                if (fileInIconFolder.isDirectory()) {
                    this.scanFolderForIcons(iconPaths, baseFolder, fileInIconFolder, icons);
                    continue;
                }
                String absPath = fileInIconFolder.getAbsolutePath();
                for (String iconAbsPath : icons) {
                    String relativePath = absPath.replaceAll("\\\\", "/").substring(baseFolder.length() + 1);
                    if (!relativePath.equals(iconAbsPath)) continue;
                    iconPaths.add(absPath);
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void gatherManifestClasspathJars(Set<String> sources, Set<String> found) {
        HashSet<String> foundFromHere = new HashSet<String>();
        for (String s : sources) {
            JarFile jar;
            block7: {
                File test = new File(s);
                File parent = test.getParentFile();
                if (!test.isFile() || !s.endsWith(".jar")) continue;
                jar = null;
                try {
                    String[] jars;
                    jar = new JarFile(test);
                    String cp = jar.getManifest().getMainAttributes().getValue("Class-Path");
                    if (cp == null) break block7;
                    for (String j : jars = cp.split(" ")) {
                        String abs;
                        File mfJar = new File(parent, j);
                        if (!mfJar.isFile() || found.contains(abs = mfJar.getCanonicalPath())) continue;
                        foundFromHere.add(mfJar.getCanonicalPath());
                    }
                }
                catch (IOException cp) {
                    try {
                        void e;
                        FFDCFilter.processException((Throwable)cp, (String)"com.ibm.ws.kernel.feature.internal.ServerContentHelper", (String)"444", (Object)this, (Object[])new Object[]{sources, found});
                        Tr.warning((TraceComponent)tc, (String)"ERROR_OPENING_JAR_FOR_CLASSPATH", (Object[])new Object[]{test.getAbsolutePath(), e});
                    }
                    catch (Throwable throwable) {
                        ServerContentHelper.tryToClose(jar);
                        throw throwable;
                    }
                    ServerContentHelper.tryToClose(jar);
                    continue;
                }
            }
            ServerContentHelper.tryToClose(jar);
        }
        if (!foundFromHere.isEmpty()) {
            HashSet<String> newFound = new HashSet<String>();
            newFound.addAll(sources);
            newFound.addAll(foundFromHere);
            this.gatherManifestClasspathJars(foundFromHere, newFound);
            newFound.removeAll(sources);
            found.addAll(newFound);
        }
    }

    private void addRequiredFixFiles(File installRoot, Set<String> absPathsForLibertyContent, Collection<FeatureResource> fixes) {
        for (FeatureResource fixFile : fixes) {
            String fixFileLoc = fixFile.getLocation();
            File f = new File(installRoot, fixFileLoc);
            String absFixFileLoc = f.getAbsolutePath();
            if (fixFileLoc.regionMatches(true, fixFileLoc.length() - 4, ".xml", 0, 4)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Evaluating fix xml " + fixFileLoc), (Object[])new Object[0]);
                }
                try {
                    DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document d = db.parse(f);
                    NodeList fl = d.getChildNodes();
                    block5: for (int x = 0; x < fl.getLength(); ++x) {
                        Node fn = fl.item(x);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("n.getNodeName(" + x + ")" + fn.getNodeName() + " element?" + (fn instanceof Element)), (Object[])new Object[0]);
                        }
                        if (!(fn instanceof Element) || !"fix".equals(fn.getNodeName())) continue;
                        NodeList nl = fn.getChildNodes();
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Node n = nl.item(i);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("n.getNodeName(" + i + ")" + n.getNodeName() + " element?" + (n instanceof Element)), (Object[])new Object[0]);
                            }
                            if (!(n instanceof Element) || !"updates".equals(n.getNodeName())) continue;
                            NodeList files = n.getChildNodes();
                            for (int j = 0; j < files.getLength(); ++j) {
                                File testFile;
                                Node o = files.item(j);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("o.getNodeName(" + j + ")" + o.getNodeName() + " element?" + (o instanceof Element)), (Object[])new Object[0]);
                                }
                                if (!(o instanceof Element) || !"file".equals(o.getNodeName())) continue;
                                Element eo = (Element)o;
                                String oName = eo.getAttribute("id");
                                String oHash = eo.getAttribute("hash");
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("eo.getNodeName()" + eo.getNodeName() + " oName:" + oName + " oHash:" + oHash), (Object[])new Object[0]);
                                }
                                if (!FileUtils.fileExists((File)(testFile = new File(installRoot, oName)))) continue;
                                String tHash = HashUtils.getFileMD5String(testFile);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("tHash:" + tHash), (Object[])new Object[0]);
                                }
                                if (!oHash.equals(tHash)) continue;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Keeping fix xml due to hash match" + fixFileLoc), (Object[])new Object[0]);
                                }
                                absPathsForLibertyContent.add(absFixFileLoc);
                                continue block5;
                            }
                            continue block5;
                        }
                    }
                    continue;
                }
                catch (ParserConfigurationException db) {
                    FFDCFilter.processException((Throwable)db, (String)"com.ibm.ws.kernel.feature.internal.ServerContentHelper", (String)"554", (Object)this, (Object[])new Object[]{installRoot, absPathsForLibertyContent, fixes});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to parse file " + fixFileLoc + " due to parser config error, file will be kept regardless"), (Object[])new Object[0]);
                    }
                    absPathsForLibertyContent.add(absFixFileLoc);
                    continue;
                }
                catch (SAXException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.feature.internal.ServerContentHelper", (String)"560", (Object)this, (Object[])new Object[]{installRoot, absPathsForLibertyContent, fixes});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to parse file " + fixFileLoc + " due to sax error, file will be kept regardless"), (Object[])new Object[0]);
                    }
                    absPathsForLibertyContent.add(absFixFileLoc);
                    continue;
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.feature.internal.ServerContentHelper", (String)"566", (Object)this, (Object[])new Object[]{installRoot, absPathsForLibertyContent, fixes});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to parse file " + fixFileLoc + " due to io error, file will be kept regardless"), (Object[])new Object[0]);
                    }
                    absPathsForLibertyContent.add(absFixFileLoc);
                    continue;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to parse file " + fixFileLoc + " not xml, file will be kept regardless"), (Object[])new Object[0]);
            }
            absPathsForLibertyContent.add(absFixFileLoc);
        }
    }

    @FFDCIgnore(value={IOException.class})
    private static final void tryToClose(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

