/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.attachment.AttachmentMarshaller;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBase;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.jaxb.attachment.JAXBAttachmentMarshaller;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.ws.commons.schema.XmlSchemaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataWriterImpl<T>
extends JAXBDataBase
implements DataWriter<T> {
    private static final Logger LOG = LogUtils.getLogger(JAXBDataBinding.class);
    private final JAXBDataBinding databinding;

    public DataWriterImpl(JAXBDataBinding binding) {
        super(binding.getContext());
        this.databinding = binding;
    }

    public void write(Object obj, T output) {
        this.write(obj, null, output);
    }

    public Marshaller createMarshaller(Object elValue, MessagePartInfo part) {
        Marshaller marshaller;
        Class<?> cls = null;
        if (part != null) {
            cls = part.getTypeClass();
        }
        if (cls == null) {
            Class<?> clazz = cls = null != elValue ? elValue.getClass() : null;
        }
        if (cls != null && cls.isArray() && elValue instanceof Collection) {
            Collection col = (Collection)elValue;
            elValue = col.toArray((Object[])Array.newInstance(cls.getComponentType(), col.size()));
        }
        try {
            marshaller = this.databinding.getJAXBMarshaller();
            if (Boolean.FALSE.equals(marshaller.getProperty("jaxb.fragment")) && marshaller.getAttachmentMarshaller() == null) {
                Map nspref;
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
                marshaller.setListener(this.databinding.getMarshallerListener());
                if (this.databinding.getValidationEventHandler() != null) {
                    marshaller.setEventHandler(this.databinding.getValidationEventHandler());
                }
                if ((nspref = this.databinding.getDeclaredNamespaceMappings()) != null) {
                    JAXBUtils.setNamespaceWrapper((Map)nspref, (Marshaller)marshaller);
                }
                if (this.databinding.getMarshallerProperties() != null) {
                    for (Map.Entry<String, Object> propEntry : this.databinding.getMarshallerProperties().entrySet()) {
                        try {
                            marshaller.setProperty(propEntry.getKey(), propEntry.getValue());
                        }
                        catch (PropertyException pe) {
                            LOG.log(Level.INFO, "PropertyException setting Marshaller properties", pe);
                        }
                    }
                }
            }
            marshaller.setSchema(this.schema);
            AttachmentMarshaller atmarsh = this.getAttachmentMarshaller();
            marshaller.setAttachmentMarshaller(atmarsh);
            if (this.schema != null && atmarsh instanceof JAXBAttachmentMarshaller) {
                marshaller.setEventHandler((ValidationEventHandler)new MtomValidationHandler(marshaller.getEventHandler(), (JAXBAttachmentMarshaller)atmarsh));
            }
        }
        catch (JAXBException ex) {
            if (ex instanceof MarshalException) {
                MarshalException marshalEx = (MarshalException)ex;
                Message faultMessage = new Message("MARSHAL_ERROR", LOG, new Object[]{marshalEx.getLinkedException().getMessage()});
                throw new Fault(faultMessage, (Throwable)ex);
            }
            throw new Fault(new Message("MARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        return marshaller;
    }

    public void write(Object obj, MessagePartInfo part, T output) {
        boolean honorJaxbAnnotation = this.honorJAXBAnnotations(part);
        if (part != null && !part.isElement() && part.getTypeClass() != null) {
            honorJaxbAnnotation = true;
        }
        Marshaller marshaller = null;
        if (obj != null || !(part.getXmlSchema() instanceof XmlSchemaElement)) {
            if (obj instanceof Exception && part != null && Boolean.TRUE.equals(part.getProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION"))) {
                marshaller = this.createMarshaller(obj, part);
                JAXBEncoderDecoder.marshallException(marshaller, (Exception)obj, part, output);
            } else {
                Annotation[] anns = this.getJAXBAnnotation(part);
                if (!honorJaxbAnnotation || anns.length == 0) {
                    marshaller = this.createMarshaller(obj, part);
                    JAXBEncoderDecoder.marshall(marshaller, obj, part, output);
                } else if (honorJaxbAnnotation && anns.length > 0) {
                    JAXBEncoderDecoder.marshalWithBridge(part.getConcreteName(), part.getTypeClass(), anns, this.databinding.getContextClasses(), obj, output, this.getAttachmentMarshaller());
                }
            }
        } else if (this.needToRender(obj, part)) {
            marshaller = this.createMarshaller(obj, part);
            JAXBEncoderDecoder.marshallNullElement(marshaller, output, part);
        }
        this.databinding.releaseJAXBMarshaller(marshaller);
    }

    private boolean needToRender(Object obj, MessagePartInfo part) {
        if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)part.getXmlSchema();
            return element.isNillable() && element.getMinOccurs() > 0L;
        }
        return false;
    }

    private static class MtomValidationHandler
    implements ValidationEventHandler {
        ValidationEventHandler origHandler;
        JAXBAttachmentMarshaller marshaller;

        public MtomValidationHandler(ValidationEventHandler v, JAXBAttachmentMarshaller m) {
            this.origHandler = v;
            this.marshaller = m;
        }

        public boolean handleEvent(ValidationEvent event) {
            String msg = event.getMessage();
            if (msg.startsWith("cvc-type.3.1.2: ") && msg.contains(this.marshaller.getLastMTOMElementName().getLocalPart())) {
                return true;
            }
            if (this.origHandler != null) {
                return this.origHandler.handleEvent(event);
            }
            return false;
        }
    }
}

