/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.injectionengine.InternalInjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;

public class MethodMap
extends HashMap<String, List<Method>> {
    private static final long serialVersionUID = 4877455330504864506L;
    private static final String CLASS_NAME = MethodMap.class.getName();
    private static final TraceComponent tc = Tr.register(MethodMap.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");

    static boolean modifierIsDefaultAccess(int modifiers) {
        return (modifiers & 7) == 0;
    }

    private static String getPackageName(Class<?> klass) {
        String className = klass.getName();
        int index = className.lastIndexOf(46);
        return index == -1 ? "" : className.substring(0, index);
    }

    public static Collection<MethodInfo> getAllDeclaredMethods(Class<?> clazz) {
        return MethodMap.getMethods(clazz, true);
    }

    public static Collection<MethodInfo> getAllNonPrivateMethods(Class<?> clazz) {
        return MethodMap.getMethods(clazz, false);
    }

    private static Collection<MethodInfo> getMethods(Class<?> clazz, boolean includePrivate) {
        SequencedCollection<MethodInfo> methodInfos;
        boolean isTraceOn;
        block20: {
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getAllDeclaredMethods : " + clazz), (Object[])new Object[0]);
            }
            if (clazz == null || clazz.isInterface()) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getAllDeclaredMethods : None - interface or null.");
                }
                return Collections.emptyList();
            }
            Class<?> thisClass = null;
            methodInfos = new LinkedHashSet<MethodInfo>();
            try {
                HashMap defaultAccessMethods = null;
                int classDepth = 0;
                thisClass = clazz;
                while (thisClass != Object.class) {
                    for (Method method : thisClass.getDeclaredMethods()) {
                        MethodInfo methodInfo;
                        boolean added;
                        if (!includePrivate && Modifier.isPrivate(method.getModifiers()) || (added = methodInfos.add(methodInfo = new MethodInfo(method, classDepth))) || !MethodMap.modifierIsDefaultAccess(method.getModifiers())) continue;
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("potentially non-overridden " + methodInfo), (Object[])new Object[0]);
                        }
                        if (defaultAccessMethods == null) {
                            defaultAccessMethods = new HashMap();
                        }
                        if (defaultAccessMethods.containsKey(methodInfo)) continue;
                        defaultAccessMethods.put(methodInfo, new HashSet());
                    }
                    thisClass = thisClass.getSuperclass();
                    ++classDepth;
                }
                if (defaultAccessMethods != null) {
                    ArrayList<MethodInfo> newMethodInfos = null;
                    classDepth = 0;
                    thisClass = clazz;
                    while (thisClass != Object.class) {
                        String thisClassPackageName = null;
                        ClassLoader thisClassLoader = null;
                        for (Method method : thisClass.getDeclaredMethods()) {
                            MethodInfo methodInfo;
                            Set methodPackages;
                            if (Modifier.isPrivate(method.getModifiers()) || (methodPackages = (Set)defaultAccessMethods.get(methodInfo = new MethodInfo(method, classDepth))) == null) continue;
                            if (thisClassPackageName == null) {
                                thisClassPackageName = MethodMap.getPackageName(thisClass);
                                thisClassLoader = thisClass.getClassLoader();
                            }
                            boolean first = methodPackages.isEmpty();
                            boolean added = methodPackages.add(new RuntimePackage(thisClassLoader, thisClassPackageName));
                            if (first || !added || !MethodMap.modifierIsDefaultAccess(method.getModifiers())) continue;
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("non-overridden " + methodInfo), (Object[])new Object[0]);
                            }
                            if (newMethodInfos == null) {
                                newMethodInfos = new ArrayList<MethodInfo>();
                            }
                            newMethodInfos.add(methodInfo);
                        }
                        thisClass = thisClass.getSuperclass();
                        ++classDepth;
                    }
                    if (newMethodInfos != null) {
                        MethodInfo[] methodInfosArray = new MethodInfo[methodInfos.size() + newMethodInfos.size()];
                        methodInfos.toArray(methodInfosArray);
                        int n = methodInfos.size();
                        for (int i = 0; i < newMethodInfos.size(); ++i) {
                            methodInfosArray[++var10_21] = (MethodInfo)newMethodInfos.get(i);
                        }
                        Collections.sort(newMethodInfos, new Comparator<MethodInfo>(){

                            @Override
                            public int compare(MethodInfo methodInfo1, MethodInfo methodInfo2) {
                                return methodInfo1.ivClassDepth - methodInfo2.ivClassDepth;
                            }
                        });
                        methodInfos = Arrays.asList(methodInfosArray);
                    }
                }
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getAllDeclaredMethods"), (String)"106", (Object[])new Object[]{thisClass, clazz, methodInfos});
                InternalInjectionEngine injectionEngine = InjectionEngineAccessor.getInternalInstance();
                if (thisClass != clazz) {
                    Tr.warning((TraceComponent)tc, (String)"SUPER_METHOD_ANNOTATIONS_IGNORED_CWNEN0050W", (Object[])new Object[]{thisClass.getName(), clazz.getName(), ex.toString()});
                    if (injectionEngine == null || injectionEngine.isValidationFailable(false)) {
                        throw new RuntimeException("Resource annotations on the methods of the " + thisClass.getName() + " class could not be processed. The " + thisClass.getName() + " class is being processed for annotations because it is referenced by the " + clazz.getName() + " application class. The annotations could not be obtained because of the exception : " + ex, ex);
                    }
                }
                Tr.warning((TraceComponent)tc, (String)"METHOD_ANNOTATIONS_IGNORED_CWNEN0049W", (Object[])new Object[]{thisClass.getName(), ex.toString()});
                if (injectionEngine != null && !injectionEngine.isValidationFailable(false)) break block20;
                throw new RuntimeException("Resource annotations on the methods of the " + thisClass.getName() + " class could not be processed. The annotations could not be obtained because of the exception : " + ex, ex);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAllDeclaredMethods : " + clazz + " : " + methodInfos));
        }
        return methodInfos;
    }

    private static class RuntimePackage {
        private final ClassLoader ivClassLoader;
        private final String ivPackageName;
        private final int ivHashCode;

        private RuntimePackage(ClassLoader classLoader, String packageName) {
            this.ivClassLoader = classLoader;
            this.ivPackageName = packageName;
            this.ivHashCode = System.identityHashCode(classLoader) * 31 + packageName.hashCode();
        }

        public String toString() {
            return super.toString() + '[' + this.ivClassLoader + ", " + this.ivPackageName + ']';
        }

        public int hashCode() {
            return this.ivHashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof RuntimePackage) {
                RuntimePackage runtimePackage = (RuntimePackage)object;
                return this.ivHashCode == runtimePackage.ivHashCode && this.ivClassLoader == runtimePackage.ivClassLoader && this.ivPackageName.equals(runtimePackage.ivPackageName);
            }
            return false;
        }
    }

    public static final class MethodInfo {
        private final Method ivMethod;
        private final Class<?>[] ivParamTypes;
        private final int ivClassDepth;
        private final int ivHashCode;

        MethodInfo(Method method, int classDepth) {
            this.ivMethod = method;
            this.ivParamTypes = method.getParameterTypes();
            this.ivClassDepth = classDepth;
            this.ivHashCode = method.getName().hashCode() * 31 + Arrays.hashCode(this.ivParamTypes);
        }

        public String toString() {
            return this.ivMethod.toString() + ':' + this.ivClassDepth;
        }

        public int hashCode() {
            return this.ivHashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof MethodInfo) {
                MethodInfo info = (MethodInfo)object;
                return this.ivHashCode == info.ivHashCode && !Modifier.isPrivate(this.ivMethod.getModifiers()) && !Modifier.isPrivate(info.ivMethod.getModifiers()) && this.ivMethod.getName().equals(info.ivMethod.getName()) && Arrays.equals(this.ivParamTypes, info.ivParamTypes);
            }
            return false;
        }

        public Method getMethod() {
            return this.ivMethod;
        }

        public int getNumParameters() {
            return this.ivParamTypes.length;
        }

        public Class<?> getParameterType(int index) {
            return this.ivParamTypes[index];
        }

        public int getClassDepth() {
            return this.ivClassDepth;
        }
    }
}

