/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CookieHelper {
    static final long serialVersionUID = -1218781730666688315L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Sensitive
    public static String getCookieValue(Cookie[] cookies, String cookieName) {
        if (cookies == null) {
            return null;
        }
        String retVal = null;
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookieName.equalsIgnoreCase(cookies[i].getName())) continue;
            retVal = cookies[i].getValue();
            break;
        }
        return retVal;
    }

    public static String[] getCookieValues(Cookie[] cookies, String cookieName) {
        if (cookies == null) {
            return null;
        }
        Vector<String> retValues = new Vector<String>();
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookieName.equalsIgnoreCase(cookies[i].getName())) continue;
            retValues.add(cookies[i].getValue());
        }
        if (retValues.size() > 0) {
            return retValues.toArray(new String[retValues.size()]);
        }
        return null;
    }

    public static void addCookiesToResponse(List<Cookie> cookieList, HttpServletResponse resp) {
        ListIterator<Cookie> iterator = cookieList.listIterator();
        while (iterator.hasNext()) {
            Cookie cookie = (Cookie)iterator.next();
            if (cookie == null) continue;
            resp.addCookie(cookie);
        }
    }

    @Sensitive
    public static void clearCookie(HttpServletRequest req, HttpServletResponse res, String cookieName, Cookie[] cookies) {
        Cookie existing = CookieHelper.getCookie(cookies, cookieName);
        if (existing != null) {
            Cookie c = new Cookie(cookieName, "");
            String path = existing.getPath();
            if (path == null) {
                path = "/";
            }
            c.setPath(path);
            c.setMaxAge(0);
            c.setSecure(existing.getSecure());
            res.addCookie(c);
        }
    }

    @Sensitive
    public static Cookie getCookie(Cookie[] cookies, String cookieName) {
        if (cookies == null) {
            return null;
        }
        Cookie retVal = null;
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookieName.equalsIgnoreCase(cookies[i].getName())) continue;
            retVal = cookies[i];
            break;
        }
        return retVal;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CookieHelper.class);
    }
}

