/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.WebSecurityContext;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.MatchResponse;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebRequestImpl
implements WebRequest {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final String appName;
    private final WebSecurityContext webSecurityContext;
    private final MatchResponse matchResponse;
    private final SecurityMetadata securityMetadata;
    private final WebAppSecurityConfig config;
    private boolean formLoginRedirect = true;
    private boolean callAfterSSO = true;
    private boolean unprotectedURI = false;
    private boolean specialUnprotectedURI = false;
    private Map<String, Object> propMap = null;
    static final long serialVersionUID = 4913278820787590755L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebRequestImpl(HttpServletRequest req, HttpServletResponse resp, SecurityMetadata securityMetadata, WebAppSecurityConfig config) {
        this(req, resp, null, null, securityMetadata, null, config);
    }

    public WebRequestImpl(HttpServletRequest req, HttpServletResponse resp, String appName, WebSecurityContext webSecurityContext, SecurityMetadata securityMetadata, MatchResponse matchResponse, WebAppSecurityConfig config) {
        this.request = req;
        this.response = resp;
        this.appName = appName;
        this.webSecurityContext = webSecurityContext;
        this.matchResponse = matchResponse;
        this.securityMetadata = securityMetadata;
        this.config = config;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public WebSecurityContext getWebSecurityContext() {
        return this.webSecurityContext;
    }

    @Override
    public boolean isFormLoginRedirectEnabled() {
        return this.formLoginRedirect;
    }

    @Override
    public List<String> getRequiredRoles() {
        return this.matchResponse.getRoles();
    }

    @Override
    public boolean isSSLRequired() {
        return this.matchResponse.isSSLRequired();
    }

    @Override
    public boolean isAccessPrecluded() {
        return this.matchResponse.isAccessPrecluded();
    }

    @Override
    public SecurityMetadata getSecurityMetadata() {
        return this.securityMetadata;
    }

    @Override
    public LoginConfiguration getLoginConfig() {
        LoginConfiguration loginConfig = this.securityMetadata != null ? this.securityMetadata.getLoginConfiguration() : null;
        return loginConfig;
    }

    @Override
    public FormLoginConfiguration getFormLoginConfiguration() {
        return this.securityMetadata.getLoginConfiguration().getFormLoginConfiguration();
    }

    @Override
    public MatchResponse getMatchResponse() {
        return this.matchResponse;
    }

    private boolean determineIfRequestHasAuthenticationData() {
        boolean hasBasicAuthHeader = this.request.getHeader("Authorization") != null;
        boolean hasClientCertHeader = false;
        LoginConfiguration loginConfig = this.getLoginConfig();
        String authenticationMethod = null;
        if (loginConfig != null) {
            authenticationMethod = loginConfig.getAuthenticationMethod();
        }
        if ("CLIENT_CERT".equals(authenticationMethod)) {
            X509Certificate[] certChain = (X509Certificate[])this.request.getAttribute("javax.net.ssl.peer_certificates");
            hasClientCertHeader = certChain != null && certChain.length != 0;
        }
        boolean hasSSOToken = false;
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            hasSSOToken = false;
        } else {
            String cookieName = this.config.getSSOCookieName();
            String[] hdrVals = CookieHelper.getCookieValues(cookies, cookieName);
            if (hdrVals == null && !"LtpaToken2".equalsIgnoreCase(cookieName)) {
                hdrVals = CookieHelper.getCookieValues(cookies, "LtpaToken2");
            }
            if (hdrVals != null) {
                hasSSOToken = true;
            }
        }
        return hasBasicAuthHeader || hasClientCertHeader || hasSSOToken;
    }

    @Override
    public boolean hasAuthenticationData() {
        return this.determineIfRequestHasAuthenticationData();
    }

    @Override
    public boolean isUnprotectedURI() {
        return this.unprotectedURI;
    }

    @Override
    public void setUnprotectedURI(boolean unprotectedURI) {
        this.unprotectedURI = unprotectedURI;
    }

    @Override
    public void disableFormLoginRedirect() {
        this.formLoginRedirect = false;
    }

    @Override
    public boolean isProviderSpecialUnprotectedURI() {
        return this.specialUnprotectedURI;
    }

    @Override
    public void setProviderSpecialUnprotectedURI(boolean specialUnprotectedURI) {
        this.specialUnprotectedURI = specialUnprotectedURI;
    }

    @Override
    public void setCallAfterSSO(boolean callAfterSSO) {
        this.callAfterSSO = callAfterSSO;
    }

    @Override
    public boolean isCallAfterSSO() {
        return this.callAfterSSO;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.propMap;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.propMap = props;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WebRequestImpl.class);
    }
}

