/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.jacc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.AuditAuthResult;
import com.ibm.websphere.security.audit.AuditAuthenticationResult;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authorization.jacc.JaccService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.WebAppAuthorizationHelper;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.internal.DenyReply;
import com.ibm.ws.webcontainer.security.internal.PermitReply;
import com.ibm.ws.webcontainer.security.internal.WebReply;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebAppJaccAuthorizationHelper
implements WebAppAuthorizationHelper {
    private static final TraceComponent tc = Tr.register(WebAppJaccAuthorizationHelper.class);
    private AtomicServiceReference<JaccService> jaccServiceRef = null;
    private static final WebReply DENY_AUTHZ_FAILED = new DenyReply("AuthorizationFailed");
    static final long serialVersionUID = 1384046265068975243L;

    public WebAppJaccAuthorizationHelper(AtomicServiceReference<JaccService> ref) {
        this.jaccServiceRef = ref;
    }

    @Override
    public boolean isUserInRole(String role, IExtendedRequest req, Subject subject) {
        String servletName = null;
        RequestProcessor reqProc = req.getWebAppDispatcherContext().getCurrentServletReference();
        if (reqProc != null) {
            servletName = reqProc.getName();
        }
        return ((JaccService)this.jaccServiceRef.getService()).isSubjectInRole(this.getApplicationName(), this.getModuleName(), servletName, role, (Object)req, subject);
    }

    @Override
    public boolean authorize(AuthenticationResult authResult, WebRequest webRequest, String uriName) {
        AuditAuthenticationResult auditAuthResult;
        WebReply reply;
        HttpServletRequest req = webRequest.getHttpServletRequest();
        boolean isAuthorized = ((JaccService)this.jaccServiceRef.getService()).isAuthorized(this.getApplicationName(), this.getModuleName(), uriName, req.getMethod(), (Object)req, authResult.getSubject());
        WebReply webReply = reply = isAuthorized ? new PermitReply() : DENY_AUTHZ_FAILED;
        if (isAuthorized) {
            auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.SUCCESS, authResult.getSubject(), "BASIC", null, "success");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_02, (Object[])new Object[]{webRequest, authResult, uriName, "web", reply.getStatusCode()});
        } else {
            auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.FAILURE, authResult.getSubject(), "BASIC", null, "failure");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_02, (Object[])new Object[]{webRequest, authResult, uriName, "web", reply.getStatusCode()});
        }
        if (!isAuthorized) {
            String authUserName = authResult.getUserName();
            String authRealm = authResult.getRealm();
            String appName = webRequest.getApplicationName();
            if (authRealm != null && authUserName != null) {
                Tr.audit((TraceComponent)tc, (String)"SEC_JACC_AUTHZ_FAILED", (Object[])new Object[]{authUserName.concat(":").concat(authRealm), appName, uriName});
            } else {
                authUserName = authResult.getSubject().getPrincipals(WSPrincipal.class).iterator().next().getName();
                Tr.audit((TraceComponent)tc, (String)"SEC_JACC_AUTHZ_FAILED", (Object[])new Object[]{authUserName, appName, uriName});
            }
        }
        return isAuthorized;
    }

    @Override
    public boolean isSSLRequired(WebRequest webRequest, String uriName) {
        HttpServletRequest req = webRequest.getHttpServletRequest();
        boolean isSSLRequired = false;
        if (!req.isSecure()) {
            isSSLRequired = ((JaccService)this.jaccServiceRef.getService()).isSSLRequired(this.getApplicationName(), this.getModuleName(), uriName, req.getMethod(), (Object)req);
        }
        return isSSLRequired;
    }

    @Override
    public WebReply checkPrecludedAccess(WebRequest webRequest, String uriName) {
        DenyReply webReply = null;
        HttpServletRequest req = webRequest.getHttpServletRequest();
        boolean isExcluded = false;
        isExcluded = ((JaccService)this.jaccServiceRef.getService()).isAccessExcluded(this.getApplicationName(), this.getModuleName(), uriName, req.getMethod(), (Object)req);
        if (isExcluded) {
            webReply = new DenyReply("JACC provider denied the access.");
        }
        return webReply;
    }

    protected String getApplicationName() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        WebModuleMetaData wmmd = (WebModuleMetaData)((WebComponentMetaData)cmd).getModuleMetaData();
        return wmmd.getConfiguration().getApplicationName();
    }

    protected String getModuleName() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        WebModuleMetaData wmmd = (WebModuleMetaData)((WebComponentMetaData)cmd).getModuleMetaData();
        return wmmd.getConfiguration().getModuleName();
    }
}

