/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.ready;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.ApplicationStateCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.ExecutorService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AppManagerActivator
implements BundleActivator {
    private static final TraceComponent _tc = Tr.register(AppManagerActivator.class);
    static final long serialVersionUID = -8485194006187566410L;

    public void start(BundleContext context) throws Exception {
        ServiceReference serverStarted = context.getServiceReference("com.ibm.ws.kernel.feature.ServerStarted");
        if (serverStarted == null) {
            this.reportSlowlyStartingApps();
        } else {
            ExecutorService executor;
            ServiceReference executorRef = context.getServiceReference(ExecutorService.class);
            ExecutorService executorService = executor = executorRef == null ? null : (ExecutorService)context.getService(executorRef);
            if (executor == null) {
                this.reportSlowlyStartingApps();
            } else {
                executor.execute(new Runnable(){
                    static final long serialVersionUID = 8884708365157502817L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        AppManagerActivator.this.reportSlowlyStartingApps();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
                context.ungetService(executorRef);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportSlowlyStartingApps() {
        block3: {
            try {
                String[] slowApps = ApplicationStateCoordinator.getSlowlyStartingApps();
                if (slowApps != null && TraceComponent.isAnyTracingEnabled() && _tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"Stopped waiting for applications to start as the following did not start in time: ", (Object[])slowApps);
                }
            }
            catch (Exception slowApps) {
                void ex;
                FFDCFilter.processException((Throwable)slowApps, (String)"com.ibm.ws.app.manager.ready.AppManagerActivator", (String)"64", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"start.exception");
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)_tc, (String)"Exception waiting for applications to start: ", (Object[])new Object[]{ex});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void stop(BundleContext context) throws Exception {
        block3: {
            try {
                String[] slowApps = ApplicationStateCoordinator.getSlowlyStoppingApps();
                if (slowApps != null && TraceComponent.isAnyTracingEnabled() && _tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"Stopped waiting for applications to stop as the following apps did not stop in time: ", (Object[])slowApps);
                }
            }
            catch (Exception slowApps) {
                void ex;
                FFDCFilter.processException((Throwable)slowApps, (String)"com.ibm.ws.app.manager.ready.AppManagerActivator", (String)"81", (Object)this, (Object[])new Object[]{context});
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"stop.exception");
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)_tc, (String)"Exception waiting for applications to stop: ", (Object[])new Object[]{ex});
            }
        }
    }
}

