/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.impl.weld.injection.ResourceReferenceFactoryImpl;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.EjbEndpointService;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.cdi.internal.interfaces.WebSphereInjectionServices;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceRef;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BdaInjectionServicesImpl
implements EjbInjectionServices,
JaxwsInjectionServices,
JpaInjectionServices,
ResourceInjectionServices {
    private static final TraceComponent tc = Tr.register(BdaInjectionServicesImpl.class);
    private final WebSphereInjectionServices webSphereInjectionServices;
    private final EjbEndpointService ejbEndpointService;
    private final CDIArchive archive;
    private final CDIRuntime cdiRuntime;
    static final long serialVersionUID = 8268400074248896183L;

    public BdaInjectionServicesImpl(WebSphereInjectionServices webSphereInjectionServices, CDIRuntime cdiRuntime, WebSphereCDIDeployment cdiDeployment, CDIArchive archive) {
        this.webSphereInjectionServices = webSphereInjectionServices;
        this.ejbEndpointService = cdiRuntime.getEjbEndpointService();
        this.archive = archive;
        this.cdiRuntime = cdiRuntime;
    }

    private static boolean isProducer(InjectionPoint injectionPoint) {
        boolean isProducer = false;
        Produces produces = (Produces)injectionPoint.getAnnotated().getAnnotation(Produces.class);
        if (produces != null) {
            isProducer = true;
        }
        return isProducer;
    }

    private static void throwDefinitionException(InjectionPoint injectionPoint, Class<?> fieldType) throws DefinitionException {
        String producerFieldName = injectionPoint.getMember().getDeclaringClass().getName() + "." + injectionPoint.getMember().getName();
        String fieldTypeName = fieldType.getName();
        throw new DefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"resource.producer.validation.error.CWOWB1007E", (Object[])new Object[]{producerFieldName, fieldTypeName}));
    }

    @FFDCIgnore(value={ClassCastException.class})
    private void validateEjb(EJB ejb, InjectionPoint injectionPoint) {
        if (this.ejbEndpointService != null && injectionPoint.getType() instanceof Class) {
            Class ipClass = (Class)injectionPoint.getType();
            try {
                this.ejbEndpointService.validateEjbInjection(ejb, this.archive, ipClass);
            }
            catch (CDIException cDIException) {
                FFDCFilter.processException((Throwable)cDIException, (String)"com.ibm.ws.cdi.impl.weld.injection.BdaInjectionServicesImpl", (String)"113", (Object)this, (Object[])new Object[]{ejb, injectionPoint});
            }
            catch (ClassCastException e) {
                BdaInjectionServicesImpl.throwDefinitionException(injectionPoint, ipClass);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateJndiLookup(String lookupString, InjectionPoint injectionPoint) {
        try {
            this.cdiRuntime.beginContext(this.archive);
            InitialContext c = new InitialContext();
            this.validateJndiLookup(c, lookupString, injectionPoint);
        }
        catch (NamingException c) {
            FFDCFilter.processException((Throwable)c, (String)"com.ibm.ws.cdi.impl.weld.injection.BdaInjectionServicesImpl", (String)"139", (Object)this, (Object[])new Object[]{lookupString, injectionPoint});
        }
        catch (CDIException c) {
            void e;
            FFDCFilter.processException((Throwable)c, (String)"com.ibm.ws.cdi.impl.weld.injection.BdaInjectionServicesImpl", (String)"141", (Object)this, (Object[])new Object[]{lookupString, injectionPoint});
            throw new IllegalStateException((Throwable)e);
        }
        finally {
            this.cdiRuntime.endContext();
        }
    }

    private void validateJndiLookup(InitialContext c, String lookupString, InjectionPoint injectionPoint) throws NamingException, CDIException {
        Name lookupName = c.getNameParser("").parse(lookupString);
        String name = lookupName.get(lookupName.size() - 1);
        Name prefix = lookupName.getPrefix(lookupName.size() - 1);
        if (!(injectionPoint.getType() instanceof Class)) {
            return;
        }
        Class clazz = (Class)injectionPoint.getType();
        if (clazz.isPrimitive() || clazz.isArray()) {
            return;
        }
        NamingEnumeration<NameClassPair> contents = c.list(prefix);
        while (contents.hasMore()) {
            NameClassPair pair = contents.next();
            if (!name.equals(pair.getName())) continue;
            try {
                String className = pair.getClassName();
                Class<?> jndiClass = this.archive.getClassLoader().loadClass(className);
                if ("javax.resource.cci.ConnectionFactory".equals(className)) {
                    try {
                        Object o = c.lookup(lookupName);
                        if (o != null) {
                            jndiClass = o.getClass();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.cdi.impl.weld.injection.BdaInjectionServicesImpl", (String)"182", (Object)this, (Object[])new Object[]{c, lookupString, injectionPoint});
                    }
                } else {
                    try {
                        jndiClass = this.archive.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.cdi.impl.weld.injection.BdaInjectionServicesImpl", (String)"190", (Object)this, (Object[])new Object[]{c, lookupString, injectionPoint});
                    }
                }
                if (!clazz.isAssignableFrom(jndiClass)) {
                    BdaInjectionServicesImpl.throwDefinitionException(injectionPoint, clazz);
                    continue;
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.cdi.impl.weld.injection.BdaInjectionServicesImpl", (String)"200", (Object)this, (Object[])new Object[]{c, lookupString, injectionPoint});
            }
        }
    }

    private void validateWebServiceRef(WebServiceRef wsRef, Class<?> ipClass, InjectionPoint injectionPoint) {
        if (!wsRef.lookup().isEmpty()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Validating WebServiceRef injection point", (Object[])new Object[]{wsRef});
        }
        Class serviceClass = wsRef.value();
        Class effectiveClass = ipClass;
        if (ipClass.isAssignableFrom(wsRef.type())) {
            effectiveClass = wsRef.type();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Found service type and effective injection types", (Object[])new Object[]{serviceClass, effectiveClass});
        }
        if (Service.class.isAssignableFrom(effectiveClass)) {
            if (effectiveClass.getName().equals(Service.class.getName())) {
                if (!Service.class.isAssignableFrom(serviceClass) || serviceClass.getName().equals(Service.class.getName())) {
                    BdaInjectionServicesImpl.throwDefinitionException(injectionPoint, ipClass);
                }
            } else if (!serviceClass.getName().equals(effectiveClass.getName()) && !serviceClass.getName().equals(Service.class.getName())) {
                BdaInjectionServicesImpl.throwDefinitionException(injectionPoint, ipClass);
            }
        } else {
            HashSet portTypes = new HashSet();
            for (Method method : serviceClass.getMethods()) {
                if (method.getAnnotation(WebEndpoint.class) == null) continue;
                portTypes.add(method.getReturnType());
            }
            if (!portTypes.isEmpty()) {
                for (Class clazz : portTypes) {
                    if (!effectiveClass.isAssignableFrom(clazz)) continue;
                    return;
                }
                BdaInjectionServicesImpl.throwDefinitionException(injectionPoint, ipClass);
            }
        }
    }

    private <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint) {
        ResourceReferenceFactoryImpl resourceReferenceFactory = new ResourceReferenceFactoryImpl(this.webSphereInjectionServices, injectionPoint);
        return resourceReferenceFactory;
    }

    public ResourceReferenceFactory<Object> registerEjbInjectionPoint(InjectionPoint injectionPoint) {
        if (BdaInjectionServicesImpl.isProducer(injectionPoint)) {
            EJB ejb = (EJB)injectionPoint.getAnnotated().getAnnotation(EJB.class);
            this.validateEjb(ejb, injectionPoint);
        }
        ResourceReferenceFactory resourceReferenceFactory = this.getResourceReferenceFactory(injectionPoint);
        return resourceReferenceFactory;
    }

    @Deprecated
    public Object resolveEjb(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(InjectionPoint injectionPoint) {
        if (BdaInjectionServicesImpl.isProducer(injectionPoint)) {
            Resource res = (Resource)injectionPoint.getAnnotated().getAnnotation(Resource.class);
            if (!res.lookup().isEmpty()) {
                this.validateJndiLookup(res.lookup(), injectionPoint);
            } else if (!res.name().isEmpty()) {
                this.validateJndiLookup("java:comp/env/" + res.name(), injectionPoint);
            }
        }
        ResourceReferenceFactory resourceReferenceFactory = this.getResourceReferenceFactory(injectionPoint);
        return resourceReferenceFactory;
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(String jndiName, String mappedName) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Object resolveResource(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Object resolveResource(String jndiName, String mappedName) {
        throw new UnsupportedOperationException();
    }

    public <T> ResourceReferenceFactory<T> registerWebServiceRefInjectionPoint(InjectionPoint injectionPoint) {
        if (BdaInjectionServicesImpl.isProducer(injectionPoint) && injectionPoint.getType() instanceof Class) {
            Class ipClass = (Class)injectionPoint.getType();
            WebServiceRef wsRef = (WebServiceRef)injectionPoint.getAnnotated().getAnnotation(WebServiceRef.class);
            this.validateWebServiceRef(wsRef, ipClass, injectionPoint);
        }
        ResourceReferenceFactory<T> resourceReferenceFactory = this.getResourceReferenceFactory(injectionPoint);
        return resourceReferenceFactory;
    }

    public ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(InjectionPoint injectionPoint) {
        Class ipClass;
        if (BdaInjectionServicesImpl.isProducer(injectionPoint) && injectionPoint.getType() instanceof Class && !(ipClass = (Class)injectionPoint.getType()).isAssignableFrom(EntityManager.class)) {
            BdaInjectionServicesImpl.throwDefinitionException(injectionPoint, ipClass);
        }
        ResourceReferenceFactory resourceReferenceFactory = this.getResourceReferenceFactory(injectionPoint);
        return resourceReferenceFactory;
    }

    public ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(InjectionPoint injectionPoint) {
        Class ipClass;
        if (BdaInjectionServicesImpl.isProducer(injectionPoint) && injectionPoint.getType() instanceof Class && !(ipClass = (Class)injectionPoint.getType()).isAssignableFrom(EntityManagerFactory.class)) {
            BdaInjectionServicesImpl.throwDefinitionException(injectionPoint, ipClass);
        }
        ResourceReferenceFactory resourceReferenceFactory = this.getResourceReferenceFactory(injectionPoint);
        return resourceReferenceFactory;
    }

    @Deprecated
    public EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    public void cleanup() {
    }
}

