/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositePropertyContainer;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeValue;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyListener;
import com.netflix.archaius.property.ListenerManager;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicStampedReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class CachedCompositeProperty<T>
implements Property<T> {
    private static final TraceComponent tc = Tr.register(CachedCompositeProperty.class);
    private final AtomicStampedReference<CachedCompositeValue<T>> cache = new AtomicStampedReference<Object>(null, -1);
    private final Class<T> type;
    private final CachedCompositePropertyContainer parentContainer;
    static final long serialVersionUID = 7571610483319974015L;

    CachedCompositeProperty(Class<T> type, CachedCompositePropertyContainer parentContainer) {
        this.type = type;
        this.parentContainer = parentContainer;
    }

    public void addListener(final PropertyListener<T> listener) {
        this.parentContainer.addListener(listener, new ListenerManager.ListenerUpdater(){
            private final AtomicReference<T> last = new AtomicReference<Object>(null);
            static final long serialVersionUID = 4337203540876017065L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            public void update() {
                Object value;
                Object prev = this.last.get();
                try {
                    value = CachedCompositeProperty.this.get();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeProperty$1", (String)"63", (Object)this, (Object[])new Object[0]);
                    listener.onParseError((Throwable)e);
                    return;
                }
                if (prev != value && this.last.compareAndSet(prev, value)) {
                    listener.onChange(value);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    public void removeListener(PropertyListener<T> listener) {
        this.parentContainer.removeListener(listener);
    }

    public String getKey() {
        return this.parentContainer.getKey();
    }

    /*
     * WARNING - void declaration
     */
    public CachedCompositeValue<T> getSourced() {
        boolean fromCache = true;
        int cacheVersion = this.cache.getStamp();
        int latestVersion = this.parentContainer.getMasterVersion();
        CachedCompositeValue<T> compositeValue = null;
        if (cacheVersion != latestVersion) {
            CachedCompositeValue<T> currentValue = this.cache.getReference();
            CachedCompositeValue<T> newValue = null;
            try {
                newValue = this.resolveCurrent();
            }
            catch (ConfigException configException) {
                void e;
                FFDCFilter.processException((Throwable)configException, (String)"com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeProperty", (String)"105", (Object)this, (Object[])new Object[0]);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeProperty", (String)"107", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"get", (Object[])new Object[]{"Unable to get current version of property '" + this.parentContainer.getKey() + "'", e});
                }
                throw new ConfigException(e);
            }
            if (this.cache.compareAndSet(currentValue, newValue, cacheVersion, latestVersion)) {
                compositeValue = newValue;
                fromCache = false;
            }
        }
        if (fromCache) {
            compositeValue = this.cache.getReference();
        }
        return compositeValue;
    }

    public T get() {
        CachedCompositeValue<T> compositeValue = this.getSourced();
        T actual = null;
        if (compositeValue != null) {
            actual = compositeValue.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (compositeValue != null) {
                Tr.debug((TraceComponent)tc, (String)"get", (Object[])new Object[]{"Key={0}, Value={1}, Source={2}", this.getKey(), compositeValue.getValue(), compositeValue.getSource()});
            } else {
                Tr.debug((TraceComponent)tc, (String)"get", (Object[])new Object[]{"Key={0} not found", this.getKey()});
            }
        }
        return actual;
    }

    protected abstract CachedCompositeValue<T> resolveCurrent() throws Exception;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachedCompositeProperty other = (CachedCompositeProperty)obj;
        return this.type == other.type;
    }
}

