/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositePropertyContainer;
import com.ibm.ws.microprofile.config.archaius.impl.CompositeConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.property.ListenerManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CachedCompositePropertyFactory
implements ConfigListener {
    private final CompositeConfig config;
    private final ConcurrentMap<String, CachedCompositePropertyContainer> cache = new ConcurrentHashMap<String, CachedCompositePropertyContainer>();
    private final AtomicInteger version = new AtomicInteger();
    private final ListenerManager listeners = new ListenerManager();
    static final long serialVersionUID = -2721358886784184888L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CachedCompositePropertyFactory(CompositeConfig config) {
        this.config = config;
        this.config.addListener(this);
    }

    public CachedCompositePropertyContainer getProperty(String propName) {
        CachedCompositePropertyContainer existing;
        CachedCompositePropertyContainer container = (CachedCompositePropertyContainer)this.cache.get(propName);
        if (container == null && (existing = this.cache.putIfAbsent(propName, container = new CachedCompositePropertyContainer(propName, this.config, this.version, this.listeners))) != null) {
            return existing;
        }
        return container;
    }

    public void onConfigAdded(Config config) {
        this.invalidate();
    }

    public void onConfigRemoved(Config config) {
        this.invalidate();
    }

    public void onConfigUpdated(Config config) {
        this.invalidate();
    }

    public void onError(Throwable error, Config config) {
    }

    public void invalidate() {
        this.version.incrementAndGet();
        this.listeners.updateAll();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CachedCompositePropertyFactory.class);
    }
}

