/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.config.impl.ConfigSourceComparator;
import com.ibm.ws.microprofile.config.impl.SortedSources;
import com.ibm.ws.microprofile.config.interfaces.DefaultConverters;
import com.ibm.ws.microprofile.config.interfaces.DefaultSources;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class ConfigBuilderImpl
implements ConfigBuilder {
    private static final TraceComponent tc = Tr.register(ConfigBuilderImpl.class);
    private final Map<Type, List<Converter<?>>> userConverters = new HashMap();
    private final TreeSet<ConfigSource> userSources = new TreeSet<ConfigSource>(ConfigSourceComparator.INSTANCE);
    private ClassLoader classloader;
    private boolean addDefaultSources = false;
    private boolean addDiscoveredSources = false;
    private boolean addDefaultConverters = false;
    private boolean addDiscoveredConverters = false;
    private final ScheduledExecutorService executor;
    static final long serialVersionUID = -7428171612228187900L;

    public ConfigBuilderImpl(ClassLoader classLoader, ScheduledExecutorService executor) {
        this.classloader = classLoader;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder addDefaultSources() {
        ConfigBuilderImpl configBuilderImpl = this;
        synchronized (configBuilderImpl) {
            this.addDefaultSources = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder addDiscoveredSources() {
        ConfigBuilderImpl configBuilderImpl = this;
        synchronized (configBuilderImpl) {
            this.addDiscoveredSources = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder addDefaultConverters() {
        ConfigBuilderImpl configBuilderImpl = this;
        synchronized (configBuilderImpl) {
            this.addDefaultConverters = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder addDiscoveredConverters() {
        ConfigBuilderImpl configBuilderImpl = this;
        synchronized (configBuilderImpl) {
            this.addDiscoveredConverters = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder forClassLoader(ClassLoader loader) {
        ConfigBuilderImpl configBuilderImpl = this;
        synchronized (configBuilderImpl) {
            if (loader == null) {
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"null.classloader.CWMCG0002E", (Object[])new Object[0]));
            }
            this.classloader = loader;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder withSources(ConfigSource ... sources) {
        ConfigBuilderImpl configBuilderImpl = this;
        synchronized (configBuilderImpl) {
            for (ConfigSource source : sources) {
                this.addSource(source);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigBuilder withConverters(Converter<?> ... converters) {
        ConfigBuilderImpl configBuilderImpl = this;
        synchronized (configBuilderImpl) {
            for (Converter<?> con : converters) {
                this.addConverter(con);
            }
        }
        return this;
    }

    protected SortedSources getSources() {
        SortedSources sources = new SortedSources(this.userSources);
        if (this.addDefaultSources) {
            sources.addAll(DefaultSources.getDefaultSources(this.getClassLoader()));
        }
        if (this.addDiscoveredSources) {
            sources.addAll(DefaultSources.getDiscoveredSources(this.getClassLoader()));
        }
        sources = sources.unmodifiable();
        return sources;
    }

    protected Map<Type, Converter<?>> getConverters() {
        HashMap<Type, Converter<?>> converters = new HashMap();
        HashMap allConverters = new HashMap();
        if (this.addDefaultConverters) {
            ConfigBuilderImpl.addConverters(allConverters, DefaultConverters.getDefaultConverters());
        }
        if (this.addDiscoveredConverters) {
            ConfigBuilderImpl.addConverters(allConverters, DefaultConverters.getDiscoveredConverters(this.getClassLoader()));
        }
        ConfigBuilderImpl.addConverterLists(allConverters, this.userConverters);
        for (Map.Entry entry : allConverters.entrySet()) {
            Type type = (Type)entry.getKey();
            List typeConverters = (List)entry.getValue();
            Converter highest = null;
            int highestPriority = Integer.MIN_VALUE;
            if (typeConverters.size() == 1) {
                highest = (Converter)typeConverters.get(0);
            } else {
                for (Converter converter : typeConverters) {
                    int value = 100;
                    Priority[] priorities = (Priority[])converter.getClass().getDeclaredAnnotationsByType(Priority.class);
                    if (priorities != null && priorities.length > 0) {
                        Priority priority = priorities[0];
                        value = priority.value();
                    }
                    if (value < highestPriority) continue;
                    highest = converter;
                    highestPriority = value;
                }
            }
            if (highest == null) continue;
            converters.put(type, highest);
        }
        converters = Collections.unmodifiableMap(converters);
        return converters;
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return this.executor;
    }

    protected long getRefreshInterval() {
        long refreshInterval = 500L;
        String refreshProp = ConfigBuilderImpl.getRefreshRateSystemProperty();
        if (refreshProp != null && !"".equals(refreshProp)) {
            refreshInterval = Long.parseLong(refreshProp);
        }
        if (refreshInterval > 0L && refreshInterval < 500L) {
            refreshInterval = 500L;
        }
        return refreshInterval;
    }

    private static String getRefreshRateSystemProperty() {
        String prop = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 9082417321984868065L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("microprofile.config.refresh.rate");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return prop;
    }

    private static void addConverterLists(Map<Type, List<Converter<?>>> converters, Map<Type, List<Converter<?>>> additions) {
        for (Map.Entry<Type, List<Converter<?>>> entry : additions.entrySet()) {
            Type type = entry.getKey();
            List<Converter<?>> converterList = entry.getValue();
            for (Converter<?> converter : converterList) {
                ConfigBuilderImpl.addConverter(converters, type, converter);
            }
        }
    }

    private static void addConverters(Map<Type, List<Converter<?>>> converters, Map<Type, Converter<?>> additions) {
        for (Map.Entry<Type, Converter<?>> entry : additions.entrySet()) {
            Type type = entry.getKey();
            Converter<?> converter = entry.getValue();
            ConfigBuilderImpl.addConverter(converters, type, converter);
        }
    }

    private static void addConverter(Map<Type, List<Converter<?>>> converters, Type type, Converter<?> converter) {
        List<Converter<?>> converterList = converters.get(type);
        if (converterList == null) {
            converterList = new ArrayList();
            converters.put(type, converterList);
        }
        converterList.add(converter);
    }

    private void addSource(ConfigSource source) {
        this.userSources.add(source);
    }

    private void addConverter(Converter<?> converter) {
        Type type = DefaultConverters.getConverterType(converter);
        ConfigBuilderImpl.addConverter(this.userConverters, type, converter);
    }

    private ClassLoader getClassLoader() {
        return this.classloader;
    }
}

