/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.microprofile.config.interfaces.ConversionException;
import com.ibm.ws.microprofile.config.interfaces.ConverterNotFoundException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.spi.Converter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConversionManager {
    private static final TraceComponent tc = Tr.register(ConversionManager.class);
    private final Map<Type, Converter<?>> converters = new HashMap();
    static final long serialVersionUID = -7898853630301367205L;

    public ConversionManager(Map<Type, Converter<?>> converters) {
        this.converters.putAll(converters);
    }

    /*
     * WARNING - void declaration
     */
    public Object convert(String rawString, Type type) {
        Converter<?> converter;
        Object converted = null;
        boolean converterFound = false;
        if (this.converters.containsKey(type) && (converter = this.converters.get(type)) != null) {
            converterFound = true;
            try {
                converted = converter.convert(rawString);
            }
            catch (ConversionException conversionException) {
                void e;
                FFDCFilter.processException((Throwable)conversionException, (String)"com.ibm.ws.microprofile.config.impl.ConversionManager", (String)"65", (Object)this, (Object[])new Object[]{rawString, type});
                throw e;
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config.impl.ConversionManager", (String)"67", (Object)this, (Object[])new Object[]{rawString, type});
                throw new ConversionException(Tr.formatMessage((TraceComponent)tc, (String)"conversion.exception.CWMCG0007E", (Object[])new Object[]{converter.getClass().getName(), rawString, e}));
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config.impl.ConversionManager", (String)"69", (Object)this, (Object[])new Object[]{rawString, type});
                throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"conversion.exception.CWMCG0007E", (Object[])new Object[]{converter.getClass().getName(), rawString, e}));
            }
            if (converted == null && TraceComponent.isAnyTracingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The converted value is null. The rawString is " + rawString), (Object[])new Object[0]);
            }
        }
        if (!converterFound && type instanceof Class) {
            Class requestedClazz = (Class)type;
            if (requestedClazz.isArray()) {
                Class<?> arrayType = requestedClazz.getComponentType();
                converted = this.convertArray(rawString, arrayType);
                converterFound = true;
            } else {
                ConversionStatus cs = this.convertCompatible(rawString, requestedClazz);
                converterFound = cs.isConverterFound();
                converted = cs.getConverted();
            }
        }
        if (!converterFound) {
            throw new ConverterNotFoundException(Tr.formatMessage((TraceComponent)tc, (String)"could.not.find.converter.CWMCG0014E", (Object[])new Object[]{type.getTypeName()}));
        }
        return converted;
    }

    private <T> ConversionStatus<T> convertCompatible(String rawString, Class<T> type) {
        Object converted = null;
        ConversionStatus<T> cs = null;
        boolean converterFound = false;
        for (Map.Entry<Type, Converter<?>> con : this.converters.entrySet()) {
            TypeVariable typeVariable;
            Type key = con.getKey();
            if (key instanceof Class) {
                Class clazz = (Class)key;
                if (!type.isAssignableFrom(clazz)) continue;
                converted = this.convert(rawString, key);
                converterFound = true;
                break;
            }
            if (!(key instanceof TypeVariable) || (cs = this.convertGenericClazz(rawString, type, typeVariable = (TypeVariable)key)).getConverted() == null) continue;
            converterFound = cs.isConverterFound();
            converted = cs.getConverted();
            break;
        }
        ConversionStatus<Object> csToReturn = new ConversionStatus<Object>(converterFound, converted);
        return csToReturn;
    }

    private <T> ConversionStatus<T> convertGenericClazz(String rawString, Class<T> type, TypeVariable<?> typeVariable) {
        AnnotatedType[] bounds;
        Object converted = null;
        boolean converterFound = false;
        for (AnnotatedType bound : bounds = typeVariable.getAnnotatedBounds()) {
            Class bClazz;
            Type bType = bound.getType();
            if (!(bType instanceof Class) || !(bClazz = (Class)bType).isAssignableFrom(type)) continue;
            converterFound = true;
            converted = this.convert(rawString, typeVariable);
            break;
        }
        ConversionStatus<Object> cs = new ConversionStatus<Object>(converterFound, converted);
        return cs;
    }

    private <T> T[] convertArray(String rawString, Class<T> arrayType) {
        String[] elements = rawString.split(",");
        Object rawArray = Array.newInstance(arrayType, elements.length);
        Object[] array = (Object[])rawArray;
        for (int i = 0; i < elements.length; ++i) {
            array[i] = this.convert(elements[i], arrayType);
        }
        return array;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class ConversionStatus<T> {
        boolean converterFound = false;
        T converted;
        static final long serialVersionUID = 1478099677873440616L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ConversionStatus(boolean foundConverter, T converted) {
            this.converted = converted;
            this.converterFound = foundConverter;
        }

        boolean isConverterFound() {
            return this.converterFound;
        }

        T getConverted() {
            return this.converted;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConversionStatus.class);
        }
    }
}

