/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import org.apache.yoko.orb.OB.Assert;

class POAControl {
    private static final int DestroyNotCalled = 0;
    private static final int DestroyPending = 1;
    private static final int DestroyInProgress = 2;
    private static final int DestroyCompleted = 3;
    private int state_ = 0;
    private boolean etherealize_ = false;
    private int requests_ = 0;

    POAControl() {
    }

    synchronized boolean markDestroyPending(boolean etherealize, boolean waitForCompletion) {
        if (this.state_ != 0) {
            while (waitForCompletion && this.state_ != 3) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return false;
        }
        this.etherealize_ = etherealize;
        this.state_ = 1;
        return true;
    }

    synchronized boolean incrementRequestCount() {
        if (this.state_ != 0) {
            while (this.state_ != 3) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return false;
        }
        ++this.requests_;
        return true;
    }

    synchronized boolean decrementRequestCount() {
        Assert._OB_assert(this.requests_ > 0);
        --this.requests_;
        if (this.requests_ == 0) {
            this.notifyAll();
            if (this.state_ == 1) {
                return true;
            }
        }
        return false;
    }

    synchronized boolean waitPendingRequests() {
        while (this.requests_ > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.state_ != 1) {
            return false;
        }
        this.state_ = 2;
        return true;
    }

    synchronized boolean hasPendingRequests() {
        return this.requests_ > 0;
    }

    synchronized boolean getDestroyed() {
        return this.state_ == 3;
    }

    synchronized void markDestroyCompleted() {
        this.state_ = 3;
        this.notifyAll();
    }

    synchronized boolean etherealize() {
        return this.etherealize_;
    }
}

